/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity;

import com.ovinter.mythsandlegends.Config;
import com.ovinter.mythsandlegends.entity.MLEntity;
import com.ovinter.mythsandlegends.entity.boss.BossPhase;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;

public class AbstractBoss
extends MLEntity
implements BossPhase {
    private float healthPercentage;
    private static final EntityDataAccessor<Integer> DATA_SPAWN_TICKS = SynchedEntityData.defineId(AbstractBoss.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_BOSS_PHASE = SynchedEntityData.defineId(AbstractBoss.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> DATA_HEALTH_PERCENTAGE = SynchedEntityData.defineId(AbstractBoss.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public ServerBossEvent bossEvent = (ServerBossEvent)new ServerBossEvent(this.getDisplayName(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS).setDarkenScreen(true);

    public AbstractBoss(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.xpReward = 150;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(DATA_SPAWN_TICKS, (Object)40);
        pBuilder.define(DATA_BOSS_PHASE, (Object)1);
        pBuilder.define(DATA_HEALTH_PERCENTAGE, (Object)Float.valueOf((float)Config.BLACK_CHARRO_HEALTH.getAsDouble()));
    }

    @Override
    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.setSpawnTicks(pCompound.getInt("SpawnTicks"));
        this.setBossPhase(pCompound.getInt("Phase"));
        this.setHealthPercentage(pCompound.getFloat("HealthPercentage"));
    }

    @Override
    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putInt("SpawnTicks", this.getSpawnTicks());
        pCompound.putInt("Phase", this.getBossPhase());
        pCompound.putFloat("HealthPercentage", this.getHealthPercentage());
    }

    public void tick() {
        super.tick();
        this.handlePhase();
    }

    public boolean hurt(DamageSource source, float amount) {
        this.setHealthPercentage(this.getHealthPercentage() / this.getMaxHealth());
        return super.hurt(source, amount);
    }

    protected void customServerAiStep() {
        this.bossEvent.setProgress(this.getHealthPercentage());
        if (this.getSpawnTicks() > 0) {
            this.setSpawnTicks(this.getSpawnTicks() - 1);
        }
        super.customServerAiStep();
    }

    public void setCustomName(@Nullable Component pName) {
        this.bossEvent.setName(this.getDisplayName());
        super.setCustomName(pName);
    }

    public void startSeenByPlayer(ServerPlayer pServerPlayer) {
        this.bossEvent.addPlayer(pServerPlayer);
        super.startSeenByPlayer(pServerPlayer);
    }

    public void stopSeenByPlayer(ServerPlayer pServerPlayer) {
        this.bossEvent.removePlayer(pServerPlayer);
        super.stopSeenByPlayer(pServerPlayer);
    }

    public void setSpawnTicks(int pTicks) {
        this.entityData.set(DATA_SPAWN_TICKS, (Object)pTicks);
    }

    public int getSpawnTicks() {
        return (Integer)this.entityData.get(DATA_SPAWN_TICKS);
    }

    public void setBossPhase(int pBossPhase) {
        this.entityData.set(DATA_BOSS_PHASE, (Object)pBossPhase);
    }

    public int getBossPhase() {
        return (Integer)this.entityData.get(DATA_BOSS_PHASE);
    }

    public void setHealthPercentage(float pPercentage) {
        this.entityData.set(DATA_HEALTH_PERCENTAGE, (Object)Float.valueOf(pPercentage));
    }

    public float getHealthPercentage() {
        return ((Float)this.entityData.get(DATA_HEALTH_PERCENTAGE)).floatValue();
    }

    @Override
    PlayState movementPredicate(AnimationState<?> state) {
        return null;
    }

    @Override
    PlayState attackPredicate(AnimationState<?> state) {
        return null;
    }

    @Override
    void setConfigAttributes() {
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return null;
    }

    public void handlePhase() {
        if (this.getHealthPercentage() > 0.75f) {
            this.setBossPhase(1);
        } else if (this.getHealthPercentage() > 0.4f) {
            this.setBossPhase(2);
        } else {
            this.setBossPhase(3);
        }
    }
}

