/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity;

import com.ovinter.mythsandlegends.Config;
import com.ovinter.mythsandlegends.api.util.ParticleGeneratorHelper;
import com.ovinter.mythsandlegends.api.util.SendMessageToPlayerHelper;
import com.ovinter.mythsandlegends.config.DefaultMobAttributes;
import com.ovinter.mythsandlegends.entity.AbstractBoss;
import com.ovinter.mythsandlegends.entity.CondemnedEntity;
import com.ovinter.mythsandlegends.entity.ai.goal.black_charro.FuneralBalladGoal;
import com.ovinter.mythsandlegends.entity.ai.goal.black_charro.ShadowStepGoal;
import com.ovinter.mythsandlegends.entity.ai.goal.generic.ChaseTargetGoal;
import com.ovinter.mythsandlegends.registry.MLSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BlackCharroEntityNew
extends AbstractBoss {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation IDLE = RawAnimation.begin().thenPlay("IDLE");
    private static final RawAnimation WALK = RawAnimation.begin().thenPlay("WALK");
    private static final RawAnimation SHOOT = RawAnimation.begin().thenPlay("SHOOT");
    private static final RawAnimation SUMMON_SKELETONS = RawAnimation.begin().thenPlay("SUMMON");
    private static final RawAnimation RAGE = RawAnimation.begin().thenPlay("RAGE");
    private static final RawAnimation ATTACK = RawAnimation.begin().thenPlay("ATTACK");
    private static final RawAnimation QUICK_LUNG_ATTACK = RawAnimation.begin().thenPlay("QUICK_LUNG");
    public static final RawAnimation SPAWN = RawAnimation.begin().thenPlay("SPAWN");
    public static final RawAnimation DEATH = RawAnimation.begin().thenPlay("DEATH");
    public static final RawAnimation TELEPORT = RawAnimation.begin().thenPlay("TELEPORT");
    public int SUMMON = 3;
    public int QUICK_LUNG = 4;
    private int combatMessageCooldown = 300;

    public BlackCharroEntityNew(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, DefaultMobAttributes.BLACK_CHARRO_HEALTH).add(Attributes.ARMOR, DefaultMobAttributes.BLACK_CHARRO_ARMOR).add(Attributes.ATTACK_DAMAGE, DefaultMobAttributes.BLACK_CHARRO_DAMAGE).add(Attributes.MOVEMENT_SPEED, DefaultMobAttributes.BLACK_CHARRO_MOVEMENT).add(Attributes.KNOCKBACK_RESISTANCE, DefaultMobAttributes.BLACK_CHARRO_KNOCKBACK_RESISTANCE).add(Attributes.FOLLOW_RANGE, DefaultMobAttributes.BLACK_CHARRO_FOLLOW_RANGE);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(8, (Goal)new ShadowStepGoal(this));
        this.goalSelector.addGoal(11, (Goal)new FuneralBalladGoal(this));
        this.goalSelector.addGoal(4, (Goal)new ChaseTargetGoal(this, false, 1.0));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractGolem.class, true));
    }

    @Override
    public void tick() {
        this.handleParticles();
        this.handleMessage();
        this.handlePhase();
        super.tick();
    }

    protected void tickDeath() {
        ++this.deathTime;
        if (this.deathTime == 50 && !this.level().isClientSide() && !this.isRemoved()) {
            this.level().broadcastEntityEvent((Entity)this, (byte)60);
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        this.setConfigAttributes();
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    public boolean isAlliedTo(Entity entity) {
        if (entity == this) {
            return true;
        }
        if (entity.getClass() == this.getClass()) {
            return true;
        }
        if (entity instanceof CondemnedEntity) {
            return true;
        }
        return super.isAlliedTo(entity);
    }

    public boolean isOnFire() {
        return false;
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
    }

    @NotNull
    protected SoundEvent getDeathSound() {
        return (SoundEvent)MLSounds.BLACK_CHARRO_DEATH.value();
    }

    @NotNull
    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)MLSounds.BLACK_CHARRO_HURT.value();
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return (SoundEvent)MLSounds.BLACK_CHARRO_AMBIENT.value();
    }

    public int getAmbientSoundInterval() {
        return 100;
    }

    public SoundEvent getRageSound() {
        return (SoundEvent)MLSounds.BLACK_CHARRO_RAGE.value();
    }

    public SoundEvent getSummonSound() {
        return (SoundEvent)MLSounds.BLACK_CHARRO_SUMMON.value();
    }

    public SoundEvent getRitualSound() {
        return (SoundEvent)MLSounds.BLACK_CHARRO_RITUAL.value();
    }

    public void playTeleportSound() {
        this.playSound((SoundEvent)MLSounds.BLACK_CHARRO_TELEPORT.value());
    }

    public float getTeleportChance() {
        return 0.25f;
    }

    @Override
    PlayState movementPredicate(AnimationState<?> state) {
        if (this.isDeadOrDying()) {
            return state.setAndContinue(DEATH);
        }
        if (this.getSpawnTicks() > 0) {
            return state.setAndContinue(SPAWN);
        }
        return state.isMoving() ? state.setAndContinue(WALK) : state.setAndContinue(IDLE);
    }

    @Override
    PlayState attackPredicate(AnimationState<?> state) {
        if (this.isDeadOrDying()) {
            return PlayState.STOP;
        }
        if (this.getAnimationId() == this.QUICK_LUNG) {
            return state.setAndContinue(QUICK_LUNG_ATTACK);
        }
        return PlayState.CONTINUE;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "movementController", 3, this::movementPredicate).triggerableAnim("teleport", TELEPORT));
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    @Override
    void setConfigAttributes() {
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(Config.BLACK_CHARRO_HEALTH.getAsDouble());
        this.getAttribute(Attributes.ARMOR).setBaseValue(Config.BLACK_CHARRO_ARMOR.getAsDouble());
        this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(Config.BLACK_CHARRO_DAMAGE.getAsDouble());
        this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(Config.BLACK_CHARRO_MOVEMENT.getAsDouble());
        this.getAttribute(Attributes.KNOCKBACK_RESISTANCE).setBaseValue(Config.BLACK_CHARRO_KNOCKBACK_RESISTANCE.getAsDouble());
        this.setHealth((float)Config.BLACK_CHARRO_HEALTH.getAsDouble());
    }

    void handleMessage() {
        LivingEntity livingEntity;
        if (this.combatMessageCooldown > 0) {
            --this.combatMessageCooldown;
        } else if (!this.isDeadOrDying() && (livingEntity = this.getTarget()) instanceof Player) {
            Player player = (Player)livingEntity;
            SendMessageToPlayerHelper.sendRandomMessage("combat_message", player, 5);
            this.combatMessageCooldown = 300;
        }
    }

    void handleParticles() {
        if (this.getSpawnTicks() > 0 || this.isDeadOrDying()) {
            ParticleGeneratorHelper.generateEntitySpawnFromGroundParticles(this.level(), (LivingEntity)this);
        }
        if (this.level().isClientSide && this.getSpawnTicks() == 0 && this.isAlive()) {
            ParticleGeneratorHelper.generateSkullParticles((Entity)this);
        }
    }

    public boolean isValidTeleportLocation(double x, double y, double z) {
        BlockPos pos = new BlockPos((int)x, (int)y, (int)z);
        return this.level().getBlockState(pos).isAir() && this.level().getBlockState(pos.below()).isSolid();
    }
}

