/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity;

import com.ovinter.mythsandlegends.Config;
import com.ovinter.mythsandlegends.api.util.ParticleGeneratorHelper;
import com.ovinter.mythsandlegends.config.DefaultMobAttributes;
import com.ovinter.mythsandlegends.entity.MLEntity;
import com.ovinter.mythsandlegends.entity.ai.goal.candle_keeper.WaxExplosionGoal;
import com.ovinter.mythsandlegends.entity.ai.goal.generic.AnimatedMeleeAttackGoal;
import com.ovinter.mythsandlegends.entity.ai.goal.generic.ChaseTargetGoal;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class CandleKeeperEntity
extends MLEntity {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final RawAnimation IDLE_ANIM = RawAnimation.begin().thenLoop("IDLE");
    private final RawAnimation WALK_ANIM = RawAnimation.begin().thenLoop("WALK");
    private final RawAnimation ATTACK_ANIM = RawAnimation.begin().thenPlay("ATTACK");
    private final RawAnimation ATTACK_AOE_ANIM = RawAnimation.begin().thenPlay("ATTACK_AOE");
    private final RawAnimation RANGED_ATTACK_ANIM = RawAnimation.begin().thenPlay("RANGED_ATTACK");
    private final RawAnimation DEATH_ANIM = RawAnimation.begin().thenPlay("DEATH");
    public int AOE = 3;
    public int shootCooldown = 120;
    public int explodeCooldown = 300;

    public CandleKeeperEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.xpReward = 75;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, DefaultMobAttributes.CANDLE_KEEPER_HEALTH).add(Attributes.ATTACK_DAMAGE, DefaultMobAttributes.CANDLE_KEEPER_DAMAGE).add(Attributes.MOVEMENT_SPEED, DefaultMobAttributes.CANDLE_KEEPER_MOVEMENT_SPEED).add(Attributes.FOLLOW_RANGE, DefaultMobAttributes.CANDLE_KEEPER_FOLLOW_RANGE).add(Attributes.KNOCKBACK_RESISTANCE, 0.3);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new WaxExplosionGoal(this));
        this.goalSelector.addGoal(2, (Goal)new AnimatedMeleeAttackGoal(this, 20, 2, 4.0f));
        this.goalSelector.addGoal(2, (Goal)new ChaseTargetGoal(this, false, 1.2));
        this.targetSelector.addGoal(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractGolem.class, true));
    }

    public void tick() {
        if (this.shootCooldown > 0) {
            --this.shootCooldown;
        }
        if (this.explodeCooldown > 0) {
            --this.explodeCooldown;
        }
        super.tick();
    }

    protected void customServerAiStep() {
        if (this.getAttackTicks() > 0) {
            this.setAttackTicks(this.getAttackTicks() - 1);
        }
        super.customServerAiStep();
    }

    protected void tickDeath() {
        ++this.deathTime;
        if (this.deathTime == 25 && !this.level().isClientSide() && !this.isRemoved()) {
            this.level().broadcastEntityEvent((Entity)this, (byte)60);
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        this.setConfigAttributes();
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    @Override
    PlayState movementPredicate(AnimationState<?> state) {
        if (this.isDeadOrDying()) {
            return state.setAndContinue(this.DEATH_ANIM);
        }
        if (this.getAnimationId() == 2) {
            return state.setAndContinue(this.RANGED_ATTACK_ANIM);
        }
        if (this.getAnimationId() == this.AOE) {
            return state.setAndContinue(this.ATTACK_AOE_ANIM);
        }
        return state.isMoving() ? state.setAndContinue(this.WALK_ANIM) : state.setAndContinue(this.IDLE_ANIM);
    }

    @Override
    PlayState attackPredicate(AnimationState<?> state) {
        if (this.isDeadOrDying()) {
            return PlayState.STOP;
        }
        if (this.getAnimationId() == 1 && this.getAttackTicks() >= this.getAttackAnimationLength() - 1) {
            state.getController().forceAnimationReset();
            return state.setAndContinue(this.ATTACK_ANIM);
        }
        return PlayState.CONTINUE;
    }

    @Override
    void setConfigAttributes() {
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(((Double)Config.CANDLE_KEEPER_HEALTH.get()).doubleValue());
        this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(((Double)Config.CANDLE_KEEPER_DAMAGE.get()).doubleValue());
        this.setHealth((float)Config.CANDLE_KEEPER_HEALTH.getAsDouble());
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "movementController", 5, this::movementPredicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "attackController", 0, this::attackPredicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    public void spawnHeadFlameParticles(Level pLevel, Vector3d pPos) {
        ParticleGeneratorHelper.generateHeadParticles(pLevel, pPos);
    }
}

