/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity;

import com.ovinter.mythsandlegends.Config;
import com.ovinter.mythsandlegends.api.util.ParticleGeneratorHelper;
import com.ovinter.mythsandlegends.config.DefaultMobAttributes;
import com.ovinter.mythsandlegends.entity.BlackCharroEntityOld;
import com.ovinter.mythsandlegends.entity.MLEntity;
import com.ovinter.mythsandlegends.entity.ai.goal.generic.AnimatedMeleeAttackGoal;
import com.ovinter.mythsandlegends.entity.ai.goal.generic.ChaseTargetGoal;
import com.ovinter.mythsandlegends.registry.MLSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FleeSunGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RestrictSunGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class CondemnedEntity
extends MLEntity {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final RawAnimation SPAWN = RawAnimation.begin().thenPlay("SPAWN");
    private final RawAnimation IDLE = RawAnimation.begin().thenLoop("IDLE");
    private final RawAnimation WALK = RawAnimation.begin().thenLoop("WALK");
    private final RawAnimation ATTACK = RawAnimation.begin().thenPlay("ATTACK");
    private final RawAnimation DEATH = RawAnimation.begin().thenPlay("DEATH");
    private static final EntityDataAccessor<Integer> DATA_SPAWN_TICKS = SynchedEntityData.defineId(CondemnedEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public CondemnedEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.xpReward = 9;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, DefaultMobAttributes.CONDEMNED_HEALTH).add(Attributes.ATTACK_DAMAGE, DefaultMobAttributes.CONDEMNED_DAMAGE).add(Attributes.MOVEMENT_SPEED, DefaultMobAttributes.CONDEMNED_MOVEMENT).add(Attributes.FOLLOW_RANGE, DefaultMobAttributes.CONDEMNED_FOLLOW_RANGE);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(4, (Goal)new RestrictSunGoal((PathfinderMob)this));
        this.goalSelector.addGoal(5, (Goal)new FleeSunGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new AnimatedMeleeAttackGoal(this, 20, 3, 2.5f){

            @Override
            public boolean canUse() {
                return super.canUse() && CondemnedEntity.this.getSpawnTicks() == 0;
            }
        });
        this.goalSelector.addGoal(6, (Goal)new ChaseTargetGoal(this, false, 1.2));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 12.0f));
        this.goalSelector.addGoal(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(9, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[]{CondemnedEntity.class}));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(DATA_SPAWN_TICKS, (Object)40);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putInt("SpawnTicks", this.getSpawnTicks());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.setSpawnTicks(pCompound.getInt("SpawnTicks"));
    }

    public void tick() {
        if (this.getSpawnTicks() > 0 && this.level().isClientSide()) {
            ParticleGeneratorHelper.generateEntitySpawnFromGroundParticles(this.level(), (LivingEntity)this);
        }
        super.tick();
    }

    protected void customServerAiStep() {
        if (this.getSpawnTicks() > 0) {
            this.setSpawnTicks(this.getSpawnTicks() - 1);
        }
        if (this.getAttackTicks() > 0) {
            this.setAttackTicks(this.getAttackTicks() - 1);
        }
        super.customServerAiStep();
    }

    protected void tickDeath() {
        ++this.deathTime;
        if (this.deathTime == 15 && !this.level().isClientSide() && !this.isRemoved()) {
            this.level().broadcastEntityEvent((Entity)this, (byte)60);
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        this.setConfigAttributes();
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return (SoundEvent)MLSounds.CONDEMNED_AMBIENT.value();
    }

    @NotNull
    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)MLSounds.CONDEMNED_HURT.value();
    }

    @NotNull
    protected SoundEvent getDeathSound() {
        return (SoundEvent)MLSounds.CONDEMNED_DEATH.value();
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
    }

    public void aiStep() {
        boolean flag = this.isSunBurnTick();
        if (flag) {
            this.igniteForSeconds(2.0f);
        }
        super.aiStep();
    }

    public boolean isOnFire() {
        return super.isOnFire() && this.getSpawnTicks() == 0;
    }

    public boolean isAlliedTo(Entity entity) {
        if (entity == this) {
            return true;
        }
        if (entity.getClass() == this.getClass()) {
            return true;
        }
        if (entity instanceof BlackCharroEntityOld) {
            return true;
        }
        return super.isAlliedTo(entity);
    }

    public void travel(Vec3 pTravelVector) {
        if (this.getSpawnTicks() > 0) {
            if (this.getNavigation().getPath() != null) {
                this.getNavigation().stop();
            }
            super.travel(Vec3.ZERO);
            return;
        }
        super.travel(pTravelVector);
    }

    public boolean isInvulnerable() {
        return this.getSpawnTicks() > 0;
    }

    public boolean isInvulnerableTo(DamageSource pSource) {
        return this.getSpawnTicks() > 0 || pSource.is(DamageTypeTags.IS_EXPLOSION);
    }

    public void setSpawnTicks(int pSpawnTimer) {
        this.getEntityData().set(DATA_SPAWN_TICKS, (Object)pSpawnTimer);
    }

    public int getSpawnTicks() {
        return (Integer)this.getEntityData().get(DATA_SPAWN_TICKS);
    }

    @Override
    PlayState movementPredicate(AnimationState<?> state) {
        if (this.getSpawnTicks() > 0) {
            return state.setAndContinue(this.SPAWN);
        }
        return state.isMoving() && this.getSpawnTicks() <= 0 ? state.setAndContinue(this.WALK) : state.setAndContinue(this.IDLE);
    }

    @Override
    PlayState attackPredicate(AnimationState<?> state) {
        if (this.getAnimationId() == 1 && this.getAttackTicks() == 19 && this.isAlive() && this.getSpawnTicks() == 0) {
            state.getController().forceAnimationReset();
            return state.setAndContinue(this.ATTACK);
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", 0, this::movementPredicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "deathController", 0, state -> {
            if (this.isDeadOrDying() || (double)this.getHealth() < 0.01) {
                state.getController().setAnimation(this.DEATH);
            }
            return PlayState.CONTINUE;
        }));
        controllers.add(new AnimationController((GeoAnimatable)this, "attackController", 2, this::attackPredicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    @Override
    void setConfigAttributes() {
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(((Double)Config.CONDEMNED_HEALTH.get()).doubleValue());
        this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(((Double)Config.CONDEMNED_DAMAGE.get()).doubleValue());
        this.setHealth((float)Config.CONDEMNED_HEALTH.getAsDouble());
    }
}

