/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity;

import com.ovinter.mythsandlegends.Config;
import com.ovinter.mythsandlegends.api.util.ParticleGeneratorHelper;
import com.ovinter.mythsandlegends.api.util.SendMessageToPlayerHelper;
import com.ovinter.mythsandlegends.config.DefaultMobAttributes;
import com.ovinter.mythsandlegends.entity.MLEntity;
import com.ovinter.mythsandlegends.entity.ai.goal.gargoyle.AwakeStateGoal;
import com.ovinter.mythsandlegends.entity.ai.goal.generic.AnimatedMeleeAttackGoal;
import com.ovinter.mythsandlegends.entity.ai.goal.generic.ChaseTargetGoal;
import com.ovinter.mythsandlegends.registry.MLEffects;
import com.ovinter.mythsandlegends.registry.MLItems;
import com.ovinter.mythsandlegends.registry.MLSounds;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.scores.PlayerTeam;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class GargoyleEntity
extends MLEntity {
    AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation IDLE_ANIM = RawAnimation.begin().thenLoop("IDLE");
    private static final RawAnimation IDLE_AWAKE_ANIM = RawAnimation.begin().thenLoop("IDLE_AWAKE");
    private static final RawAnimation WALK_ANIM = RawAnimation.begin().thenLoop("WALK");
    private static final RawAnimation ATTACK_ANIM = RawAnimation.begin().thenPlay("ATTACK");
    private static final RawAnimation SHOCKWAVE_ATTACK_ANIM = RawAnimation.begin().thenPlay("SHOCKWAVE_ATTACK");
    private static final RawAnimation RANGED_ATTACK_ANIM = RawAnimation.begin().thenPlay("RANGED_ATTACK");
    private static final RawAnimation HEAD_JAW_ANIM = RawAnimation.begin().thenLoop("HEAD_JAW");
    private static final RawAnimation WINGS_IDLE_AWAKE_ANIM = RawAnimation.begin().thenLoop("WINGS_IDLE_AWAKE");
    private static final RawAnimation WINGS_WALKING_ANIM = RawAnimation.begin().thenLoop("WINGS_WALKING");
    private static final RawAnimation WINGS_ATTACKING_ANIM = RawAnimation.begin().thenLoop("WINGS_ATTACKING");
    private static final RawAnimation DEATH_ANIM = RawAnimation.begin().thenPlay("DEATH");
    private static final EntityDataAccessor<Boolean> DATA_IS_AWAKE = SynchedEntityData.defineId(GargoyleEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> DATA_VARIANT = SynchedEntityData.defineId(GargoyleEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Optional<UUID>> DATA_OWNER_UUID = SynchedEntityData.defineId(GargoyleEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    public static int SHOCKWAVE = 3;
    public static int shockwaveCooldown = DefaultMobAttributes.GARGOYLE_ABILITY_COOLDOWN;
    public int rangedCooldown = DefaultMobAttributes.GARGOYLE_ABILITY_COOLDOWN;

    public GargoyleEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.xpReward = 18;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, DefaultMobAttributes.GARGOYLE_HEALTH).add(Attributes.ATTACK_DAMAGE, DefaultMobAttributes.GARGOYLE_DAMAGE).add(Attributes.MOVEMENT_SPEED, DefaultMobAttributes.GARGOYLE_MOVEMENT).add(Attributes.ATTACK_KNOCKBACK, DefaultMobAttributes.GARGOYLE_ATTACK_KNOCKBACK).add(Attributes.KNOCKBACK_RESISTANCE, DefaultMobAttributes.GARGOYLE_KNOCKBACK_RESISTANCE).add(Attributes.FOLLOW_RANGE, DefaultMobAttributes.GARGOYLE_FOLLOW_RANGE);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(DATA_IS_AWAKE, (Object)false);
        pBuilder.define(DATA_VARIANT, (Object)0);
        pBuilder.define(DATA_OWNER_UUID, Optional.empty());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        if (pCompound.contains("IsAwake")) {
            this.setAwake(pCompound.getBoolean("IsAwake"));
        }
        this.entityData.set(DATA_VARIANT, (Object)pCompound.getInt("Variant"));
        if (pCompound.hasUUID("OwnerUUID")) {
            this.setOwner(pCompound.getUUID("OwnerUUID"));
        }
    }

    @Override
    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putBoolean("IsAwake", this.isAwake());
        pCompound.putInt("Variant", this.getVariant());
        this.getPersistentData().putInt("Variant", this.getVariant());
        if (this.getOwnerUUID() != null) {
            pCompound.putUUID("OwnerUUID", this.getOwnerUUID());
        }
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new AwakeStateGoal(this));
        this.goalSelector.addGoal(4, (Goal)new ShockwaveAttackGoal(this));
        this.goalSelector.addGoal(5, (Goal)new AnimatedMeleeAttackGoal(this, 20, 3, 2.7f));
        this.goalSelector.addGoal(5, (Goal)new ChaseTargetGoal(this, false, 1.2));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 12.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 1, true, false, target -> {
            UUID owner = this.getOwnerUUID();
            return owner == null || !target.getUUID().equals(owner);
        }));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractGolem.class, true));
    }

    public void tick() {
        if (shockwaveCooldown > 0) {
            --shockwaveCooldown;
        }
        if (this.rangedCooldown > 0) {
            --this.rangedCooldown;
        }
        if (this.level().isNight()) {
            this.setAwake(true);
        }
        super.tick();
    }

    protected void customServerAiStep() {
        if (this.getAttackTicks() > 0) {
            this.setAttackTicks(this.getAttackTicks() - 1);
        }
        super.customServerAiStep();
    }

    protected void tickDeath() {
        ++this.deathTime;
        if (this.deathTime == 25 && !this.level().isClientSide() && !this.isRemoved()) {
            this.level().broadcastEntityEvent((Entity)this, (byte)60);
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        if (this.isNether()) {
            this.setVariant(1);
        } else {
            this.setVariant(0);
        }
        float malus = this.getVariant() == 1 ? 0.0f : 1.0f;
        this.setPathfindingMalus(PathType.LAVA, malus);
        this.setPathfindingMalus(PathType.DANGER_FIRE, malus);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, malus);
        this.setConfigAttributes();
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (this.getOwnerUUID() == null) {
            return InteractionResult.PASS;
        }
        ItemStack itemStack = player.getItemInHand(hand);
        if (itemStack.is(MLItems.GARGOYLE_FRAGMENT)) {
            float health = this.getHealth();
            this.heal(10.0f);
            if (this.getHealth() == health) {
                return InteractionResult.PASS;
            }
            this.playSound((SoundEvent)MLSounds.RUPTURE_BURST.value(), 1.0f, 1.0f);
            itemStack.consume(1, (LivingEntity)player);
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        if (this.getVariant() == 0 && itemStack.is(Items.LAVA_BUCKET)) {
            player.playSound(SoundEvents.BUCKET_EMPTY_LAVA, 1.0f, 1.0f);
            ItemStack itemStackResult = ItemUtils.createFilledResult((ItemStack)itemStack, (Player)player, (ItemStack)BucketItem.getEmptySuccessItem((ItemStack)itemStack, (Player)player));
            player.setItemInHand(hand, itemStackResult);
            this.setVariant(1);
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return super.mobInteract(player, hand);
    }

    public boolean isPushable() {
        return false;
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        LivingEntity livingEntity;
        Entity entity;
        if ((pSource.is(DamageTypes.MOB_ATTACK) || pSource.is(DamageTypes.PLAYER_ATTACK)) && (entity = pSource.getEntity()) instanceof LivingEntity && this.canBeHurtWithPickaxe(livingEntity = (LivingEntity)entity)) {
            pAmount *= 1.2f;
        }
        return super.hurt(pSource, pAmount);
    }

    public boolean isInvulnerableTo(DamageSource pSource) {
        LivingEntity livingEntity;
        Entity entity = pSource.getEntity();
        if (entity instanceof LivingEntity && this.canBeHurtWithPickaxe(livingEntity = (LivingEntity)entity)) {
            return false;
        }
        return !this.isAwake() || pSource.is(DamageTypeTags.IS_PROJECTILE) || pSource.is(DamageTypeTags.IS_FIRE) || pSource.is(DamageTypeTags.IS_FREEZING) || pSource.is(DamageTypeTags.IS_DROWNING);
    }

    public boolean doHurtTarget(Entity pEntity) {
        boolean success = super.doHurtTarget(pEntity);
        if (success && pEntity instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)pEntity;
            double petrifiedChance = 0.15;
            if (this.level().random.nextDouble() < petrifiedChance) {
                this.applyDebuffEffect(target);
            }
            this.playAttackSound();
        }
        return success;
    }

    public boolean canBeCollidedWith() {
        return !this.isAwake();
    }

    public boolean isInvulnerable() {
        return !this.isAwake();
    }

    public boolean isPushedByFluid(FluidType pType) {
        return false;
    }

    public boolean isAffectedByPotions() {
        return false;
    }

    public void handleEntityEvent(byte pId) {
        if (pId == 69 && !this.isDeadOrDying()) {
            ParticleGeneratorHelper.generateShockwaveParticles(this.level(), (LivingEntity)this, 5.0);
        } else {
            super.handleEntityEvent(pId);
        }
    }

    public void setAwake(boolean pAwake) {
        this.entityData.set(DATA_IS_AWAKE, (Object)pAwake);
    }

    public boolean isAwake() {
        return (Boolean)this.entityData.get(DATA_IS_AWAKE);
    }

    public void setVariant(int pVariant) {
        this.entityData.set(DATA_VARIANT, (Object)pVariant);
        this.getPersistentData().putInt("Variant", pVariant);
    }

    public int getVariant() {
        return (Integer)this.entityData.get(DATA_VARIANT);
    }

    public void setOwner(@Nullable UUID uuid) {
        this.entityData.set(DATA_OWNER_UUID, Optional.ofNullable(uuid));
    }

    public UUID getOwnerUUID() {
        return ((Optional)this.entityData.get(DATA_OWNER_UUID)).orElse(null);
    }

    @NotNull
    protected SoundEvent getHurtSound(DamageSource pDamageSource) {
        return this.isAwake() ? (SoundEvent)MLSounds.GARGOYLE_HURT.value() : SoundEvents.EMPTY;
    }

    protected void playAttackSound() {
        this.playSound((SoundEvent)MLSounds.GARGOYLE_ATTACK.value());
    }

    protected void playStepSound(BlockPos pPos, BlockState pState) {
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return this.isAwake() ? (SoundEvent)MLSounds.GARGOYLE_AMBIENT.value() : null;
    }

    @NotNull
    protected SoundEvent getDeathSound() {
        return (SoundEvent)MLSounds.GARGOYLE_DEATH.value();
    }

    public boolean canStandOnFluid(FluidState pFluidState) {
        return this.getVariant() == 1 && pFluidState.is(FluidTags.LAVA);
    }

    public boolean isOnFire() {
        return false;
    }

    public boolean isAlliedTo(Entity entity) {
        if (entity == this) {
            return true;
        }
        UUID owner = this.getOwnerUUID();
        if (owner != null) {
            Wolf wolf;
            GargoyleEntity other;
            if (entity.getUUID().equals(owner)) {
                return true;
            }
            if (entity instanceof GargoyleEntity && owner.equals((other = (GargoyleEntity)entity).getOwnerUUID())) {
                return true;
            }
            if (entity instanceof Wolf && owner.equals((wolf = (Wolf)entity).getOwnerUUID())) {
                return true;
            }
        }
        return super.isAlliedTo(entity);
    }

    @Nullable
    public PlayerTeam getTeam() {
        LivingEntity owner;
        if (this.getOwnerUUID() != null && (owner = this.getOwner()) != null) {
            return owner.getTeam();
        }
        return super.getTeam();
    }

    PlayState wingPredicate(AnimationState<?> state) {
        if (this.isAwake() && !this.isDeadOrDying()) {
            if (this.getAnimationId() == 1) {
                return state.setAndContinue(WINGS_ATTACKING_ANIM);
            }
            if (this.isAwake() && state.isMoving()) {
                return state.setAndContinue(WINGS_WALKING_ANIM);
            }
            return state.setAndContinue(WINGS_IDLE_AWAKE_ANIM);
        }
        return PlayState.STOP;
    }

    PlayState headPredicate(AnimationState<?> state) {
        return this.isAwake() && !this.isDeadOrDying() ? state.setAndContinue(HEAD_JAW_ANIM) : PlayState.STOP;
    }

    @Override
    PlayState movementPredicate(AnimationState<?> state) {
        if (this.isDeadOrDying() && this.isAwake()) {
            return state.setAndContinue(DEATH_ANIM);
        }
        if (this.isAwake() && this.getAnimationId() == SHOCKWAVE) {
            return state.setAndContinue(SHOCKWAVE_ATTACK_ANIM);
        }
        if (this.isAwake() && this.getAnimationId() == 2) {
            return state.setAndContinue(RANGED_ATTACK_ANIM);
        }
        if (this.isAwake() && state.isMoving()) {
            return state.setAndContinue(WALK_ANIM);
        }
        if (this.isAwake()) {
            return state.setAndContinue(IDLE_AWAKE_ANIM);
        }
        return state.setAndContinue(IDLE_ANIM);
    }

    @Override
    PlayState attackPredicate(AnimationState<?> state) {
        if (this.isDeadOrDying()) {
            return PlayState.STOP;
        }
        if (this.isAwake() && this.getAnimationId() == 1 && this.getAttackTicks() == 19 && this.isAlive()) {
            state.getController().forceAnimationReset();
            return state.setAndContinue(ATTACK_ANIM);
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "movementController", 5, this::movementPredicate).setSoundKeyframeHandler(state -> {
            if (state.getKeyframeData().getSound().equals("step") && this.onGround()) {
                this.level().playLocalSound(this.getOnPos(), (SoundEvent)MLSounds.GARGOYLE_STEP.value(), SoundSource.HOSTILE, 1.0f, 1.0f, false);
            }
        }));
        controllers.add(new AnimationController((GeoAnimatable)this, "attackController", 5, this::attackPredicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "wingController", 5, this::wingPredicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "headController", 5, this::headPredicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    @Override
    void setConfigAttributes() {
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(((Double)Config.GARGOYLE_HEALTH.get()).doubleValue());
        this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(((Double)Config.GARGOYLE_DAMAGE.get()).doubleValue());
        this.getAttribute(Attributes.ATTACK_KNOCKBACK).setBaseValue(((Double)Config.GARGOYLE_ATTACK_KNOCKBACK.get()).doubleValue());
        this.getAttribute(Attributes.KNOCKBACK_RESISTANCE).setBaseValue(((Double)Config.GARGOYLE_KNOCKBACK_RESISTANCE.get()).doubleValue());
        this.setHealth((float)Config.GARGOYLE_HEALTH.getAsDouble());
    }

    private void applyDebuffEffect(LivingEntity target) {
        if (target instanceof Player) {
            Player player = (Player)target;
            if (this.getVariant() == 0) {
                SendMessageToPlayerHelper.displayClientMessage((Component)Component.translatable((String)"text.mythsandlegends.player_petrified"), player, true);
            }
        }
        if (this.getVariant() == 1) {
            target.setRemainingFireTicks(40);
        } else {
            target.addEffect(new MobEffectInstance(MLEffects.PETRIFIED, 40, 0));
            this.playSound((SoundEvent)MLSounds.PETRIFIED.value(), 1.0f, 1.0f);
        }
    }

    private boolean canBeHurtWithPickaxe(LivingEntity livingEntity) {
        return livingEntity.getItemInHand(InteractionHand.MAIN_HAND).getItem() instanceof PickaxeItem;
    }

    private boolean isNether() {
        return this.level().getBiome(this.blockPosition()).is(BiomeTags.IS_NETHER);
    }

    public LivingEntity getOwner() {
        UUID uuid = this.getOwnerUUID();
        return uuid == null ? null : this.level().getPlayerByUUID(uuid);
    }

    public boolean wantsToAttack(LivingEntity target, LivingEntity owner) {
        return true;
    }

    public void tryToTeleportToOwner() {
        LivingEntity livingentity = this.getOwner();
        if (livingentity != null) {
            this.teleportToAroundBlockPos(livingentity.blockPosition());
        }
    }

    public boolean shouldTryTeleportToOwner() {
        LivingEntity livingentity = this.getOwner();
        return livingentity != null && this.distanceToSqr((Entity)this.getOwner()) >= 144.0;
    }

    private void teleportToAroundBlockPos(BlockPos pos) {
        for (int i = 0; i < 10; ++i) {
            int j = this.random.nextIntBetweenInclusive(-3, 3);
            int k = this.random.nextIntBetweenInclusive(-3, 3);
            if (Math.abs(j) < 2 && Math.abs(k) < 2) continue;
            int l = this.random.nextIntBetweenInclusive(-1, 1);
            if (!this.maybeTeleportTo(pos.getX() + j, pos.getY() + l, pos.getZ() + k)) continue;
            return;
        }
    }

    private boolean maybeTeleportTo(int x, int y, int z) {
        if (!this.canTeleportTo(new BlockPos(x, y, z))) {
            return false;
        }
        this.moveTo((double)x + 0.5, y, (double)z + 0.5, this.getYRot(), this.getXRot());
        this.navigation.stop();
        return true;
    }

    private boolean canTeleportTo(BlockPos pos) {
        PathType pathtype = WalkNodeEvaluator.getPathTypeStatic((Mob)this, (BlockPos)pos);
        if (pathtype != PathType.WALKABLE) {
            return false;
        }
        BlockState blockstate = this.level().getBlockState(pos.below());
        if (!this.canFlyToOwner() && blockstate.getBlock() instanceof LeavesBlock) {
            return false;
        }
        BlockPos blockpos = pos.subtract((Vec3i)this.blockPosition());
        return this.level().noCollision((Entity)this, this.getBoundingBox().move(blockpos));
    }

    boolean canFlyToOwner() {
        return false;
    }

    public final boolean unableToMoveToOwner() {
        return this.isPassenger() || this.mayBeLeashed() || this.getOwner() != null && this.getOwner().isSpectator();
    }

    public static class ShockwaveAttackGoal
    extends Goal {
        private final GargoyleEntity mob;
        LivingEntity target;
        private int attackTick;
        private final int ATTACK_DURATION = 25;

        public ShockwaveAttackGoal(GargoyleEntity mob) {
            this.mob = mob;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            this.target = this.mob.getTarget();
            return this.target != null && this.mob.getAnimationId() == 0 && (double)this.mob.getRandom().nextFloat() <= 0.14 && this.mob.isAwake() && this.mob.distanceTo((Entity)this.target) <= 4.0f && !this.mob.isDeadOrDying() && this.mob.onGround() && this.mob.getVariant() == 0 && shockwaveCooldown <= 0;
        }

        public boolean canContinueToUse() {
            return this.target != null && this.target.isAlive() && shockwaveCooldown <= 0;
        }

        public void start() {
            this.mob.setAnimationId(SHOCKWAVE);
            this.mob.getNavigation().stop();
            this.attackTick = 0;
        }

        public void tick() {
            ++this.attackTick;
            if (this.target != null && this.attackTick <= 25) {
                if (this.attackTick == 10) {
                    this.performShockwaveAttack();
                }
                if (this.attackTick >= 25) {
                    this.stop();
                }
            }
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public void stop() {
            this.target = null;
            this.mob.setAnimationId(0);
            this.mob.getNavigation().recomputePath();
            this.attackTick = 0;
            shockwaveCooldown = DefaultMobAttributes.GARGOYLE_ABILITY_COOLDOWN;
        }

        void performShockwaveAttack() {
            Level level = this.mob.level();
            List entities = level.getEntitiesOfClass(Entity.class, this.mob.getBoundingBox().inflate(5.0), entity -> entity != this.mob.getOwner() && entity != this.mob);
            for (Entity entity2 : entities) {
                if (!(entity2 instanceof LivingEntity)) continue;
                double deltaX = entity2.getX() - this.mob.getX();
                double deltaZ = entity2.getZ() - this.mob.getZ();
                double distance = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
                entity2.hurt(level.damageSources().mobAttack((LivingEntity)this.mob), 5.0f);
                if (distance == 0.0) continue;
                ((LivingEntity)entity2).knockback(3.0, -deltaX / distance, -deltaZ / distance);
            }
            level.broadcastEntityEvent((Entity)this.mob, (byte)69);
            level.playSound(null, this.mob.blockPosition(), (SoundEvent)MLSounds.SHOCKWAVE.value(), SoundSource.HOSTILE);
        }
    }
}

