/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity.ai.goal.amarok;

import com.ovinter.mythsandlegends.config.DefaultMobAttributes;
import com.ovinter.mythsandlegends.entity.AmarokEntity;
import com.ovinter.mythsandlegends.entity.projectile.FrostSpikeEntity;
import com.ovinter.mythsandlegends.registry.MLEntities;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;

public class BackStepAttackGoal
extends Goal {
    private final AmarokEntity mob;
    private LivingEntity target;
    private final List<Entity> floatingProjectiles = new ArrayList<Entity>();
    private int attackTick;
    private int projectileIndex;
    private final int ATTACK_DURATION = 80;
    private final int TOTAL_PROJECTILES = 3;
    private final int SHOOT_INTERVAL = 25;

    public BackStepAttackGoal(AmarokEntity pMob) {
        this.mob = pMob;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        this.target = this.mob.getTarget();
        return this.target != null && this.mob.getAnimationId() == 0 && this.mob.isAlive() && this.mob.onGround() && this.mob.rangedCooldown == 0;
    }

    public boolean canContinueToUse() {
        return this.mob.isAlive() && this.projectileIndex < 3;
    }

    public void start() {
        this.mob.setAnimationId(this.mob.BACKSTEP_JUMP);
        this.attackTick = 0;
        this.projectileIndex = 0;
    }

    public void stop() {
        this.target = null;
        this.floatingProjectiles.clear();
        this.mob.setAnimationId(0);
        this.attackTick = 0;
        this.projectileIndex = 0;
        this.mob.rangedCooldown = DefaultMobAttributes.AMAROK_RANGED_COOLDOWN;
    }

    public void tick() {
        ++this.attackTick;
        if (this.target == null) {
            return;
        }
        if (this.attackTick > 80) {
            this.stop();
        }
        this.applyBodyRot();
        if (this.attackTick == 10) {
            this.pushBackwards();
        }
        if (this.attackTick >= 11 && this.attackTick <= 80) {
            this.tryToFreezeWaterUnderneath();
        }
        if (this.attackTick == 20) {
            this.spawnFloatingProjectiles();
            this.mob.setAnimationId(2);
        }
        if (this.attackTick % 25 == 0 && this.projectileIndex < this.floatingProjectiles.size()) {
            this.shootProjectile(this.floatingProjectiles.get(this.projectileIndex));
            ++this.projectileIndex;
        }
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    private void applyBodyRot() {
        Vec3 mobPos = this.mob.position();
        Vec3 targetPos = this.target.position();
        double distanceX = targetPos.x - mobPos.x;
        double distanceZ = targetPos.z - mobPos.z;
        float yaw = (float)(Math.atan2(distanceZ, distanceX) * 57.29577951308232) - 90.0f;
        this.mob.setYRot(yaw);
        this.mob.setYBodyRot(yaw);
        this.mob.setYHeadRot(yaw);
    }

    private void pushBackwards() {
        Vec3 look = this.mob.getLookAngle();
        this.mob.setDeltaMovement(this.mob.getDeltaMovement().add(-look.x * 0.8, 0.5, -look.z * 0.8));
        this.mob.getNavigation().stop();
    }

    private void spawnFloatingProjectiles() {
        for (int i = 0; i < 3; ++i) {
            FrostSpikeEntity spike = new FrostSpikeEntity(MLEntities.FROST_SPIKE.get(), this.mob.level());
            double y = this.mob.getY() + (i == 1 ? (double)this.mob.getEyeHeight() + 2.5 : (double)this.mob.getEyeHeight() + 1.5);
            spike.setPos(this.mob.getX() + (double)i, y, this.mob.getZ());
            spike.setNoGravity(true);
            spike.setDeltaMovement(0.0, 0.0, 0.0);
            spike.setTarget(this.target);
            this.mob.level().addFreshEntity((Entity)spike);
            this.floatingProjectiles.add((Entity)spike);
        }
    }

    private void shootProjectile(Entity p) {
        if (!(p instanceof FrostSpikeEntity)) {
            return;
        }
        FrostSpikeEntity spike = (FrostSpikeEntity)p;
        if (this.target == null) {
            return;
        }
        spike.setNoGravity(false);
        Vec3 dir = this.target.position().subtract(spike.position()).normalize().scale(1.25);
        spike.setDeltaMovement(dir.x, dir.y + 0.12, dir.z);
    }

    private void tryToFreezeWaterUnderneath() {
        BlockPos posBelow = this.mob.blockPosition().below();
        if (this.mob.isInWater() || this.mob.level().getBlockState(posBelow).getBlock() == Blocks.WATER) {
            int radius = 1;
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos freezePos = posBelow.offset(x, 0, z);
                    if (this.mob.level().getBlockState(freezePos).getBlock() != Blocks.WATER) continue;
                    this.mob.level().setBlock(freezePos, Blocks.FROSTED_ICE.defaultBlockState(), 3);
                }
            }
        }
    }
}

