/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity.ai.goal.black_charro;

import com.ovinter.mythsandlegends.entity.BlackCharroEntityNew;
import com.ovinter.mythsandlegends.entity.projectile.UmbralOrbEntity;
import com.ovinter.mythsandlegends.registry.MLEntities;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;

public class BurningCloakGoal
extends Goal {
    private final BlackCharroEntityNew mob;
    private int cooldown = 0;

    public BurningCloakGoal(BlackCharroEntityNew mob) {
        this.mob = mob;
    }

    public boolean canUse() {
        return this.mob.getBossPhase() == 1 && this.cooldown <= 0 && this.mob.getTarget() != null;
    }

    public void start() {
        this.mob.triggerAnim("attack", "capa_fuego");
        for (int i = -3; i <= 3; ++i) {
            UmbralOrbEntity fire = new UmbralOrbEntity(MLEntities.UMBRAL_ORB.get(), this.mob.level(), (LivingEntity)this.mob);
            fire.shoot(Math.cos((double)i * 0.3), 0.0, Math.sin((double)i * 0.3), 0.8f, 0.0f);
            this.mob.level().addFreshEntity((Entity)fire);
        }
        this.cooldown = 100;
    }

    public void tick() {
        --this.cooldown;
    }

    public boolean canContinueToUse() {
        return false;
    }
}

