/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity.ai.goal.black_charro;

import com.ovinter.mythsandlegends.entity.BlackCharroEntityNew;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;

public class DarkWhirlwindGoal
extends Goal {
    private final BlackCharroEntityNew mob;
    private int cooldown = 0;

    public DarkWhirlwindGoal(BlackCharroEntityNew pMob) {
        this.mob = pMob;
    }

    public boolean canUse() {
        return this.mob.getBossPhase() == 3 && this.cooldown <= 0 && this.mob.getTarget() != null;
    }

    public void start() {
        List targets = this.mob.level().getEntitiesOfClass(LivingEntity.class, this.mob.getBoundingBox().inflate(8.0));
        for (LivingEntity target : targets) {
            if (target == this.mob) continue;
            double distanceX = this.mob.getX() - target.getX();
            double distanceZ = this.mob.getZ() - target.getZ();
            target.push(distanceX * 0.1, 0.1, distanceZ * 0.1);
        }
        this.mob.level().explode((Entity)this.mob, this.mob.getX(), this.mob.getY(), this.mob.getZ(), 2.5f, Level.ExplosionInteraction.NONE);
        this.cooldown = 300;
    }

    public void tick() {
        --this.cooldown;
    }

    public boolean canContinueToUse() {
        return false;
    }
}

