/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity.ai.goal.gargoyle;

import com.ovinter.mythsandlegends.entity.GargoyleEntity;
import com.ovinter.mythsandlegends.registry.MLSounds;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.ai.goal.Goal;

public class AwakeStateGoal
extends Goal {
    private final GargoyleEntity mob;

    public AwakeStateGoal(GargoyleEntity mob) {
        this.mob = mob;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
    }

    public void start() {
        this.mob.setTarget(null);
        this.mob.getNavigation().stop();
        this.mob.setAwake(false);
        this.mob.playSound((SoundEvent)MLSounds.RUPTURE_BURST.value());
    }

    public boolean canUse() {
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos(this.mob.getX(), this.mob.getY(), this.mob.getZ());
        return this.mob.level().isDay() && this.mob.level().canSeeSky((BlockPos)blockPos);
    }

    public void tick() {
        if (!this.mob.level().isDay()) {
            this.stop();
        }
    }

    public void stop() {
        this.mob.setAwake(true);
        this.mob.playSound((SoundEvent)MLSounds.RUPTURE_BURST.value());
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }
}

