/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity.ai.navigation;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class GroundNavigator
extends GroundPathNavigation {
    private static final float EPSILON = 1.0E-8f;
    private Vec3 lastPos = Vec3.ZERO;
    private int noMoveTicks = 0;
    private final Cache<BlockPos, Boolean> cache = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterAccess(5L, TimeUnit.SECONDS).build();

    public GroundNavigator(Mob entity, Level world) {
        super(entity, world);
    }

    @NotNull
    protected PathFinder createPathFinder(int maxVisitedNodes) {
        this.nodeEvaluator = new WalkNodeEvaluator();
        this.nodeEvaluator.setCanPassDoors(true);
        return new PathFinder(this.nodeEvaluator, maxVisitedNodes);
    }

    protected void followThePath() {
        Vec3 curr;
        int lastIdx;
        if (this.path == null || this.path.isDone()) {
            return;
        }
        Vec3 entityPos = this.getTempMobPos();
        int nextIdx = this.path.getNextNodeIndex();
        double yFloor = Math.floor(entityPos.y);
        for (lastIdx = nextIdx; lastIdx < this.path.getNodeCount() && (double)this.path.getNode((int)lastIdx).y == yFloor; ++lastIdx) {
        }
        Vec3 base = entityPos.subtract((double)this.mob.getBbWidth(), 0.0, (double)this.mob.getBbWidth());
        this.attemptShortcut(this.path, entityPos, lastIdx, base);
        if (this.hasReached(this.path, 1.0f) || this.isAtElevationChange(this.path) && this.hasReached(this.path, 1.0f)) {
            this.path.advance();
        }
        if (!this.path.isDone()) {
            Vec3 target = this.path.getNextEntityPos((Entity)this.mob);
            this.mob.getMoveControl().setWantedPosition(target.x, target.y, target.z, this.speedModifier);
            if (this.mob.horizontalCollision && this.mob.onGround()) {
                BlockPos abovePos;
                PathType aboveType;
                float malus;
                Direction dir = this.mob.getDirection();
                BlockPos frontPos = this.mob.blockPosition().relative(dir);
                BlockState state = this.level.getBlockState(frontPos);
                VoxelShape shape = state.getCollisionShape((BlockGetter)this.level, frontPos);
                double shapeHeight = shape.max(Direction.Axis.Y);
                if (shapeHeight > 0.0 && shapeHeight <= 1.0 && (malus = this.mob.getPathfindingMalus(aboveType = this.nodeEvaluator.getPathType(this.mob, abovePos = frontPos.above()))) >= 0.0f && malus < 8.0f) {
                    this.mob.getJumpControl().jump();
                }
            }
        }
        this.noMoveTicks = (curr = Vec3.atLowerCornerOf((Vec3i)this.mob.blockPosition()).add(0.0, (double)(this.mob.getBbHeight() / 2.0f), 0.0)).distanceTo(this.lastPos) < 0.01 ? ++this.noMoveTicks : 0;
        this.lastPos = curr;
        if (this.noMoveTicks > 10) {
            this.cache.invalidateAll();
            this.path = null;
            this.mob.getMoveControl().setWantedPosition(this.mob.getX(), this.mob.getY(), this.mob.getZ(), 0.0);
            if (this.getTargetPos() != null) {
                this.createPath(this.getTargetPos(), (int)this.mob.getAttributeValue(Attributes.FOLLOW_RANGE));
            }
            this.noMoveTicks = 0;
        }
        this.doStuckDetection(entityPos);
    }

    private boolean hasReached(Path path, float threshold) {
        Vec3 pathPos = path.getNextEntityPos((Entity)this.mob);
        if (Math.abs(this.mob.getX() - pathPos.x) >= (double)threshold) {
            return false;
        }
        if (Math.abs(this.mob.getZ() - pathPos.z) >= (double)threshold) {
            return false;
        }
        return Math.abs(this.mob.getY() - pathPos.y) <= 1.001;
    }

    private boolean isAtElevationChange(Path path) {
        int currIndex = path.getNextNodeIndex();
        int endIndex = Math.min(path.getNodeCount(), currIndex + Mth.ceil((float)(this.mob.getBbWidth() * 0.5f)) + 1);
        int currY = path.getNode((int)currIndex).y;
        for (int i = currIndex + 1; i < endIndex; ++i) {
            if (path.getNode((int)i).y == currY) continue;
            return true;
        }
        return false;
    }

    private boolean attemptShortcut(Path path, Vec3 entityPos, int pathLength, Vec3 base) {
        int nextNodeIndex = path.getNextNodeIndex();
        for (int i = pathLength - 1; i > nextNodeIndex; --i) {
            Vec3 vec = path.getEntityPosAtNode((Entity)this.mob, i).subtract(entityPos);
            if (!this.catchF(vec, base)) continue;
            path.setNextNodeIndex(i);
            return false;
        }
        return true;
    }

    private boolean catchF(Vec3 vec, Vec3 base) {
        int stepZ;
        float tNextZ;
        float tDeltaZ;
        int stepY;
        float tNextY;
        float tDeltaY;
        int stepX;
        float tNextX;
        float tDeltaX;
        float maxT = (float)vec.length();
        if (maxT < 1.0E-8f) {
            return true;
        }
        float dx = (float)vec.x / maxT;
        float dy = (float)vec.y / maxT;
        float dz = (float)vec.z / maxT;
        if (Math.abs(dx) < 1.0E-8f) {
            tDeltaX = Float.POSITIVE_INFINITY;
            tNextX = Float.POSITIVE_INFINITY;
            stepX = 0;
        } else {
            stepX = dx > 0.0f ? 1 : -1;
            float voxelBoundaryX = stepX > 0 ? (float)(Mth.floor((double)base.x) + 1) : (float)Mth.floor((double)base.x);
            tDeltaX = 1.0f / Math.abs(dx);
            tNextX = (float)(((double)voxelBoundaryX - base.x) / (double)dx);
        }
        int currentX = Mth.floor((double)base.x);
        if (Math.abs(dy) < 1.0E-8f) {
            tDeltaY = Float.POSITIVE_INFINITY;
            tNextY = Float.POSITIVE_INFINITY;
            stepY = 0;
        } else {
            stepY = dy > 0.0f ? 1 : -1;
            float voxelBoundaryY = stepY > 0 ? (float)(Mth.floor((double)base.y) + 1) : (float)Mth.floor((double)base.y);
            tDeltaY = 1.0f / Math.abs(dy);
            tNextY = (float)(((double)voxelBoundaryY - base.y) / (double)dy);
        }
        int currentY = Mth.floor((double)base.y);
        if (Math.abs(dz) < 1.0E-8f) {
            tDeltaZ = Float.POSITIVE_INFINITY;
            tNextZ = Float.POSITIVE_INFINITY;
            stepZ = 0;
        } else {
            stepZ = dz > 0.0f ? 1 : -1;
            float voxelBoundaryZ = stepZ > 0 ? (float)(Mth.floor((double)base.z) + 1) : (float)Mth.floor((double)base.z);
            tDeltaZ = 1.0f / Math.abs(dz);
            tNextZ = (float)(((double)voxelBoundaryZ - base.z) / (double)dz);
        }
        int currentZ = Mth.floor((double)base.z);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        float t = 0.0f;
        while (t <= maxT) {
            if (tNextX < tNextY) {
                if (tNextX < tNextZ) {
                    currentX += stepX;
                    t = tNextX;
                    tNextX += tDeltaX;
                } else {
                    currentZ += stepZ;
                    t = tNextZ;
                    tNextZ += tDeltaZ;
                }
            } else if (tNextY < tNextZ) {
                currentY += stepY;
                t = tNextY;
                tNextY += tDeltaY;
            } else {
                currentZ += stepZ;
                t = tNextZ;
                tNextZ += tDeltaZ;
            }
            pos.set(currentX, currentY, currentZ);
            BlockPos immutablePos = pos.immutable();
            Boolean isPathfindable = (Boolean)this.cache.getIfPresent((Object)immutablePos);
            if (isPathfindable == null) {
                BlockState blockState = this.level.getBlockState((BlockPos)pos);
                isPathfindable = blockState.isPathfindable(PathComputationType.LAND);
                this.cache.put((Object)immutablePos, (Object)isPathfindable);
            }
            if (!isPathfindable.booleanValue()) {
                return false;
            }
            BlockPos blockPos = new BlockPos(currentX, currentY, currentZ);
            PathType pathType = this.nodeEvaluator.getPathType(this.mob, blockPos);
            float malus = this.mob.getPathfindingMalus(pathType);
            if (!(malus < 0.0f) && !(malus >= 8.0f) && pathType != PathType.DAMAGE_FIRE && pathType != PathType.DANGER_FIRE && pathType != PathType.DAMAGE_OTHER) continue;
            return false;
        }
        return true;
    }
}

