/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity.projectile;

import com.ovinter.mythsandlegends.api.util.ParticleGeneratorHelper;
import com.ovinter.mythsandlegends.registry.MLParticles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class FrostSpikeEntity
extends ThrowableProjectile
implements GeoEntity {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation MOVING_ANIM = RawAnimation.begin().thenLoop("MOVING");
    private LivingEntity target;

    public FrostSpikeEntity(EntityType<? extends FrostSpikeEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    protected void onHit(HitResult ray) {
        HitResult.Type raytraceresult$type = ray.getType();
        if (raytraceresult$type == HitResult.Type.ENTITY) {
            this.onHitEntity((EntityHitResult)ray);
        } else if (raytraceresult$type == HitResult.Type.BLOCK) {
            this.onHitBlock((BlockHitResult)ray);
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        if (!this.level().isClientSide && !(result.getEntity() instanceof FrostSpikeEntity)) {
            this.playSound(SoundEvents.GLASS_BREAK, 1.0f, 1.0f);
            result.getEntity().hurt(this.damageSources().magic(), 6.0f);
            this.discard();
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        if (!this.level().isClientSide()) {
            BlockPos hitPos = result.getBlockPos();
            this.level().setBlock(hitPos, Blocks.PACKED_ICE.defaultBlockState(), 3);
            this.playSound(SoundEvents.GLASS_BREAK, 1.0f, 1.0f);
            this.discard();
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
    }

    public void tick() {
        if (this.level().isClientSide) {
            ParticleGeneratorHelper.generateProjectileTrail(this.level(), (Entity)this, (ParticleOptions)MLParticles.SNOW_FLAKE_PARTICLE.get());
        }
        super.tick();
    }

    public void setTarget(LivingEntity pTarget) {
        this.target = pTarget;
    }

    public LivingEntity getTarget() {
        return this.target;
    }

    PlayState predicate(AnimationState<?> state) {
        return state.setAndContinue(MOVING_ANIM);
    }

    public boolean isOnFire() {
        return false;
    }

    protected double getDefaultGravity() {
        return 0.01;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, this::predicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }
}

