/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity.projectile;

import com.ovinter.mythsandlegends.api.util.ParticleGeneratorHelper;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class MoltenRockEntity
extends ThrowableProjectile
implements GeoEntity {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation IDLE_ANIM = RawAnimation.begin().thenLoop("IDLE");

    public MoltenRockEntity(EntityType<? extends ThrowableProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public MoltenRockEntity(EntityType<? extends ThrowableProjectile> pEntityType, Level pLevel, LivingEntity pEntity) {
        super(pEntityType, pLevel);
        this.setOwner((Entity)pEntity);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    protected void onHit(HitResult ray) {
        HitResult.Type raytraceResultType = ray.getType();
        if (raytraceResultType == HitResult.Type.ENTITY) {
            this.onHitEntity((EntityHitResult)ray);
        } else if (raytraceResultType == HitResult.Type.BLOCK) {
            this.onHitBlock((BlockHitResult)ray);
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        Entity target = result.getEntity();
        target.hurt(this.damageSources().magic(), 4.5f);
        target.setRemainingFireTicks(40);
        this.playSound(SoundEvents.LAVA_POP, 1.0f, 1.0f);
    }

    public void tick() {
        super.tick();
        ProjectileUtil.rotateTowardsMovement((Entity)this, (float)0.5f);
        ParticleGeneratorHelper.generateProjectileTrail(this.level(), (Entity)this, (ParticleOptions)ParticleTypes.FLAME);
    }

    public boolean isOnFire() {
        return false;
    }

    PlayState predicate(AnimationState<?> state) {
        return state.setAndContinue(IDLE_ANIM);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, this::predicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }
}

