/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity.projectile;

import com.ovinter.mythsandlegends.api.util.ParticleGeneratorHelper;
import com.ovinter.mythsandlegends.entity.BlackCharroEntityOld;
import com.ovinter.mythsandlegends.entity.CondemnedEntity;
import com.ovinter.mythsandlegends.registry.MLSounds;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SimpleExplosionDamageCalculator;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class UmbralOrbEntity
extends ThrowableProjectile
implements GeoEntity {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("IDLE");
    private static final ExplosionDamageCalculator EXPLOSION_DAMAGE_CALCULATOR = new SimpleExplosionDamageCalculator(false, true, Optional.of(Float.valueOf(1.22f)), BuiltInRegistries.BLOCK.getTag(BlockTags.BLOCKS_WIND_CHARGE_EXPLOSIONS).map(Function.identity()));
    private int growTimer = 0;

    public UmbralOrbEntity(EntityType<? extends ThrowableProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public UmbralOrbEntity(EntityType<? extends ThrowableProjectile> pEntityType, Level pLevel, LivingEntity pEntity) {
        super(pEntityType, pEntity, pLevel);
        this.setOwner((Entity)pEntity);
    }

    protected void onHit(HitResult ray) {
        HitResult.Type raytraceresult$type = ray.getType();
        if (raytraceresult$type == HitResult.Type.ENTITY) {
            this.onHitEntity((EntityHitResult)ray);
        } else if (raytraceresult$type == HitResult.Type.BLOCK) {
            this.onHitBlock((BlockHitResult)ray);
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        if (!(this.level().isClientSide || result.getEntity() instanceof UmbralOrbEntity || result.getEntity() instanceof BlackCharroEntityOld || result.getEntity() instanceof CondemnedEntity)) {
            this.playSound((SoundEvent)MLSounds.UMBRAL_DOOM_ORB_EXPLOSION.value(), 1.0f, 1.0f);
            result.getEntity().hurt(this.damageSources().magic(), 6.0f);
            this.discard();
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        if (!this.level().isClientSide()) {
            this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), 1.5f, false, Level.ExplosionInteraction.NONE);
            this.playSound((SoundEvent)MLSounds.UMBRAL_DOOM_ORB_EXPLOSION.value(), 10.0f, 1.0f);
            this.discard();
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
    }

    public void tick() {
        super.tick();
        ++this.growTimer;
        this.setYRot(-((float)Mth.atan2((double)this.getDeltaMovement().x, (double)this.getDeltaMovement().z)) * 57.295776f);
        if (this.level().isClientSide) {
            ParticleGeneratorHelper.generateUmbralDoomOrbTrail(this.level(), this.growTimer, (Entity)this);
        }
    }

    public float getLightLevelDependentMagicValue() {
        return 1.0f;
    }

    PlayState predicate(AnimationState<?> state) {
        return state.setAndContinue(IDLE);
    }

    public boolean isOnFire() {
        return false;
    }

    protected double getDefaultGravity() {
        return 0.01;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, this::predicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }
}

