/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.item.custom;

import com.ovinter.mythsandlegends.entity.GargoyleEntity;
import com.ovinter.mythsandlegends.registry.MLEntities;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class GargoyleEffiggyItem
extends Item {
    public GargoyleEffiggyItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        BlockHitResult hitResult;
        ItemStack itemStack = player.getItemInHand(usedHand);
        if (!level.isClientSide && (hitResult = GargoyleEffiggyItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE)).getType() == HitResult.Type.BLOCK) {
            BlockPos pos = hitResult.getBlockPos();
            Direction face = hitResult.getDirection();
            double spawnX = (double)pos.getX() + 0.5;
            double spawnY = (double)pos.getY() + 1.0;
            double spawnZ = (double)pos.getZ() + 0.5;
            if (face != Direction.UP) {
                spawnX += (double)face.getStepX() * 0.5;
                spawnY += (double)face.getStepY() * 0.5;
                spawnZ += (double)face.getStepZ() * 0.5;
            }
            GargoyleEntity gargoyle = new GargoyleEntity(MLEntities.GARGOYLE.get(), level);
            gargoyle.moveTo(spawnX, spawnY, spawnZ, player.getYRot(), 0.0f);
            gargoyle.setOwner(player.getUUID());
            level.addFreshEntity((Entity)gargoyle);
            if (!player.getAbilities().instabuild) {
                itemStack.shrink(1);
            }
        }
        return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)level.isClientSide());
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public boolean isFoil(ItemStack stack) {
        return true;
    }
}

