/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.api.util;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;

public class MLSpawnHelper {
    public static <T extends Monster> boolean canMobSpawn(Class<T> entityClass, EntityType<?> type, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random, int radius, boolean spawnOnlyInSurface) {
        List nearby = level.getEntitiesOfClass(entityClass, new AABB(pos).inflate((double)radius));
        if (!nearby.isEmpty()) {
            return false;
        }
        if (spawnOnlyInSurface) {
            return spawnType == MobSpawnType.SPAWNER || level.canSeeSky(pos);
        }
        return spawnType == MobSpawnType.SPAWNER || level.getBlockState(pos.below()).isValidSpawn((BlockGetter)level, pos.below(), type);
    }

    public static <T extends Monster> boolean canMobSpawn(Class<T> entityClass, EntityType<?> type, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random, int radius) {
        List nearby = level.getEntitiesOfClass(entityClass, new AABB(pos).inflate((double)radius));
        if (!nearby.isEmpty()) {
            return false;
        }
        if (level.getMoonPhase() == 0) {
            return spawnType == MobSpawnType.SPAWNER && level.canSeeSky(pos);
        }
        return spawnType == MobSpawnType.SPAWNER || level.getBlockState(pos.below()).isValidSpawn((BlockGetter)level, pos.below(), type);
    }
}

