/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.api.util;

import com.ovinter.mythsandlegends.registry.MLParticles;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Vector3d;
import org.joml.Vector3f;

public class ParticleGeneratorHelper {
    private static double rotationAngle = 0.0;

    public static void generateEntitySpawnFromGroundParticles(Level pLevel, LivingEntity pEntity) {
        int particleCount = 30;
        BlockState blockState = pEntity.getBlockStateOn();
        if (blockState.getRenderShape() != RenderShape.INVISIBLE) {
            for (int i = 0; i < particleCount; ++i) {
                double x = pEntity.getX() + (double)Mth.randomBetween((RandomSource)pEntity.getRandom(), (float)-0.7f, (float)0.7f);
                double y = pEntity.getY();
                double z = pEntity.getZ() + (double)Mth.randomBetween((RandomSource)pEntity.getRandom(), (float)-0.7f, (float)0.7f);
                pLevel.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, blockState), x, y, z, 0.0, 0.0, 0.0);
            }
        }
    }

    public static void generateDustParticles(LivingEntity pEntity, float pRed, float pGreen, float pBlue, float pAmount, boolean isCustomYNeeded, boolean isEyeHeight) {
        Vector3f color = new Vector3f(pRed, pGreen, pBlue);
        DustParticleOptions particles = new DustParticleOptions(color, pAmount);
        double y = isCustomYNeeded ? (isEyeHeight ? pEntity.getEyeY() : (double)pEntity.getBbHeight()) : pEntity.getY();
        for (int i = 0; i < 3; ++i) {
            double x = pEntity.getX() + (pEntity.getRandom().nextDouble() - 0.5) * 1.2;
            double z = pEntity.getZ() + (pEntity.getRandom().nextDouble() - 0.5) * 1.2;
            pEntity.level().addParticle((ParticleOptions)particles, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public static void generateCircleParticles(LivingEntity pEntity, int pParticleCount, SimpleParticleType pType, boolean isCustomYNeeded, boolean isEyeHeight, double pXSpeed, double pYSpeed, double pZSpeed, double radius, double rotationSpeed) {
        double centerX = pEntity.getX();
        double centerY = isCustomYNeeded ? (isEyeHeight ? pEntity.getEyeY() : pEntity.getY()) : pEntity.getY() - 0.1;
        double centerZ = pEntity.getZ();
        rotationAngle += rotationSpeed;
        for (int i = 0; i < pParticleCount; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)pParticleCount + rotationAngle;
            double xOffset = Math.cos(angle) * radius;
            double zOffset = Math.sin(angle) * radius;
            double particleX = centerX + xOffset;
            double particleZ = centerZ + zOffset;
            pEntity.level().addParticle((ParticleOptions)pType, particleX, centerY, particleZ, pXSpeed, pYSpeed, pZSpeed);
        }
    }

    public static void generateCircleParticles(Level pLevel, LivingEntity pEntity, SimpleParticleType pType, double pRadius, double pRotationSpeed) {
        int particleCount = 5;
        double centerX = pEntity.getX();
        double centerY = pEntity.getY() + 0.2;
        double centerZ = pEntity.getZ();
        rotationAngle += pRotationSpeed;
        for (int i = 0; i < particleCount; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)particleCount + rotationAngle;
            double xOffset = Math.cos(angle) * pRadius;
            double zOffset = Math.sin(angle) * pRadius;
            double x = centerX + xOffset;
            double z = centerZ + zOffset;
            pLevel.addParticle((ParticleOptions)pType, x, centerY, z, 0.0, 0.0, 0.0);
        }
    }

    public static void generatePetrifiedParticles(LivingEntity pEntity) {
        for (int i = 0; i < 20; ++i) {
            double offsetX = pEntity.getRandom().nextDouble() - 0.5;
            double offsetY = pEntity.getRandom().nextDouble() - 0.25;
            double offsetZ = pEntity.getRandom().nextDouble() - 0.5;
            double x = pEntity.getX();
            double y = pEntity.getEyeY();
            double z = pEntity.getZ();
            pEntity.level().addParticle((ParticleOptions)ParticleTypes.ASH, x + offsetX, y + offsetY, z + offsetZ, 0.0, 0.0, 0.0);
        }
    }

    public static void generateShockwaveParticles(Level level, LivingEntity pEntity, double pRadius) {
        BlockState block = level.getBlockState(pEntity.blockPosition().below());
        for (int i = 0; i < 100; ++i) {
            float angle = (float)(Math.PI * 2 * (double)i / 100.0);
            double x = pEntity.getX() + pRadius * (double)Mth.sin((float)angle);
            double y = pEntity.getY() + 0.2;
            double z = pEntity.getZ() + pRadius * (double)Mth.cos((float)angle);
            double ySpeed = level.getRandom().nextGaussian() * 0.2;
            level.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, block), x, y, z, 0.0, ySpeed, 0.0);
        }
    }

    public static void generateUmbralDoomOrbTrail(Level pLevel, int growTimer, Entity pEntity) {
        int particleCount = 15;
        double centerX = pEntity.getX() + pEntity.level().getRandom().nextDouble() - 0.5;
        double centerY = pEntity.getY() + pEntity.level().getRandom().nextDouble() - 0.5;
        double centerZ = pEntity.getZ() + pEntity.level().getRandom().nextDouble() - 0.5;
        for (int i = 0; i < particleCount; ++i) {
            pLevel.addParticle((ParticleOptions)MLParticles.SKULL_PARTICLES.get(), centerX, centerY, centerZ, 0.0, 0.0, 0.0);
        }
    }

    public static void generateSkullParticles(Entity pEntity) {
        double y = pEntity.getY() + 0.2;
        for (int i = 0; i < 3; ++i) {
            double x = pEntity.getX() + (pEntity.level().getRandom().nextDouble() - 0.5) * 2.0;
            double z = pEntity.getZ() + (pEntity.level().getRandom().nextDouble() - 0.5) * 2.0;
            pEntity.level().addParticle((ParticleOptions)MLParticles.SKULL_PARTICLES.get(), x, y, z, 0.0, 1.0, 0.0);
        }
    }

    public static void generateLampadBoostParticles(Level pLevel, LivingEntity pEntity) {
        double centerX = pEntity.getX();
        double centerY = pEntity.getY() + 0.5;
        double centerZ = pEntity.getZ();
        double maxRadius = 0.5;
        int particleCount = 100;
        double heightIncrement = 0.05;
        int rotations = 3;
        for (int i = 0; i < particleCount; ++i) {
            double progress = (double)i / (double)particleCount;
            double angle = Math.PI * 2 * (double)rotations * progress;
            double radius = maxRadius;
            double particleX = centerX + radius * Math.cos(angle);
            double particleZ = centerZ + radius * Math.sin(angle);
            double particleY = centerY + (double)i * heightIncrement;
            pLevel.addParticle((ParticleOptions)MLParticles.LAMPAD_BOOST_PARTICLE.get(), particleX, particleY, particleZ, 0.0, 0.0, 0.0);
        }
    }

    public static void generateChargeParticles(Level pLevel, Entity pEntity) {
        for (int i = 0; i < 360; i += 40) {
            double x = pEntity.getX() + Math.cos(Math.toRadians(i)) * 1.5;
            double z = pEntity.getZ() + Math.sin(Math.toRadians(i)) * 1.5;
            pLevel.addParticle((ParticleOptions)ParticleTypes.LAVA, x, pEntity.getY() + 0.5, z, 0.0, 0.5, 0.0);
        }
    }

    public static void generateFallingParticles(Level pLevel, LivingEntity pEntity) {
        for (int i = 0; i < 100; ++i) {
            pLevel.addParticle((ParticleOptions)ParticleTypes.FLAME, pEntity.getX() + pEntity.getRandom().nextGaussian() * 0.5, pEntity.getY(), pEntity.getZ() + pEntity.getRandom().nextGaussian() * 0.5, 0.0, -0.1, 0.0);
        }
    }

    public static void generateStompParticles(Level pLevel, LivingEntity pEntity) {
        pLevel.addParticle((ParticleOptions)ParticleTypes.LAVA, pEntity.getX() * 0.2, pEntity.getY(), pEntity.getZ() * 0.2, 0.2, -0.1, 0.2);
    }

    public static void generateLandingParticles(Level pLevel, LivingEntity pEntity) {
        int particleCount = 45;
        double radius = 3.5;
        double yOffset = 0.2;
        for (int i = 0; i < particleCount; ++i) {
            double angle = pEntity.getRandom().nextDouble() * Math.PI * 2.0;
            double distance = pEntity.getRandom().nextDouble() * radius;
            double x = pEntity.getX() + Math.cos(angle) * distance;
            double y = pEntity.getY() + yOffset;
            double z = pEntity.getZ() + Math.sin(angle) * distance;
            pLevel.addParticle((ParticleOptions)ParticleTypes.LAVA, x, y, z, 0.0, 0.0, 0.1);
        }
    }

    public static void generateStunParticles(Level pLevel, LivingEntity pEntity) {
        int particleCount = 10;
        int rotationSpeed = 2;
        double radius = 0.5;
        double centerX = pEntity.getX();
        double centerY = pEntity.getEyeY() + 0.5;
        double centerZ = pEntity.getZ();
        rotationAngle += (double)rotationSpeed;
        for (int i = 0; i < particleCount; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)particleCount + rotationAngle;
            double xOffset = Math.cos(angle) * radius;
            double zOffset = Math.sin(angle) * radius;
            double particleX = centerX + xOffset;
            double particleZ = centerZ + zOffset;
            pLevel.addParticle((ParticleOptions)ParticleTypes.CRIT, particleX, centerY, particleZ, 0.0, 0.1, 0.0);
        }
    }

    public static void generateHealingParticles(Level pLevel, LivingEntity pEntity) {
        pLevel.addParticle((ParticleOptions)ParticleTypes.HEART, pEntity.getX(), pEntity.getY() + 2.0, pEntity.getZ(), 0.5, 0.5, 0.5);
    }

    public static void generateHeadParticles(Level pLevel, Vector3d pPos) {
        pLevel.addParticle((ParticleOptions)ParticleTypes.FLAME, pPos.x, pPos.y, pPos.z, 0.0, 0.1, 0.0);
    }

    public static void generateProjectileTrail(Level pLevel, Entity pEntity, ParticleOptions pParticle) {
        int particleCount = 1;
        double centerX = pEntity.getX() + pEntity.level().getRandom().nextDouble() - 0.5;
        double centerY = pEntity.getY() + pEntity.level().getRandom().nextDouble() - 0.5;
        double centerZ = pEntity.getZ() + pEntity.level().getRandom().nextDouble() - 0.5;
        for (int i = 0; i < particleCount; ++i) {
            pLevel.addParticle(pParticle, centerX, centerY, centerZ, 0.0, 0.0, 0.0);
        }
    }
}

