/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.block;

import com.mojang.serialization.MapCodec;
import com.ovinter.mythsandlegends.entity.CondemnedEntity;
import com.ovinter.mythsandlegends.registry.MLEntities;
import com.ovinter.mythsandlegends.registry.MLSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TombstoneBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock {
    private static final VoxelShape BASE = Block.box((double)1.0, (double)0.0, (double)5.0, (double)15.0, (double)2.0, (double)11.0);
    private static final VoxelShape BASE2 = Block.box((double)5.0, (double)0.0, (double)1.0, (double)11.0, (double)2.0, (double)15.0);
    private static final VoxelShape MIDDLE_NORTH = Block.box((double)1.0, (double)2.0, (double)7.0, (double)15.0, (double)15.0, (double)11.0);
    private static final VoxelShape MIDDLE_SOUTH = Block.box((double)1.0, (double)2.0, (double)5.0, (double)15.0, (double)15.0, (double)9.0);
    private static final VoxelShape MIDDLE_EAST = Block.box((double)5.0, (double)2.0, (double)1.0, (double)9.0, (double)15.0, (double)15.0);
    private static final VoxelShape MIDDLE_WEST = Block.box((double)7.0, (double)2.0, (double)1.0, (double)11.0, (double)15.0, (double)15.0);
    private static final VoxelShape SHAPE_NORTH = Shapes.or((VoxelShape)BASE, (VoxelShape)MIDDLE_NORTH);
    private static final VoxelShape SHAPE_SOUTH = Shapes.or((VoxelShape)BASE, (VoxelShape)MIDDLE_SOUTH);
    private static final VoxelShape SHAPE_EAST = Shapes.or((VoxelShape)BASE2, (VoxelShape)MIDDLE_EAST);
    private static final VoxelShape SHAPE_WEST = Shapes.or((VoxelShape)BASE2, (VoxelShape)MIDDLE_WEST);
    private final MapCodec<TombstoneBlock> CODEC = TombstoneBlock.simpleCodec(TombstoneBlock::new);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty IS_HAUNTED = BlockStateProperties.CAN_SUMMON;

    public TombstoneBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)IS_HAUNTED, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return this.CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
        builder.add(new Property[]{WATERLOGGED});
        builder.add(new Property[]{IS_HAUNTED});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidState = context.getLevel().getFluidState(context.getClickedPos());
        boolean isWater = fluidState.getType() == Fluids.WATER;
        boolean haunted = context.getLevel().getRandom().nextFloat() < 0.5f;
        return (BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isWater))).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)IS_HAUNTED, (Comparable)Boolean.valueOf(haunted));
    }

    protected FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @NotNull
    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.WEST -> SHAPE_WEST;
            default -> SHAPE_NORTH;
        };
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (!level.isClientSide) {
            level.setBlock(pos, (BlockState)state.setValue((Property)IS_HAUNTED, (Comparable)Boolean.valueOf(false)), 3);
        }
        super.setPlacedBy(level, pos, state, placer, stack);
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        if (((Boolean)state.getValue((Property)IS_HAUNTED)).booleanValue()) {
            this.tryToSpawnCondemnedSoul(level, pos);
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)IS_HAUNTED)).booleanValue()) {
            level.addParticle((ParticleOptions)ParticleTypes.SOUL, (double)pos.getX() + random.nextDouble(), (double)pos.getY() + 0.25, (double)pos.getZ() + random.nextDouble(), 0.0, 0.0, 0.0);
        }
    }

    private void tryToSpawnCondemnedSoul(Level level, BlockPos pos) {
        CondemnedEntity condemned = new CondemnedEntity(MLEntities.CONDEMNED.get(), level);
        condemned.setPos(pos.getX(), pos.getY(), pos.getZ());
        level.addFreshEntity((Entity)condemned);
        level.playLocalSound((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (SoundEvent)MLSounds.JUMP_SCARE.value(), SoundSource.PLAYERS, 1.0f, 1.0f, false);
    }
}

