/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.client.gui.screen;

import com.ovinter.mythsandlegends.registry.MLBlocks;
import com.ovinter.mythsandlegends.registry.MLItems;
import com.ovinter.mythsandlegends.registry.MLMenus;
import com.ovinter.mythsandlegends.registry.MLSounds;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class StoneSanctumMenu
extends AbstractContainerMenu {
    private static final int HOT_BAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int RESULT_SLOT = 6;
    private static final int SLOT_COUNT = 7;
    private Player player;
    private final ContainerLevelAccess access;
    private final Container container = new SimpleContainer(7){

        public void setChanged() {
            StoneSanctumMenu.this.slotsChanged((Container)this);
            super.setChanged();
        }
    };
    private final ResultContainer resultContainer = new ResultContainer(){

        public void setChanged() {
            StoneSanctumMenu.this.slotsChanged((Container)this);
            super.setChanged();
        }
    };

    public StoneSanctumMenu(int containerId, Inventory inventory, ContainerLevelAccess pAccess) {
        super(MLMenus.STONE_SANCTUM_TABLE.get(), containerId);
        this.access = pAccess;
        this.player = inventory.player;
        this.addSlots(this.container);
        this.addPlayerInventory(inventory);
        this.addPlayerHotbar(inventory);
    }

    @NotNull
    public ItemStack quickMoveStack(Player player, int quickMovedSlotIndex) {
        ItemStack quickMovedStack = ItemStack.EMPTY;
        Slot quickMovedSlot = (Slot)this.slots.get(quickMovedSlotIndex);
        if (quickMovedSlot != null && quickMovedSlot.hasItem()) {
            ItemStack rawStack = quickMovedSlot.getItem();
            quickMovedStack = rawStack.copy();
            if (quickMovedSlotIndex == 6) {
                if (!this.moveItemStackTo(rawStack, 7, 43, true)) {
                    return ItemStack.EMPTY;
                }
                quickMovedSlot.onQuickCraft(rawStack, quickMovedStack);
            } else if (quickMovedSlotIndex >= 7 && quickMovedSlotIndex < 43) {
                if (StoneSanctumFuelSlot.mayPlaceItem(quickMovedStack) && this.moveItemStackTo(rawStack, 0, 1, false)) {
                    return ItemStack.EMPTY;
                }
                if (!this.moveItemStackTo(rawStack, 0, 6, false) && (quickMovedSlotIndex < 34 ? !this.moveItemStackTo(rawStack, 35, 43, false) : !this.moveItemStackTo(rawStack, 7, 34, false))) {
                    return ItemStack.EMPTY;
                }
            } else if (!this.moveItemStackTo(rawStack, 7, 43, false)) {
                return ItemStack.EMPTY;
            }
            if (rawStack.isEmpty()) {
                quickMovedSlot.setByPlayer(ItemStack.EMPTY);
            } else {
                quickMovedSlot.setChanged();
            }
            if (rawStack.getCount() == quickMovedStack.getCount()) {
                return ItemStack.EMPTY;
            }
            quickMovedSlot.onTake(player, rawStack);
        }
        return quickMovedStack;
    }

    public void slotsChanged(Container container) {
        boolean allFilled = true;
        for (int i = 0; i <= 5; ++i) {
            ItemStack stack = this.container.getItem(i);
            if (!stack.isEmpty()) continue;
            allFilled = false;
            break;
        }
        if (!allFilled) {
            this.resultContainer.removeItemNoUpdate(6);
            return;
        }
        this.resultContainer.setItem(6, MLItems.GARGOYLE_EFFIGY.toStack());
    }

    public boolean stillValid(Player player) {
        return StoneSanctumMenu.stillValid((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)MLBlocks.STONE_SANCTUM.get()));
    }

    public void removed(Player player) {
        super.removed(player);
        this.resultContainer.removeItemNoUpdate(6);
        this.access.execute((level, pos) -> this.clearContainer(player, this.container));
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    private void addSlots(Container container) {
        this.addSlot(new StoneSanctumFuelSlot(container, 0, 51, 15));
        this.addSlot(new StoneSanctumIngredientSlot(container, 1, 23, 29));
        this.addSlot(new StoneSanctumIngredientSlot(container, 2, 79, 29));
        this.addSlot(new StoneSanctumIngredientSlot(container, 3, 28, 49));
        this.addSlot(new StoneSanctumIngredientSlot(container, 4, 51, 56));
        this.addSlot(new StoneSanctumIngredientSlot(container, 5, 74, 49));
        this.addSlot(new StoneSanctumResultSlot((Container)this.resultContainer, 6, 143, 39));
    }

    static class StoneSanctumFuelSlot
    extends Slot {
        public StoneSanctumFuelSlot(Container container, int slot, int x, int y) {
            super(container, slot, x, y);
        }

        public boolean mayPlace(ItemStack stack) {
            return StoneSanctumFuelSlot.mayPlaceItem(stack);
        }

        private static boolean mayPlaceItem(ItemStack itemStack) {
            return itemStack.is(MLItems.CURSED_CORE);
        }
    }

    static class StoneSanctumIngredientSlot
    extends Slot {
        public StoneSanctumIngredientSlot(Container container, int slot, int x, int y) {
            super(container, slot, x, y);
        }

        public boolean mayPlace(ItemStack stack) {
            return this.mayPlaceItem(stack);
        }

        private boolean mayPlaceItem(ItemStack stack) {
            return stack.is(MLItems.GARGOYLE_HEAD) || stack.is(MLItems.GARGOYLE_TORSO) || stack.is(MLItems.GARGOYLE_ARM) || stack.is(MLItems.GARGOYLE_LEG) || stack.is(MLItems.GARGOYLE_WING);
        }
    }

    class StoneSanctumResultSlot
    extends Slot {
        public StoneSanctumResultSlot(Container container, int slot, int x, int y) {
            super(container, slot, x, y);
        }

        public boolean mayPlace(ItemStack stack) {
            return false;
        }

        public void onTake(Player player, ItemStack stack) {
            ((Slot)StoneSanctumMenu.this.slots.get(0)).remove(1);
            ((Slot)StoneSanctumMenu.this.slots.get(1)).remove(1);
            ((Slot)StoneSanctumMenu.this.slots.get(2)).remove(1);
            ((Slot)StoneSanctumMenu.this.slots.get(3)).remove(1);
            ((Slot)StoneSanctumMenu.this.slots.get(4)).remove(1);
            ((Slot)StoneSanctumMenu.this.slots.get(5)).remove(1);
            player.level().playLocalSound(player.getX(), player.getY(), player.getZ(), (SoundEvent)MLSounds.STONE_SANCTUM.value(), SoundSource.AMBIENT, 1.0f, 1.0f, false);
            super.onTake(player, stack);
        }
    }
}

