/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.ovinter.mythsandlegends.client.model.entity.AmarokModel;
import com.ovinter.mythsandlegends.entity.AmarokEntity;
import com.ovinter.mythsandlegends.registry.MLParticles;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class AmarokRenderer
extends GeoEntityRenderer<AmarokEntity> {
    public AmarokRenderer(EntityRendererProvider.Context context) {
        super(context, (GeoModel)new AmarokModel());
        this.shadowRadius = 0.5f;
    }

    public void renderFinal(PoseStack poseStack, AmarokEntity animatable, BakedGeoModel model, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay, int colour) {
        if (animatable.getAnimationId() == animatable.SPIN && animatable.showTailParticle) {
            this.model.getBone("tailParticle").ifPresent(tail -> this.addParticlesToBone(animatable, (GeoBone)tail));
        } else {
            animatable.showTailParticle = false;
        }
        super.renderFinal(poseStack, (Entity)animatable, model, bufferSource, buffer, partialTick, packedLight, packedOverlay, colour);
    }

    protected int getBlockLightLevel(AmarokEntity entity, BlockPos pos) {
        return 15;
    }

    protected float getDeathMaxRotation(AmarokEntity animatable) {
        return 0.0f;
    }

    private void addParticlesToBone(AmarokEntity mob, GeoBone tail) {
        RandomSource random = ((AmarokEntity)this.animatable).getRandom();
        Vector3d tailPos = tail.getWorldPosition();
        mob.getCommandSenderWorld().addParticle((ParticleOptions)MLParticles.SNOW_FLAKE_PARTICLE.get(), tailPos.x(), tailPos.y(), tailPos.z(), random.nextDouble() - 0.5, -random.nextDouble(), random.nextDouble() - 0.5);
    }
}

