/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.datagen;

import com.ovinter.mythsandlegends.datagen.MLAdvancementProvider;
import com.ovinter.mythsandlegends.datagen.MLBiomeTagsProvider;
import com.ovinter.mythsandlegends.datagen.MLBlockStateProvider;
import com.ovinter.mythsandlegends.datagen.MLBlockTagProvider;
import com.ovinter.mythsandlegends.datagen.MLCuriosDataProvider;
import com.ovinter.mythsandlegends.datagen.MLEntityTypeTagsProvider;
import com.ovinter.mythsandlegends.datagen.MLItemModelProvider;
import com.ovinter.mythsandlegends.datagen.MLItemTagsProvider;
import com.ovinter.mythsandlegends.datagen.MLLootTableProvider;
import com.ovinter.mythsandlegends.datagen.MLParticleProvider;
import com.ovinter.mythsandlegends.datagen.MLRecipeProvider;
import com.ovinter.mythsandlegends.datagen.MLSoundDefinitionProvider;
import com.ovinter.mythsandlegends.datagen.biome.MLBiomeModifier;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber(modid="mythsandlegends", bus=EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookUpProvider = event.getLookupProvider();
        RegistrySetBuilder builder = new RegistrySetBuilder().add(NeoForgeRegistries.Keys.BIOME_MODIFIERS, MLBiomeModifier::bootstrap);
        MLBlockTagProvider blockTagsProvider = new MLBlockTagProvider(packOutput, lookUpProvider, existingFileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)new MLRecipeProvider(packOutput, lookUpProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new MLAdvancementProvider(packOutput, lookUpProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new MLSoundDefinitionProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)MLLootTableProvider.create(packOutput, lookUpProvider));
        generator.addProvider(event.includeClient(), (DataProvider)new MLEntityTypeTagsProvider(packOutput, lookUpProvider));
        generator.addProvider(event.includeClient(), (DataProvider)new DatapackBuiltinEntriesProvider(packOutput, lookUpProvider, builder, Set.of("mythsandlegends")));
        generator.addProvider(event.includeClient(), (DataProvider)new MLBiomeTagsProvider(packOutput, lookUpProvider));
        generator.addProvider(event.includeClient(), (DataProvider)new MLBlockStateProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new MLItemModelProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)blockTagsProvider);
        generator.addProvider(event.includeServer(), (DataProvider)new MLCuriosDataProvider(packOutput, existingFileHelper, lookUpProvider));
        generator.addProvider(event.includeClient(), (DataProvider)new MLItemTagsProvider(packOutput, lookUpProvider, blockTagsProvider.contentsGetter()));
        generator.addProvider(event.includeClient(), (DataProvider)new MLParticleProvider(packOutput, existingFileHelper));
    }
}

