/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.datagen;

import com.ovinter.mythsandlegends.registry.MLBlocks;
import com.ovinter.mythsandlegends.registry.MLItems;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class MLRecipeProvider
extends RecipeProvider {
    public MLRecipeProvider(PackOutput pOutput, CompletableFuture<HolderLookup.Provider> pRegistries) {
        super(pOutput, pRegistries);
    }

    protected void buildRecipes(RecipeOutput pRecipeOutput) {
        super.buildRecipes(pRecipeOutput);
        this.armorRecipe(pRecipeOutput);
        this.toolRecipes(pRecipeOutput);
        this.itemRecipes(pRecipeOutput);
        this.cookingRecipe(pRecipeOutput, "blasting", (ItemLike)MLItems.BOUND_SOUL_INGOT.get(), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MLItems.POSSESSED_ARMOR_FRAGMENT.get()}), 1.0f, 110, "has_fragment", (Item)MLItems.POSSESSED_ARMOR_FRAGMENT.get());
        this.cookingRecipe(pRecipeOutput, "blasting", (ItemLike)MLItems.ETHEREAL_FLAME.get(), Ingredient.of((ItemLike[])new ItemLike[]{Items.SOUL_LANTERN}), 1.0f, 150, "has_lantern", Items.SOUL_LANTERN);
        this.smithingUpgradeRecipe(pRecipeOutput, (Item)MLItems.INFERNUM_SMITHING_TEMPLATE.get(), Items.NETHERITE_HELMET, (Item)MLItems.INFERNUM_INGOT.get(), (Item)MLItems.INFERNUM_WARPLATE_HELMET.get());
        this.smithingUpgradeRecipe(pRecipeOutput, (Item)MLItems.INFERNUM_SMITHING_TEMPLATE.get(), Items.NETHERITE_CHESTPLATE, (Item)MLItems.INFERNUM_INGOT.get(), (Item)MLItems.INFERNUM_WARPLATE_CHESTPLATE.get());
        this.smithingUpgradeRecipe(pRecipeOutput, (Item)MLItems.INFERNUM_SMITHING_TEMPLATE.get(), Items.NETHERITE_LEGGINGS, (Item)MLItems.INFERNUM_INGOT.get(), (Item)MLItems.INFERNUM_WARPLATE_LEGGINGS.get());
        this.smithingUpgradeRecipe(pRecipeOutput, (Item)MLItems.INFERNUM_SMITHING_TEMPLATE.get(), Items.NETHERITE_BOOTS, (Item)MLItems.INFERNUM_INGOT.get(), (Item)MLItems.INFERNUM_WARPLATE_BOOTS.get());
        this.smithingUpgradeRecipe(pRecipeOutput, (Item)MLItems.INFERNUM_SMITHING_TEMPLATE.get(), (Item)MLItems.STONY_SHIELD.get(), (Item)MLItems.INFERNUM_INGOT.get(), (Item)MLItems.MALEDICTUM_SHIELD.get());
        this.storageBlockRecipe(pRecipeOutput, (Item)MLItems.INFERNUM_INGOT.get(), (Item)MLItems.INFERNUM_BLOCK.get());
        MLRecipeProvider.oneToOneConversionRecipe((RecipeOutput)pRecipeOutput, (ItemLike)Items.ORANGE_DYE, MLItems.MARIGOLD, (String)"orange_dye");
    }

    private void smithingUpgradeRecipe(RecipeOutput pRecipeOutput, Item pTemplate, Item pBase, Item pAddition, Item pResult) {
        SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{pTemplate}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{pBase}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{pAddition}), (RecipeCategory)RecipeCategory.COMBAT, (Item)pResult).unlocks("has_item." + BuiltInRegistries.ITEM.getKey((Object)pAddition).getPath(), MLRecipeProvider.has((ItemLike)pAddition)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"mythsandlegends", (String)BuiltInRegistries.ITEM.getKey((Object)pResult).getPath()));
    }

    private void armorRecipe(RecipeOutput pRecipeOutput) {
        this.shapedRecipe(pRecipeOutput, (Item)MLItems.IRONSHADE_HELMET.get(), RecipeCategory.COMBAT, new String[]{"BAB", "B B"}, Map.of(Character.valueOf('A'), (Item)MLItems.CURSED_CORE.get(), Character.valueOf('B'), (Item)MLItems.BOUND_SOUL_INGOT.get()), List.of((Item)MLItems.CURSED_CORE.get()), 1);
        this.shapedRecipe(pRecipeOutput, (Item)MLItems.SOULPIERCER_HELMET.get(), RecipeCategory.COMBAT, new String[]{"BAB", "C C"}, Map.of(Character.valueOf('A'), (Item)MLItems.CURSED_CORE.get(), Character.valueOf('B'), (Item)MLItems.BOUND_SOUL_INGOT.get(), Character.valueOf('C'), Items.BLUE_WOOL), List.of((Item)MLItems.CURSED_CORE.get()), 1);
        this.shapedRecipe(pRecipeOutput, (Item)MLItems.FROSTHOWL_HELMET.get(), RecipeCategory.COMBAT, new String[]{"AAA", "A A"}, Map.of(Character.valueOf('A'), (Item)MLItems.AMAROK_HIDE.get()), List.of((Item)MLItems.AMAROK_HIDE.get()), 1);
        this.shapedRecipe(pRecipeOutput, (Item)MLItems.IRONSHADE_CHESTPLATE.get(), RecipeCategory.COMBAT, new String[]{"B B", "BAB", "BBB"}, Map.of(Character.valueOf('A'), (Item)MLItems.CURSED_CORE.get(), Character.valueOf('B'), (Item)MLItems.BOUND_SOUL_INGOT.get()), List.of((Item)MLItems.CURSED_CORE.get()), 1);
        this.shapedRecipe(pRecipeOutput, (Item)MLItems.SOULPIERCER_CHESTPLATE.get(), RecipeCategory.COMBAT, new String[]{"C C", "BAB", "BBB"}, Map.of(Character.valueOf('A'), (Item)MLItems.CURSED_CORE.get(), Character.valueOf('B'), (Item)MLItems.BOUND_SOUL_INGOT.get(), Character.valueOf('C'), Items.BLUE_WOOL), List.of((Item)MLItems.CURSED_CORE.get()), 1);
        this.shapedRecipe(pRecipeOutput, (Item)MLItems.FROSTHOWL_CHESTPLATE.get(), RecipeCategory.COMBAT, new String[]{"A A", "AAA", "AAA"}, Map.of(Character.valueOf('A'), (Item)MLItems.AMAROK_HIDE.get()), List.of((Item)MLItems.AMAROK_HIDE.get()), 1);
        this.shapedRecipe(pRecipeOutput, (Item)MLItems.IRONSHADE_LEGGINGS.get(), RecipeCategory.COMBAT, new String[]{"BAB", "B B", "B B"}, Map.of(Character.valueOf('A'), (Item)MLItems.CURSED_CORE.get(), Character.valueOf('B'), (Item)MLItems.BOUND_SOUL_INGOT.get()), List.of((Item)MLItems.CURSED_CORE.get()), 1);
        this.shapedRecipe(pRecipeOutput, (Item)MLItems.SOULPIERCER_LEGGINGS.get(), RecipeCategory.COMBAT, new String[]{"BAB", "B B", "C C"}, Map.of(Character.valueOf('A'), (Item)MLItems.CURSED_CORE.get(), Character.valueOf('B'), (Item)MLItems.BOUND_SOUL_INGOT.get(), Character.valueOf('C'), Items.BLUE_WOOL), List.of((Item)MLItems.CURSED_CORE.get()), 1);
        this.shapedRecipe(pRecipeOutput, (Item)MLItems.FROSTHOWL_LEGGINGS.get(), RecipeCategory.COMBAT, new String[]{"AAA", "A A", "A A"}, Map.of(Character.valueOf('A'), (Item)MLItems.AMAROK_HIDE.get()), List.of((Item)MLItems.AMAROK_HIDE.get()), 1);
        this.shapedRecipe(pRecipeOutput, (Item)MLItems.IRONSHADE_BOOTS.get(), RecipeCategory.COMBAT, new String[]{"A A", "A A"}, Map.of(Character.valueOf('A'), (Item)MLItems.BOUND_SOUL_INGOT.get()), List.of((Item)MLItems.BOUND_SOUL_INGOT.get()), 1);
        this.shapedRecipe(pRecipeOutput, (Item)MLItems.SOULPIERCER_BOOTS.get(), RecipeCategory.COMBAT, new String[]{"B B", "A A"}, Map.of(Character.valueOf('A'), (Item)MLItems.BOUND_SOUL_INGOT.get(), Character.valueOf('B'), Items.BLUE_WOOL), List.of((Item)MLItems.BOUND_SOUL_INGOT.get()), 1);
        this.shapedRecipe(pRecipeOutput, (Item)MLItems.FROSTHOWL_BOOTS.get(), RecipeCategory.COMBAT, new String[]{"A A", "A A"}, Map.of(Character.valueOf('A'), (Item)MLItems.AMAROK_HIDE.get()), List.of((Item)MLItems.AMAROK_HIDE.get()), 1);
    }

    private void toolRecipes(RecipeOutput pRecipeOutput) {
        this.shapedRecipe(pRecipeOutput, (Item)MLItems.GARGOYLE_AXE.get(), RecipeCategory.TOOLS, new String[]{"AA ", "AB ", " B "}, Map.of(Character.valueOf('A'), (Item)MLItems.GARGOYLE_SHARD.get(), Character.valueOf('B'), (Item)MLItems.GARGOYLE_FRAGMENT.get()), List.of((Item)MLItems.GARGOYLE_SHARD.get(), (Item)MLItems.GARGOYLE_FRAGMENT.get()), 1);
        this.shapedRecipe(pRecipeOutput, (Item)MLItems.STONY_SHIELD.get(), RecipeCategory.COMBAT, new String[]{"ABA", "AAA", " A "}, Map.of(Character.valueOf('A'), (Item)MLItems.GARGOYLE_FRAGMENT.get(), Character.valueOf('B'), (Item)MLItems.GARGOYLE_SHARD.get()), List.of((Item)MLItems.GARGOYLE_SHARD.get(), (Item)MLItems.GARGOYLE_FRAGMENT.get()), 1);
        this.shapedRecipe(pRecipeOutput, (Item)MLItems.MOLTEN_FIST.get(), RecipeCategory.COMBAT, new String[]{" BB", "BCS", "SSS"}, Map.of(Character.valueOf('B'), (Item)MLItems.SCORCHED_BONE.get(), Character.valueOf('C'), (Item)MLItems.CORE_OF_ABADDON.get(), Character.valueOf('S'), (Item)MLItems.SCORCHED_SKIN.get()), List.of((Item)MLItems.SCORCHED_BONE.get(), (Item)MLItems.CORE_OF_ABADDON.get(), (Item)MLItems.SCORCHED_SKIN.get()), 1);
    }

    private void itemRecipes(RecipeOutput pRecipeOutput) {
        this.shapedRecipe(pRecipeOutput, MLBlocks.ALTAR_OF_THE_DEAD.asItem(), RecipeCategory.MISC, new String[]{"DBB", "ACA", "CCC"}, Map.of(Character.valueOf('D'), Items.SKELETON_SKULL, Character.valueOf('B'), Items.BLACK_CANDLE, Character.valueOf('A'), (Item)MLItems.MARIGOLD.get(), Character.valueOf('C'), Items.CHISELED_DEEPSLATE), List.of(Items.SKELETON_SKULL, MLBlocks.ALTAR_OF_THE_DEAD.asItem()), 1);
        this.shapedRecipe(pRecipeOutput, (Item)MLItems.INFERNUM_SMITHING_TEMPLATE.get(), RecipeCategory.MISC, new String[]{"ABA", "ACA", "AAA"}, Map.of(Character.valueOf('A'), Items.DIAMOND, Character.valueOf('B'), (Item)MLItems.INFERNUM_SMITHING_TEMPLATE.get(), Character.valueOf('C'), (Item)MLItems.INFERNUM_INGOT.get()), List.of((Item)MLItems.INFERNUM_SMITHING_TEMPLATE.get()), 2);
        this.shapedRecipe(pRecipeOutput, (Item)MLItems.SOULBINDER_AMULET.get(), RecipeCategory.MISC, new String[]{"BAB", "BCB", "BBB"}, Map.of(Character.valueOf('A'), Items.GOLD_INGOT, Character.valueOf('B'), Items.GOLD_NUGGET, Character.valueOf('C'), (Item)MLItems.ETHEREAL_FLAME.get()), List.of(Items.GOLD_INGOT, Items.GOLD_NUGGET, (Item)MLItems.ETHEREAL_FLAME.get()), 1);
        this.shapedRecipe(pRecipeOutput, (Item)MLItems.ANTIQUE_EMBLEM.get(), RecipeCategory.MISC, new String[]{" B ", "BCB", " B "}, Map.of(Character.valueOf('B'), (Item)MLItems.BOUND_SOUL_INGOT.get(), Character.valueOf('C'), (Item)MLItems.CURSED_CORE.get()), List.of((Item)MLItems.POSSESSED_ARMOR_FRAGMENT.get(), (Item)MLItems.CURSED_CORE.get()), 1);
        this.shapedRecipe(pRecipeOutput, MLBlocks.STONE_SANCTUM.asItem(), RecipeCategory.MISC, new String[]{"ABA", " C ", "AAA"}, Map.of(Character.valueOf('A'), Items.CHISELED_TUFF_BRICKS, Character.valueOf('B'), Items.CHISELED_TUFF, Character.valueOf('C'), (Item)MLItems.CURSED_CORE.get()), List.of((Item)MLItems.CURSED_CORE.get(), Items.TUFF, MLBlocks.STONE_SANCTUM.asItem()), 1);
        this.shapedRecipe(pRecipeOutput, (Item)MLItems.NECKLACE_OF_TORNGARSUK.get(), RecipeCategory.MISC, new String[]{"AAA", "ABA", "CDC"}, Map.of(Character.valueOf('A'), (Item)MLItems.BOUND_SOUL_INGOT.get(), Character.valueOf('B'), (Item)MLItems.AMAROK_ESSENCE.get(), Character.valueOf('C'), Items.IRON_NUGGET, Character.valueOf('D'), Items.EMERALD), List.of((Item)MLItems.AMAROK_ESSENCE.get()), 1);
    }

    private void cookingRecipe(RecipeOutput consumer, String type, ItemLike result, Ingredient ingredient, float exp, int cookingTime, String unlockKey, Item unlockItem) {
        SimpleCookingRecipeBuilder builder = switch (type.toLowerCase()) {
            case "smelting" -> SimpleCookingRecipeBuilder.smelting((Ingredient)ingredient, (RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (float)exp, (int)cookingTime);
            case "blasting" -> SimpleCookingRecipeBuilder.blasting((Ingredient)ingredient, (RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (float)exp, (int)cookingTime);
            default -> throw new IllegalArgumentException("Invalid cooking type: " + type);
        };
        builder.unlockedBy(unlockKey, MLRecipeProvider.has((ItemLike)unlockItem)).save(consumer, BuiltInRegistries.ITEM.getKey((Object)result.asItem()));
    }

    private void shapedRecipe(RecipeOutput pConsumer, Item pResult, RecipeCategory pCategory, String[] pPattern, Map<Character, Item> pKeys, List<Item> pUnlockItems, int pCount) {
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.shaped((RecipeCategory)pCategory, (ItemLike)pResult, (int)pCount);
        for (String line : pPattern) {
            builder.pattern(line);
        }
        for (Map.Entry entry : pKeys.entrySet()) {
            builder.define((Character)entry.getKey(), (ItemLike)entry.getValue());
        }
        for (Item item : pUnlockItems) {
            String unlockKey = BuiltInRegistries.ITEM.getKey((Object)item).getPath();
            builder.unlockedBy(unlockKey, MLRecipeProvider.has((ItemLike)item));
        }
        builder.save(pConsumer);
    }

    private void storageBlockRecipe(RecipeOutput output, Item ingot, Item block) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)block).pattern("III").pattern("III").pattern("III").define(Character.valueOf('I'), (ItemLike)ingot).unlockedBy("has_" + BuiltInRegistries.ITEM.getKey((Object)ingot).getPath(), MLRecipeProvider.has((ItemLike)ingot)).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)ingot, (int)9).requires((ItemLike)block).unlockedBy("has_" + BuiltInRegistries.ITEM.getKey((Object)block).getPath(), MLRecipeProvider.has((ItemLike)block)).save(output);
    }
}

