/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.effect;

import com.ovinter.mythsandlegends.api.util.ParticleGeneratorHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class PetrifiedEffect
extends MobEffect {
    private static final ResourceLocation MOVEMENT_SPEED = ResourceLocation.fromNamespaceAndPath((String)"mythsandlegends", (String)"player_movement_speed");
    private static final ResourceLocation JUMP_STRENGTH = ResourceLocation.fromNamespaceAndPath((String)"mythsandlegends", (String)"player_jump_strength");

    public PetrifiedEffect(MobEffectCategory pCategory, int pColor) {
        super(pCategory, pColor);
        this.addAttributeModifier(Attributes.MOVEMENT_SPEED, MOVEMENT_SPEED, -1.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        this.addAttributeModifier(Attributes.JUMP_STRENGTH, JUMP_STRENGTH, -1.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    }

    public boolean applyEffectTick(LivingEntity pLivingEntity, int pAmplifier) {
        ParticleGeneratorHelper.generatePetrifiedParticles(pLivingEntity);
        return super.applyEffectTick(pLivingEntity, pAmplifier);
    }

    public boolean shouldApplyEffectTickThisTick(int pDuration, int pAmplifier) {
        return true;
    }
}

