/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.effect.armor;

import com.ovinter.mythsandlegends.effect.armor.ArmorSetEffect;
import com.ovinter.mythsandlegends.effect.armor.FrosthowlEffect;
import com.ovinter.mythsandlegends.effect.armor.InfernumWarplateEffect;
import com.ovinter.mythsandlegends.effect.armor.IronshadeEffect;
import com.ovinter.mythsandlegends.effect.armor.SoulpiercerEffect;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber(modid="mythsandlegends")
public class ArmorSetHandler {
    private static final List<ArmorSetEffect> SET_EFFECTS = List.of(new IronshadeEffect(), new SoulpiercerEffect(), new InfernumWarplateEffect(), new FrosthowlEffect());
    private static final Map<UUID, ArmorSetEffect> ACTIVE_EFFECTS = new HashMap<UUID, ArmorSetEffect>();

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Pre event) {
        Player genericPlayer = event.getEntity();
        if (genericPlayer.level().isClientSide) {
            return;
        }
        if (!(genericPlayer instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)genericPlayer;
        boolean isNight = player.level().isNight();
        ArmorSetEffect mathchedEffect = null;
        for (ArmorSetEffect effect : SET_EFFECTS) {
            if (!effect.matchesFullSet((LivingEntity)player)) continue;
            mathchedEffect = effect;
            break;
        }
        UUID uuid = player.getUUID();
        if (mathchedEffect != null) {
            ArmorSetEffect currentEffect = ACTIVE_EFFECTS.get(uuid);
            if (currentEffect != mathchedEffect) {
                if (currentEffect != null) {
                    currentEffect.removeEffects(player);
                }
                mathchedEffect.applyEffects(player, isNight);
                ACTIVE_EFFECTS.put(uuid, mathchedEffect);
            } else {
                mathchedEffect.applyEffects(player, isNight);
            }
        } else {
            ArmorSetEffect current = ACTIVE_EFFECTS.remove(uuid);
            if (current != null) {
                current.removeEffects(player);
            }
        }
    }
}

