/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity;

import com.ovinter.mythsandlegends.Config;
import com.ovinter.mythsandlegends.config.DefaultMobAttributes;
import com.ovinter.mythsandlegends.entity.MLEntity;
import com.ovinter.mythsandlegends.entity.ai.goal.amarok.BackStepAttackGoal;
import com.ovinter.mythsandlegends.entity.ai.goal.amarok.CustomHurtByTargetGoal;
import com.ovinter.mythsandlegends.entity.ai.goal.amarok.Spin360AttackGoal;
import com.ovinter.mythsandlegends.entity.ai.goal.generic.AnimatedMeleeAttackGoal;
import com.ovinter.mythsandlegends.entity.ai.goal.generic.ChaseTargetGoal;
import com.ovinter.mythsandlegends.registry.MLParticles;
import com.ovinter.mythsandlegends.registry.MLSounds;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class AmarokEntity
extends MLEntity {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final RawAnimation IDLE_ANIM = RawAnimation.begin().thenLoop("IDLE");
    private final RawAnimation WALK_ANIM = RawAnimation.begin().thenLoop("WALK");
    private final RawAnimation RUN_ANIM = RawAnimation.begin().thenLoop("RUN");
    private final RawAnimation ATTACK_ANIM = RawAnimation.begin().thenPlay("ATTACK");
    private final RawAnimation SPIN_ATTACK_ANIM = RawAnimation.begin().thenPlay("SPIN_ATTACK");
    private final RawAnimation BACKSTEP_JUMP_ANIM = RawAnimation.begin().thenPlay("BACKSTEP_JUMP");
    private final RawAnimation BACKSTEP_ATTACK_ANIM = RawAnimation.begin().thenLoop("BACKSTEP_ATTACK");
    private final RawAnimation HOWL_ANIM = RawAnimation.begin().thenPlay("HOWL");
    public int spinCooldown = DefaultMobAttributes.AMAROK_SPIN_COOLDOWN;
    public int rangedCooldown = DefaultMobAttributes.AMAROK_RANGED_COOLDOWN;
    public boolean showTailParticle = false;
    public int HOWL = 3;
    public int SPIN = 4;
    public int BACKSTEP_JUMP = 5;
    public int BACKSTEP_ATTACK = 6;

    public AmarokEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.setPathfindingMalus(PathType.POWDER_SNOW, -1.0f);
        this.setPathfindingMalus(PathType.DANGER_POWDER_SNOW, -1.0f);
        this.xpReward = 37;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, DefaultMobAttributes.AMAROK_HEALTH).add(Attributes.ARMOR, DefaultMobAttributes.AMAROK_ARMOR).add(Attributes.ATTACK_DAMAGE, DefaultMobAttributes.AMAROK_DAMAGE).add(Attributes.MOVEMENT_SPEED, DefaultMobAttributes.AMAROK_MOVEMENT).add(Attributes.KNOCKBACK_RESISTANCE, DefaultMobAttributes.AMAROK_KNOCKBACK_RESISTANCE).add(Attributes.FOLLOW_RANGE, DefaultMobAttributes.AMAROK_FOLLOW_RANGE).add(Attributes.SAFE_FALL_DISTANCE, DefaultMobAttributes.AMAROK_SAFE_FALL_DISTANCE);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(3, (Goal)new Spin360AttackGoal(this));
        this.goalSelector.addGoal(3, (Goal)new BackStepAttackGoal(this));
        this.goalSelector.addGoal(4, (Goal)new AnimatedMeleeAttackGoal(this, 20, 5, 3.0f));
        this.goalSelector.addGoal(4, (Goal)new ChaseTargetGoal(this, false, 1.8));
        this.goalSelector.addGoal(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0, 80));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 20.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(0, (Goal)new CustomHurtByTargetGoal(this, new Class[0]).setAlertOthers(new Class[]{Wolf.class}));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Sheep.class, true));
    }

    public void tick() {
        if (this.rangedCooldown > 0) {
            --this.rangedCooldown;
        }
        if (this.spinCooldown > 0) {
            --this.spinCooldown;
        }
        super.tick();
    }

    protected void customServerAiStep() {
        if (this.getAttackTicks() > 0) {
            this.setAttackTicks(this.getAttackTicks() - 1);
        }
        super.customServerAiStep();
    }

    protected void tickDeath() {
        ++this.deathTime;
        if (this.deathTime == 60 && !this.level().isClientSide() && !this.isRemoved()) {
            this.remove(Entity.RemovalReason.KILLED);
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)level;
                for (int i = 0; i < 80; ++i) {
                    server.sendParticles((ParticleOptions)MLParticles.SNOW_FLAKE_PARTICLE.get(), this.getX(), this.getY(), this.getZ(), 1, 1.0, 1.0, 1.0, 0.0);
                }
            }
        }
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        this.setConfigAttributes();
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    public boolean isInvulnerableTo(DamageSource source) {
        return source.is(DamageTypes.MAGIC) || source.is(DamageTypes.INDIRECT_MAGIC) || source.is(DamageTypeTags.IS_FREEZING);
    }

    protected float getBlockSpeedFactor() {
        BlockState state = this.level().getBlockState(this.blockPosition());
        if (state.is(Blocks.ICE) || state.is(Blocks.PACKED_ICE) || state.is(Blocks.BLUE_ICE) || state.is(Blocks.FROSTED_ICE)) {
            return 1.0f;
        }
        return super.getBlockSpeedFactor();
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        this.playSound(SoundEvents.WOLF_STEP, 0.15f, 1.0f);
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        if (this.getTarget() != null) {
            return (SoundEvent)MLSounds.AMAROK_GROWL.value();
        }
        return this.getRandom().nextInt(100) < 1 ? (SoundEvent)MLSounds.AMAROK_HOWL.value() : null;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)MLSounds.AMAROK_HURT.value();
    }

    protected SoundEvent getDeathSound() {
        return null;
    }

    public void playHowlSound() {
        this.playSound((SoundEvent)MLSounds.AMAROK_HOWL.value());
    }

    @Override
    PlayState movementPredicate(AnimationState<?> state) {
        if (this.isDeadOrDying()) {
            return state.setAndContinue(this.HOWL_ANIM);
        }
        if (this.getAnimationId() == this.HOWL) {
            return state.setAndContinue(this.HOWL_ANIM);
        }
        if (this.getAnimationId() == this.SPIN) {
            return state.setAndContinue(this.SPIN_ATTACK_ANIM);
        }
        if (this.getAnimationId() == this.BACKSTEP_JUMP) {
            return state.setAndContinue(this.BACKSTEP_JUMP_ANIM);
        }
        if (this.getAnimationId() == 2) {
            return state.setAndContinue(this.BACKSTEP_ATTACK_ANIM);
        }
        if (state.isMoving() && this.isRunning()) {
            return state.setAndContinue(this.RUN_ANIM);
        }
        return state.isMoving() ? state.setAndContinue(this.WALK_ANIM) : state.setAndContinue(this.IDLE_ANIM);
    }

    @Override
    PlayState attackPredicate(AnimationState<?> state) {
        if (this.isDeadOrDying()) {
            return PlayState.STOP;
        }
        if (this.getAnimationId() == 1 && this.getAttackTicks() == 19 && this.isAlive()) {
            state.getController().forceAnimationReset();
            return state.setAndContinue(this.ATTACK_ANIM);
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "movementController", 5, this::movementPredicate).setParticleKeyframeHandler(state -> {
            this.showTailParticle = state.getKeyframeData().getEffect().equals("tail");
        }).setSoundKeyframeHandler(state -> {
            if (state.getKeyframeData().getSound().equals("howl")) {
                this.level().playLocalSound(this.getOnPos(), (SoundEvent)MLSounds.AMAROK_HOWL.value(), SoundSource.HOSTILE, 1.0f, 1.0f, false);
            }
        }));
        controllers.add(new AnimationController((GeoAnimatable)this, "attackController", 0, this::attackPredicate).setSoundKeyframeHandler(state -> {
            if (state.getKeyframeData().getSound().equals("attack")) {
                this.level().playLocalSound(this.getOnPos(), (SoundEvent)MLSounds.AMAROK_ATTACK.value(), SoundSource.HOSTILE, 1.0f, 1.0f, false);
            }
        }));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    @Override
    void setConfigAttributes() {
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(((Double)Config.SCORCHED_SENTINEL_HEALTH.get()).doubleValue());
        this.getAttribute(Attributes.ARMOR).setBaseValue(((Double)Config.AMAROK_ARMOR.get()).doubleValue());
        this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(((Double)Config.AMAROK_DAMAGE.get()).doubleValue());
        this.setHealth((float)Config.SCORCHED_SENTINEL_HEALTH.getAsDouble());
    }

    public void performFrostHowl() {
        this.playHowlSound();
        List<Player> players = this.getNearbyPlayers(this.getBoundingBox().inflate(12.0));
        for (Player player : players) {
            player.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 100, 0));
        }
        for (int i = 0; i < 50; ++i) {
            ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.SNOWFLAKE, this.getX() + this.random.nextGaussian(), this.getY() + 1.5, this.getZ() + this.random.nextGaussian(), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public List<Player> getNearbyPlayers(AABB area) {
        return this.level().getEntitiesOfClass(Player.class, area);
    }
}

