/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity;

import com.ovinter.mythsandlegends.Config;
import com.ovinter.mythsandlegends.api.util.ParticleGeneratorHelper;
import com.ovinter.mythsandlegends.api.util.SendMessageToPlayerHelper;
import com.ovinter.mythsandlegends.config.DefaultMobAttributes;
import com.ovinter.mythsandlegends.entity.CondemnedEntity;
import com.ovinter.mythsandlegends.entity.ai.goal.black_charro.RageGoal;
import com.ovinter.mythsandlegends.entity.ai.goal.black_charro.ShootUmbralOrbGoal;
import com.ovinter.mythsandlegends.entity.ai.goal.black_charro.TeleportGoal;
import com.ovinter.mythsandlegends.entity.effects.HellLightEntity;
import com.ovinter.mythsandlegends.entity.projectile.ShadowHorseEntity;
import com.ovinter.mythsandlegends.registry.MLEntities;
import com.ovinter.mythsandlegends.registry.MLSounds;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BlackCharroEntityOld
extends Monster
implements Enemy,
GeoEntity {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation IDLE = RawAnimation.begin().thenPlay("IDLE");
    private static final RawAnimation WALK = RawAnimation.begin().thenPlay("WALK");
    private static final RawAnimation SHOOT = RawAnimation.begin().thenPlay("SHOOT");
    private static final RawAnimation SUMMON_SKELETONS = RawAnimation.begin().thenPlay("SUMMON");
    private static final RawAnimation RAGE = RawAnimation.begin().thenPlay("RAGE");
    private static final RawAnimation ATTACK = RawAnimation.begin().thenPlay("ATTACK");
    public static final RawAnimation SPAWN = RawAnimation.begin().thenPlay("SPAWN");
    public static final RawAnimation TELEPORT = RawAnimation.begin().thenPlay("TELEPORT");
    public static final RawAnimation DEATH = RawAnimation.begin().thenPlay("DEATH");
    private static final EntityDataAccessor<Integer> DATA_SPAWN_TICKS = SynchedEntityData.defineId(BlackCharroEntityOld.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_TELEPORT_CHANCE = SynchedEntityData.defineId(BlackCharroEntityOld.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_REGENERATION_USES_LEFT = SynchedEntityData.defineId(BlackCharroEntityOld.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> DATA_IS_RAGE = SynchedEntityData.defineId(BlackCharroEntityOld.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final ServerBossEvent bossEvent = (ServerBossEvent)new ServerBossEvent(this.getDisplayName(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS).setDarkenScreen(true);
    public float healthPercentage;
    private int lightingCooldown = 60;
    private static int summonCooldown = DefaultMobAttributes.BLACK_CHARRO_SUMMON_COOLDOWN;
    private int combatMessageCooldown = 300;
    private int horseAttackCooldown = 200;

    public BlackCharroEntityOld(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.xpReward = 50;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, DefaultMobAttributes.BLACK_CHARRO_HEALTH).add(Attributes.ARMOR, DefaultMobAttributes.BLACK_CHARRO_ARMOR).add(Attributes.ATTACK_DAMAGE, DefaultMobAttributes.BLACK_CHARRO_DAMAGE).add(Attributes.MOVEMENT_SPEED, DefaultMobAttributes.BLACK_CHARRO_MOVEMENT).add(Attributes.KNOCKBACK_RESISTANCE, DefaultMobAttributes.BLACK_CHARRO_KNOCKBACK_RESISTANCE).add(Attributes.FOLLOW_RANGE, DefaultMobAttributes.BLACK_CHARRO_FOLLOW_RANGE);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(2, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(3, (Goal)new RageGoal(this));
        this.goalSelector.addGoal(3, (Goal)new TeleportGoal(this));
        this.goalSelector.addGoal(3, (Goal)new ShootUmbralOrbGoal(this));
        this.goalSelector.addGoal(3, (Goal)new SummonMinionsGoal(this, this));
        this.goalSelector.addGoal(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 30.0f));
        this.goalSelector.addGoal(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[]{CondemnedEntity.class}));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(DATA_TELEPORT_CHANCE, (Object)9);
        pBuilder.define(DATA_REGENERATION_USES_LEFT, (Object)2);
        pBuilder.define(DATA_SPAWN_TICKS, (Object)40);
        pBuilder.define(DATA_IS_RAGE, (Object)false);
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putInt("SpawnTimer", this.getSpawnTicks());
        pCompound.putInt("Regeneration", this.getRegenerationUsesLeft());
        pCompound.putInt("Teleport", this.getTeleportChance());
        pCompound.putBoolean("IsRage", this.getIsRage());
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.setSpawnTicks(pCompound.getInt("SpawnTimer"));
        this.setRegenerationUses(pCompound.getInt("Regeneration"));
        this.setTeleportChance(pCompound.getInt("Teleport"));
        this.setIsRage(pCompound.getBoolean("IsRage"));
    }

    public void setCustomName(@Nullable Component pName) {
        super.setCustomName(pName);
        this.bossEvent.setName(this.getDisplayName());
    }

    public void handleEntityEvent(byte pId) {
        if (pId == 69) {
            ParticleGeneratorHelper.generateDustParticles((LivingEntity)this, 0.0f, 0.0f, 0.0f, 20.0f, true, true);
        }
        super.handleEntityEvent(pId);
    }

    public void tick() {
        this.handleParticles();
        this.healthPercentage = this.getHealth() / this.getMaxHealth();
        this.handleMessageCooldown();
        this.handleSummonLightingCooldown();
        if (summonCooldown > 0) {
            --summonCooldown;
        }
        if (this.getSpawnTicks() <= 0 && !this.isDeadOrDying() && this.level().isClientSide) {
            ParticleGeneratorHelper.generateSkullParticles((Entity)this);
        }
        super.tick();
    }

    protected void customServerAiStep() {
        this.bossEvent.setProgress(this.healthPercentage);
        if (this.getSpawnTicks() > 0) {
            this.setSpawnTicks(this.getSpawnTicks() - 1);
        }
        super.customServerAiStep();
    }

    public void travel(Vec3 pTravelVector) {
        if (this.getSpawnTicks() > 0 || this.getIsRage()) {
            if (this.getNavigation().getPath() != null) {
                this.getNavigation().stop();
            }
            super.travel(Vec3.ZERO);
            return;
        }
        super.travel(pTravelVector);
    }

    public boolean isInvulnerable() {
        return this.getSpawnTicks() > 0;
    }

    public void startSeenByPlayer(ServerPlayer pServerPlayer) {
        super.startSeenByPlayer(pServerPlayer);
        this.bossEvent.addPlayer(pServerPlayer);
    }

    public void stopSeenByPlayer(ServerPlayer pServerPlayer) {
        super.stopSeenByPlayer(pServerPlayer);
        this.bossEvent.removePlayer(pServerPlayer);
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        if (this.isDeadOrDying() || pSource.is(DamageTypeTags.IS_LIGHTNING) || pSource.is(DamageTypeTags.IS_FIRE) || pSource.is(DamageTypeTags.IS_DROWNING) || pSource.is(DamageTypeTags.IS_FALL) || pSource.is(DamageTypes.WITHER) || pSource.is(DamageTypeTags.IS_EXPLOSION)) {
            return false;
        }
        return super.hurt(pSource, pAmount);
    }

    protected SoundEvent getHurtSound(DamageSource pDamageSource) {
        return (SoundEvent)MLSounds.BLACK_CHARRO_HURT.value();
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return !this.isDeadOrDying() ? (SoundEvent)MLSounds.BLACK_CHARRO_AMBIENT.value() : null;
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)MLSounds.BLACK_CHARRO_DEATH.value();
    }

    public void playTeleportSound() {
        this.playSound((SoundEvent)MLSounds.BLACK_CHARRO_TELEPORT.value(), 1.0f, 1.0f);
    }

    public void playRageSound() {
        this.playSound((SoundEvent)MLSounds.BLACK_CHARRO_RAGE.value(), 1.5f, 1.0f);
    }

    protected void playStepSound(BlockPos pPos, BlockState pState) {
    }

    public boolean removeWhenFarAway(double pDistanceToClosestPlayer) {
        return false;
    }

    public boolean canChangeDimensions(Level pOldLevel, Level pNewLevel) {
        return false;
    }

    public boolean isOnFire() {
        return false;
    }

    protected void tickDeath() {
        ++this.deathTime;
        if (this.deathTime == 50 && !this.level().isClientSide()) {
            this.level().broadcastEntityEvent((Entity)this, (byte)60);
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    public void die(DamageSource damageSource) {
        if (!this.level().isClientSide) {
            Entity entity = damageSource.getEntity();
            HellLightEntity hellLightEntity = new HellLightEntity(MLEntities.HELL_LIGHT.get(), this.level());
            Vec3 pos = new Vec3(this.getX(), this.getY(), this.getZ());
            hellLightEntity.setPos(pos);
            this.level().addFreshEntity((Entity)hellLightEntity);
            if (entity instanceof Player) {
                Player player = (Player)entity;
                SendMessageToPlayerHelper.sendRandomMessage("gets_defeated", player, 5);
            }
        }
        super.die(damageSource);
    }

    public boolean isAlliedTo(Entity entity) {
        if (entity == this) {
            return true;
        }
        if (entity.getClass() == ((Object)((Object)this)).getClass()) {
            return true;
        }
        if (entity instanceof CondemnedEntity) {
            return true;
        }
        return super.isAlliedTo(entity);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        this.setConfigAttributes();
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    public void setIsRage(boolean pIsRage) {
        this.entityData.set(DATA_IS_RAGE, (Object)pIsRage);
    }

    public boolean getIsRage() {
        return (Boolean)this.entityData.get(DATA_IS_RAGE);
    }

    public void setRegenerationUses(int pRegenerationUses) {
        this.entityData.set(DATA_REGENERATION_USES_LEFT, (Object)pRegenerationUses);
    }

    public int getRegenerationUsesLeft() {
        return (Integer)this.entityData.get(DATA_REGENERATION_USES_LEFT);
    }

    public void setTeleportChance(int pTeleportChance) {
        this.entityData.set(DATA_TELEPORT_CHANCE, (Object)pTeleportChance);
    }

    public int getTeleportChance() {
        return (Integer)this.getEntityData().get(DATA_TELEPORT_CHANCE);
    }

    public void setSpawnTicks(int pSpawnTimer) {
        this.getEntityData().set(DATA_SPAWN_TICKS, (Object)pSpawnTimer);
    }

    public int getSpawnTicks() {
        return (Integer)this.getEntityData().get(DATA_SPAWN_TICKS);
    }

    PlayState spawnPredicate(AnimationState<?> state) {
        if (this.getSpawnTicks() > 0) {
            return state.setAndContinue(SPAWN);
        }
        return PlayState.STOP;
    }

    PlayState movementPredicate(AnimationState<?> state) {
        if (this.getSpawnTicks() > 0) {
            return PlayState.STOP;
        }
        return state.isMoving() && this.getSpawnTicks() <= 0 ? state.setAndContinue(WALK) : state.setAndContinue(IDLE);
    }

    protected PlayState attackPredicate(AnimationState<?> state) {
        if (this.isDeadOrDying()) {
            return PlayState.STOP;
        }
        if (this.swinging && state.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            state.getController().forceAnimationReset();
            this.swinging = false;
            return state.setAndContinue(ATTACK);
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "spawnController", 0, this::spawnPredicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", 5, this::movementPredicate).triggerableAnim("summon", SUMMON_SKELETONS).triggerableAnim("rage", RAGE).triggerableAnim("teleport", TELEPORT));
        controllers.add(new AnimationController((GeoAnimatable)this, "deathController", 0, state -> {
            if (this.isDeadOrDying() || (double)this.getHealth() < 0.01) {
                state.getController().setAnimation(DEATH);
            }
            return PlayState.CONTINUE;
        }));
        controllers.add(new AnimationController((GeoAnimatable)this, "attackController", 2, this::attackPredicate).triggerableAnim("shoot", SHOOT));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    public void handleMessageCooldown() {
        LivingEntity livingEntity;
        if (this.combatMessageCooldown >= 0) {
            --this.combatMessageCooldown;
        } else if (!this.isDeadOrDying() && (livingEntity = this.getTarget()) instanceof Player) {
            Player player = (Player)livingEntity;
            this.playAmbientSound();
            SendMessageToPlayerHelper.sendRandomMessage("combat_message", player, 5);
            this.combatMessageCooldown = 300;
        }
    }

    void setConfigAttributes() {
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(Config.BLACK_CHARRO_HEALTH.getAsDouble());
        this.getAttribute(Attributes.ARMOR).setBaseValue(Config.BLACK_CHARRO_ARMOR.getAsDouble());
        this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(Config.BLACK_CHARRO_DAMAGE.getAsDouble());
        this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(Config.BLACK_CHARRO_MOVEMENT.getAsDouble());
        this.getAttribute(Attributes.KNOCKBACK_RESISTANCE).setBaseValue(Config.BLACK_CHARRO_KNOCKBACK_RESISTANCE.getAsDouble());
        this.setHealth((float)Config.BLACK_CHARRO_HEALTH.getAsDouble());
    }

    public void handleSummonLightingCooldown() {
        if ((double)this.healthPercentage <= 0.3 && this.lightingCooldown <= 0 && !this.isDeadOrDying()) {
            this.summonLightingInRadius();
        } else {
            --this.lightingCooldown;
        }
    }

    public void rage() {
        this.triggerAnim("controller", "rage");
        this.setRegenerationUses((Integer)this.getEntityData().get(DATA_REGENERATION_USES_LEFT) - 1);
        this.setTeleportChance((Integer)this.getEntityData().get(DATA_TELEPORT_CHANCE) + 3);
        this.teleportToSky();
        this.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 200, 6, false, false));
        this.playRageSound();
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos pos = new BlockPos((int)this.getX(), (int)this.getY(), (int)this.getZ());
            serverLevel.playSound(null, pos, (SoundEvent)MLSounds.BLACK_CHARRO_RAGE.value(), SoundSource.HOSTILE, 4.0f, 1.0f);
            LightningBolt lightningBolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create((Level)serverLevel);
            if (lightningBolt != null) {
                lightningBolt.moveTo(Vec3.atBottomCenterOf((Vec3i)pos));
                lightningBolt.setVisualOnly(true);
                serverLevel.addFreshEntity((Entity)lightningBolt);
            }
        }
    }

    public void summonLightingInRadius() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (int i = 0; i < 5; ++i) {
                double offsetX = (this.random.nextDouble() - 0.5) * 2.0 * 20.0;
                double offsetZ = (this.random.nextDouble() - 0.5) * 2.0 * 20.0;
                double x = this.getX() + offsetX;
                double y = this.getY();
                double z = this.getZ() + offsetZ;
                BlockPos targetPos = new BlockPos((int)x, (int)y, (int)z);
                LightningBolt lightningBolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create((Level)serverLevel);
                if (lightningBolt != null) {
                    lightningBolt.moveTo(Vec3.atBottomCenterOf((Vec3i)targetPos));
                    serverLevel.addFreshEntity((Entity)lightningBolt);
                }
                this.lightingCooldown = 60;
            }
        }
    }

    public void summonShadowHorseCharge(LivingEntity target) {
        Vec3 charroPos = this.position();
        Vec3 toTarget = target.position().subtract(charroPos).normalize();
        Vec3 lateral = new Vec3(-toTarget.z, 0.0, toTarget.x).normalize();
        int horseCount = 5;
        double spacing = 1.5;
        for (int i = 0; i < horseCount; ++i) {
            int offsetIndex = i - horseCount / 2;
            Vec3 spawnOffset = lateral.scale((double)offsetIndex * spacing);
            Vec3 spawnPos = charroPos.add(spawnOffset).add(0.0, 0.5, 0.0);
            ShadowHorseEntity horse = new ShadowHorseEntity(MLEntities.SHADOW_HORSE.get(), this.level());
            horse.setPos(spawnPos);
            horse.setDeltaMovement(toTarget.scale(0.6));
            horse.setOwner((LivingEntity)this);
            this.level().addFreshEntity((Entity)horse);
        }
        this.level().playSound(null, charroPos.x, charroPos.y, charroPos.z, (SoundEvent)MLSounds.BLACK_CHARRO_TELEPORT.value(), SoundSource.HOSTILE, 1.5f, 1.0f);
    }

    public boolean isValidTeleportLocation(double x, double y, double z) {
        BlockPos pos = new BlockPos((int)x, (int)y, (int)z);
        boolean isSolidBelow = this.level().getBlockState(pos.below()).isSolid();
        boolean isEmptyOrWater = this.level().getBlockState(pos).isAir() || this.level().getFluidState(pos.below()).is(FluidTags.WATER) || this.level().getFluidState(pos.below()).is(FluidTags.LAVA);
        return isEmptyOrWater && isSolidBelow;
    }

    public void teleportToSky() {
        BlockPos groundPos = this.blockPosition();
        BlockPos abovePos = groundPos.above(7);
        if (this.isValidTeleportLocation(this.getX(), this.getY(), this.getZ())) {
            this.playTeleportSound();
            this.triggerAnim("controller", "teleport");
            this.level().broadcastEntityEvent((Entity)this, (byte)69);
            this.teleportTo((double)abovePos.getX() + 0.5, abovePos.getY(), (double)abovePos.getZ() + 0.5);
        }
    }

    void handleParticles() {
        if (this.getSpawnTicks() > 0 || this.isDeadOrDying()) {
            ParticleGeneratorHelper.generateEntitySpawnFromGroundParticles(this.level(), (LivingEntity)this);
        }
        if (this.level().isClientSide && this.getSpawnTicks() == 0 && this.isAlive()) {
            ParticleGeneratorHelper.generateSkullParticles((Entity)this);
        }
    }

    public class SummonMinionsGoal
    extends Goal {
        BlackCharroEntityOld mob;
        LivingEntity target;
        private int CONDEMNED_TO_SPAWN = 2;
        private int summonTick;

        public SummonMinionsGoal(BlackCharroEntityOld this$0, BlackCharroEntityOld pEntity) {
            this.mob = pEntity;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
        }

        public void start() {
            this.summonTick = 0;
        }

        public boolean canUse() {
            this.target = this.mob.getTarget();
            return this.target != null && this.target.isAlive() && this.mob.onGround() && !this.mob.isInLava() && !this.mob.isDeadOrDying() && summonCooldown <= 0;
        }

        public boolean canContinueToUse() {
            return summonCooldown <= 0 && this.target != null && this.mob.isAlive();
        }

        public void stop() {
            this.mob.getNavigation().recomputePath();
            this.target = null;
            this.summonTick = 0;
            summonCooldown = (double)this.mob.healthPercentage <= 0.6 ? 400 : 540;
        }

        public void tick() {
            ++this.summonTick;
            if (this.target != null && summonCooldown == 0) {
                if (this.summonTick >= 40) {
                    this.stop();
                    return;
                }
                if (this.summonTick == 18) {
                    if (this.target instanceof Player) {
                        SendMessageToPlayerHelper.sendRandomMessage("summon_condemned", (Player)this.target, 6);
                    }
                    this.summonCondemned();
                }
            }
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        void summonCondemned() {
            this.mob.triggerAnim("controller", "summon");
            this.mob.playSound((SoundEvent)MLSounds.BLACK_CHARRO_SUMMON.value(), 10.0f, 1.0f);
            this.CONDEMNED_TO_SPAWN = (double)this.mob.healthPercentage <= 0.3 ? 4 : 2;
            for (int i = 0; i < this.CONDEMNED_TO_SPAWN; ++i) {
                CondemnedEntity condemned = new CondemnedEntity(MLEntities.CONDEMNED.get(), this.mob.level());
                double offsetX = (this.mob.getRandom().nextDouble() - 0.5) * 5.0;
                double offsetZ = (this.mob.getRandom().nextDouble() - 0.5) * 5.0;
                condemned.setPos(this.mob.getX() + offsetX, this.mob.getY(), this.mob.getZ() + offsetZ);
                this.mob.level().addFreshEntity((Entity)condemned);
            }
        }
    }
}

