/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity;

import com.ovinter.mythsandlegends.Config;
import com.ovinter.mythsandlegends.api.util.ParticleGeneratorHelper;
import com.ovinter.mythsandlegends.config.DefaultMobAttributes;
import com.ovinter.mythsandlegends.entity.MLEntity;
import com.ovinter.mythsandlegends.entity.ai.goal.generic.AnimatedMeleeAttackGoal;
import com.ovinter.mythsandlegends.entity.ai.goal.generic.ChaseTargetGoal;
import com.ovinter.mythsandlegends.entity.ai.goal.karakondjul.SleepGoal;
import com.ovinter.mythsandlegends.registry.MLSounds;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class KarakondjulEntity
extends MLEntity {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final RawAnimation IDLE_ANIM = RawAnimation.begin().thenLoop("IDLE");
    private final RawAnimation WALK_ANIM = RawAnimation.begin().thenLoop("WALK");
    private final RawAnimation RUN_ANIM = RawAnimation.begin().thenLoop("RUN");
    private final RawAnimation ATTACK_ANIM = RawAnimation.begin().thenPlay("ATTACK");
    private final RawAnimation SLEEP_ANIM_ANIM = RawAnimation.begin().thenLoop("SLEEP");
    private final RawAnimation DEATH_ANIM = RawAnimation.begin().thenPlay("DEATH");
    public final int SLEEP = 3;
    private static final EntityDataAccessor<Boolean> DATA_IS_SLEEPING = SynchedEntityData.defineId(KarakondjulEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public KarakondjulEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.xpReward = 37;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, DefaultMobAttributes.KARAKONDJUL_HEALTH).add(Attributes.ARMOR, DefaultMobAttributes.KARAKONDJUL_ARMOR).add(Attributes.ARMOR_TOUGHNESS, DefaultMobAttributes.KARAKONDJUL_ARMOR_TOUGHNESS).add(Attributes.ATTACK_DAMAGE, DefaultMobAttributes.KARAKONDJUL_DAMAGE).add(Attributes.MOVEMENT_SPEED, DefaultMobAttributes.KARAKONDJUL_MOVEMENT).add(Attributes.FOLLOW_RANGE, DefaultMobAttributes.KARAKONDJUL_FOLLOW_RANGE).add(Attributes.KNOCKBACK_RESISTANCE, DefaultMobAttributes.KARAKONDJUL_KNOCKBACK_RESISTANCE);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(4, (Goal)new SleepGoal(this));
        this.goalSelector.addGoal(4, (Goal)new AnimatedMeleeAttackGoal(this, 20, 3, 3.0f));
        this.goalSelector.addGoal(4, (Goal)new ChaseTargetGoal(this, false, 1.6));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.2));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 12.0f));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[]{KarakondjulEntity.class}));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Animal.class, true));
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(DATA_IS_SLEEPING, (Object)false);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.setIsSleeping(pCompound.getBoolean("IsSleeping"));
    }

    @Override
    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putBoolean("IsSleeping", this.getIsSleeping());
    }

    protected void customServerAiStep() {
        if (this.getAttackTicks() > 0) {
            this.setAttackTicks(this.getAttackTicks() - 1);
        }
        super.customServerAiStep();
    }

    protected void tickDeath() {
        ++this.deathTime;
        if (this.deathTime >= 25 && !this.level().isClientSide() && !this.isRemoved()) {
            this.level().broadcastEntityEvent((Entity)this, (byte)60);
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    public void handleEntityEvent(byte id) {
        if (id == 69) {
            ParticleGeneratorHelper.generateHealingParticles(this.level(), (LivingEntity)this);
        }
        super.handleEntityEvent(id);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        this.setConfigAttributes();
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    public boolean doHurtTarget(Entity pEntity) {
        if (pEntity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)pEntity;
            this.applyFreezingEffect(livingEntity);
        }
        return super.doHurtTarget(pEntity);
    }

    public boolean canFreeze() {
        return false;
    }

    public boolean isAlliedTo(Entity pEntity) {
        if (pEntity == this) {
            return true;
        }
        if (pEntity.getClass() == this.getClass()) {
            return true;
        }
        return super.isAlliedTo(pEntity);
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return (SoundEvent)MLSounds.KARAKONDJUL_AMBIENT.value();
    }

    @NotNull
    protected SoundEvent getHurtSound(DamageSource pDamageSource) {
        return (SoundEvent)MLSounds.KARAKONDJUL_HURT.value();
    }

    @NotNull
    protected SoundEvent getDeathSound() {
        return (SoundEvent)MLSounds.KARAKONDJUL_DEATH.value();
    }

    public void setIsSleeping(boolean pIsSleeping) {
        this.entityData.set(DATA_IS_SLEEPING, (Object)pIsSleeping);
    }

    public boolean getIsSleeping() {
        return (Boolean)this.entityData.get(DATA_IS_SLEEPING);
    }

    @Override
    PlayState movementPredicate(AnimationState<?> state) {
        if (this.isDeadOrDying()) {
            return state.setAndContinue(this.DEATH_ANIM);
        }
        if (this.getIsSleeping()) {
            return state.setAndContinue(this.SLEEP_ANIM_ANIM);
        }
        if (state.isMoving() && this.isRunning()) {
            return state.setAndContinue(this.RUN_ANIM);
        }
        return state.isMoving() ? state.setAndContinue(this.WALK_ANIM) : state.setAndContinue(this.IDLE_ANIM);
    }

    @Override
    PlayState attackPredicate(AnimationState<?> state) {
        if (this.isDeadOrDying()) {
            return PlayState.STOP;
        }
        if (this.getAnimationId() == 1 && this.getAttackTicks() == 19) {
            state.getController().forceAnimationReset();
            return state.setAndContinue(this.ATTACK_ANIM);
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "movementController", 5, this::movementPredicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "attackController", 5, this::attackPredicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    @Override
    void setConfigAttributes() {
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(((Double)Config.KARAKONDJUL_HEALTH.get()).doubleValue());
        this.getAttribute(Attributes.ARMOR).setBaseValue(((Double)Config.KARAKONDJUL_ARMOR.get()).doubleValue());
        this.getAttribute(Attributes.ARMOR_TOUGHNESS).setBaseValue(((Double)Config.KARAKONDJUL_ARMOR_TOUGHNESS.get()).doubleValue());
        this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(((Double)Config.KARAKONDJUL_DAMAGE.get()).doubleValue());
        this.getAttribute(Attributes.KNOCKBACK_RESISTANCE).setBaseValue(((Double)Config.KARAKONDJUL_KNOCKBACK_RESISTANCE.get()).doubleValue());
        this.setHealth((float)Config.KARAKONDJUL_HEALTH.getAsDouble());
    }

    void applyFreezingEffect(LivingEntity pTarget) {
        int current = pTarget.getTicksFrozen();
        int max = pTarget.getTicksRequiredToFreeze();
        int freezeAmount = 60;
        pTarget.setTicksFrozen(Math.min(current + freezeAmount, max));
    }
}

