/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity;

import com.ovinter.mythsandlegends.Config;
import com.ovinter.mythsandlegends.config.DefaultMobAttributes;
import com.ovinter.mythsandlegends.entity.AbstractPossessedArmor;
import com.ovinter.mythsandlegends.entity.ai.goal.generic.AnimatedMeleeAttackGoal;
import com.ovinter.mythsandlegends.entity.ai.goal.generic.ChaseTargetGoal;
import com.ovinter.mythsandlegends.registry.MLSounds;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class PossessedArmorEntity
extends AbstractPossessedArmor {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation IDLE_ANIM = RawAnimation.begin().thenLoop("IDLE");
    private static final RawAnimation WALK_ANIM = RawAnimation.begin().thenLoop("WALK");
    private static final RawAnimation ATTACK_ANIM = RawAnimation.begin().thenPlay("ATTACK");
    private static final RawAnimation ATTACK_ALT_ANIM = RawAnimation.begin().thenPlay("ATTACK_ALT");
    private static final RawAnimation DEATH_ANIM = RawAnimation.begin().thenPlay("DEATH");

    public PossessedArmorEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.xpReward = 13;
    }

    @Override
    public ResourceLocation getModelResource() {
        return ResourceLocation.fromNamespaceAndPath((String)"mythsandlegends", (String)"geo/entity/possessed_armor.geo.json");
    }

    @Override
    public ResourceLocation getTextureResource() {
        return this.getHasHalfHealth() ? ResourceLocation.fromNamespaceAndPath((String)"mythsandlegends", (String)"textures/entity/possessed_armor/possessed_armor_damaged.png") : ResourceLocation.fromNamespaceAndPath((String)"mythsandlegends", (String)"textures/entity/possessed_armor/possessed_armor.png");
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, DefaultMobAttributes.POSSESSED_ARMOR_HEALTH).add(Attributes.MOVEMENT_SPEED, DefaultMobAttributes.POSSESSED_ARMOR_MOVEMENT).add(Attributes.WATER_MOVEMENT_EFFICIENCY, DefaultMobAttributes.POSSESSED_ARMOR_WATER_MOVEMENT).add(Attributes.FOLLOW_RANGE, DefaultMobAttributes.POSSESSED_ARMOR_FOLLOW_RANGE).add(Attributes.ARMOR, DefaultMobAttributes.POSSESSED_ARMOR_ARMOR).add(Attributes.ARMOR_TOUGHNESS, DefaultMobAttributes.POSSESSED_ARMOR_ARMOR_TOUGHNESS).add(Attributes.ATTACK_DAMAGE, DefaultMobAttributes.POSSESSED_ARMOR_DAMAGE).add(Attributes.ATTACK_KNOCKBACK, DefaultMobAttributes.POSSESSED_ARMOR_ATTACK_KNOCKBACK).add(Attributes.KNOCKBACK_RESISTANCE, DefaultMobAttributes.POSSESSED_ARMOR_KNOCKBACK_RESISTANCE);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(3, (Goal)new AnimatedMeleeAttackGoal(this, 20, 3, 2.7f));
        this.goalSelector.addGoal(3, (Goal)new ChaseTargetGoal(this, false, 1.2));
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pSpawnType, @Nullable SpawnGroupData pSpawnGroupData) {
        RandomSource randomsource = pLevel.getRandom();
        this.populateDefaultEquipmentSlots(randomsource, pDifficulty);
        this.populateDefaultEquipmentEnchantments(pLevel, randomsource, pDifficulty);
        this.setConfigAttributes();
        return super.finalizeSpawn(pLevel, pDifficulty, pSpawnType, pSpawnGroupData);
    }

    protected void populateDefaultEquipmentSlots(RandomSource pRandom, DifficultyInstance pDifficulty) {
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.IRON_SWORD));
        this.setDropChance(EquipmentSlot.MAINHAND, 0.0f);
    }

    @Override
    PlayState movementPredicate(AnimationState<?> state) {
        if (this.isDeadOrDying()) {
            return state.setAndContinue(DEATH_ANIM);
        }
        if (state.isMoving()) {
            return state.setAndContinue(WALK_ANIM);
        }
        return state.setAndContinue(IDLE_ANIM);
    }

    @Override
    PlayState attackPredicate(AnimationState<?> state) {
        if (this.isDeadOrDying()) {
            return PlayState.STOP;
        }
        if (this.getAnimationId() == 1 && this.isAlive() && this.getAttackTicks() == 19) {
            state.getController().forceAnimationReset();
            return state.setAndContinue(this.getRandomAttackAnim());
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "movementController", 5, this::movementPredicate).setSoundKeyframeHandler(state -> {
            if (state.getKeyframeData().getSound().equals("step") && this.onGround()) {
                this.level().playLocalSound(this.getOnPos(), (SoundEvent)MLSounds.POSSESSED_ARMOR_STEP.value(), SoundSource.HOSTILE, 1.0f, 1.0f, false);
            }
        }));
        controllers.add(new AnimationController((GeoAnimatable)this, "attackController", 0, this::attackPredicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    @Override
    void setConfigAttributes() {
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(((Double)Config.POSSESSED_ARMOR_HEALTH.get()).doubleValue());
        this.getAttribute(Attributes.ARMOR).setBaseValue(((Double)Config.POSSESSED_ARMOR_ARMOR.get()).doubleValue());
        this.getAttribute(Attributes.ARMOR).setBaseValue(((Double)Config.POSSESSED_ARMOR_ARMOR.get()).doubleValue());
        this.getAttribute(Attributes.ARMOR_TOUGHNESS).setBaseValue(((Double)Config.POSSESSED_ARMOR_ARMOR_TOUGHNESS.get()).doubleValue());
        this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(((Double)Config.POSSESSED_ARMOR_DAMAGE.get()).doubleValue());
        this.getAttribute(Attributes.ATTACK_KNOCKBACK).setBaseValue(((Double)Config.POSSESSED_ARMOR_ATTACK_KNOCKBACK.get()).doubleValue());
        this.getAttribute(Attributes.KNOCKBACK_RESISTANCE).setBaseValue(((Double)Config.POSSESSED_ARMOR_KNOCKBACK_RESISTANCE.get()).doubleValue());
        this.setHealth((float)((Double)Config.POSSESSED_ARMOR_HEALTH.get()).doubleValue());
    }

    private RawAnimation getRandomAttackAnim() {
        int id = this.getRandom().nextInt(2) + 1;
        return id == 1 ? ATTACK_ANIM : ATTACK_ALT_ANIM;
    }
}

