/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity;

import com.ovinter.mythsandlegends.api.util.ParticleGeneratorHelper;
import com.ovinter.mythsandlegends.config.DefaultMobAttributes;
import com.ovinter.mythsandlegends.entity.IgnisNexusEntity;
import com.ovinter.mythsandlegends.entity.MLEntity;
import com.ovinter.mythsandlegends.entity.effects.EffectScreenShake;
import com.ovinter.mythsandlegends.entity.effects.FallingBlockEntity;
import com.ovinter.mythsandlegends.entity.effects.MoltenThornEntity;
import com.ovinter.mythsandlegends.registry.MLSounds;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.fluids.FluidType;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class WarbornAegisEntity
extends MLEntity {
    AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("IDLE");
    private static final RawAnimation WALK = RawAnimation.begin().thenLoop("WALK");
    private static final RawAnimation ATTACK = RawAnimation.begin().thenPlay("ATTACK");
    private static final RawAnimation ATTACK2 = RawAnimation.begin().thenPlay("ATTACK2");
    private static final RawAnimation ATTACK3 = RawAnimation.begin().thenPlay("ATTACK_COMBO");
    private static final RawAnimation SHIELD_ATTACK = RawAnimation.begin().thenPlay("SHIELD_ATTACK");
    private static final RawAnimation START_JUMP = RawAnimation.begin().thenPlay("START_JUMP");
    private static final RawAnimation METEOR_JUMP = RawAnimation.begin().thenLoop("JUMP");
    private static final RawAnimation KICK_ATTACK = RawAnimation.begin().thenPlay("KICK");
    private static final RawAnimation RAGE = RawAnimation.begin().thenPlay("RAGE");
    private static final RawAnimation DEATH = RawAnimation.begin().thenPlay("DEATH");
    private static final RawAnimation INFERNAL_THORNS = RawAnimation.begin().thenPlay("INFERNAL_THORNS");
    private static final EntityDataAccessor<Integer> LANDING_TICK = SynchedEntityData.defineId(WarbornAegisEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private final Set<UUID> ignisNexusUUIDs = new HashSet<UUID>();
    private static final ResourceLocation SPEED_MODIFIER_ID = ResourceLocation.fromNamespaceAndPath((String)"mythsandlegends", (String)"rage_speed_boost");
    private static final ResourceLocation DAMAGE_MODIFIER_ID = ResourceLocation.fromNamespaceAndPath((String)"mythsandlegends", (String)"rage_damage_boost");
    private final ServerBossEvent bossEvent = (ServerBossEvent)new ServerBossEvent(this.getDisplayName(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS).setDarkenScreen(true);
    private float healthPercentage;
    public static final int START_METEOR_SLAM = 2;
    public static final int METEOR_SLAM = 3;
    public static final int SHIELD_STAMPEDE = 4;
    public static final int KICK = 5;
    public static final int ATTACK_COMBO = 6;
    public static final int INFERNAL_THORN = 7;
    public static int meteorCooldown = DefaultMobAttributes.WARBORN_AEGIS_METEOR_COOLDOWN;
    public static int stampedeCooldown = DefaultMobAttributes.WARBORN_AEGIS_STAMPEDE_COOLDOWN;
    public static int kickCooldown = DefaultMobAttributes.WARBORN_AEGIS_KICK_COOLDOWN;
    public static int singleAttackCooldown = DefaultMobAttributes.WARBORN_AEGIS_COMBO_COOLDOWN;
    public static int comboCooldown = DefaultMobAttributes.WARBORN_AEGIS_COMBO_COOLDOWN;
    public static int infernalThornsCooldown = DefaultMobAttributes.WARBORN_AEGIS_KICK_COOLDOWN;
    public boolean isEnraged;
    public int rageTimer;

    public WarbornAegisEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.setPathfindingMalus(PathType.LAVA, 0.0f);
        this.setPathfindingMalus(PathType.WATER, -1.0f);
        this.setPathfindingMalus(PathType.DANGER_FIRE, 0.0f);
        this.xpReward = 150;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, DefaultMobAttributes.WARBORN_AEGIS_HEALTH).add(Attributes.ARMOR, DefaultMobAttributes.WARBORN_AEGIS_ARMOR).add(Attributes.ARMOR_TOUGHNESS, DefaultMobAttributes.WARBORN_AEGIS_ARMOR_TOUGHNESS).add(Attributes.ATTACK_DAMAGE, DefaultMobAttributes.WARBORN_AEGIS_ATTACK_DAMAGE).add(Attributes.ATTACK_SPEED, DefaultMobAttributes.WARBORN_AEGIS_ATTACK_SPEED).add(Attributes.MOVEMENT_SPEED, DefaultMobAttributes.WARBORN_AEGIS_MOVEMENT).add(Attributes.KNOCKBACK_RESISTANCE, DefaultMobAttributes.WARBORN_AEGIS_KNOCKBACK_RESISTANCE).add(Attributes.FOLLOW_RANGE, DefaultMobAttributes.WARBORN_AEGIS_FOLLOW_RANGE);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(2, (Goal)new ComboAttackGoal(this));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 12.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(LANDING_TICK, (Object)20);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        ListTag nexusList = new ListTag();
        for (UUID uuid : this.ignisNexusUUIDs) {
            nexusList.add((Object)NbtUtils.createUUID((UUID)uuid));
        }
        pCompound.put("IgnisNexuses", (Tag)nexusList);
        pCompound.putInt("LandingTick", this.getLandingTick());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        ListTag nexusList = pCompound.getList("IgnisNexuses", 11);
        for (int i = 0; i < nexusList.size(); ++i) {
            this.ignisNexusUUIDs.add(NbtUtils.loadUUID((Tag)nexusList.get(i)));
        }
        this.entityData.set(LANDING_TICK, (Object)pCompound.getInt("LandingTick"));
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        if (this.getAnimationId() == 4 || this.rageTimer > 0 || this.isEnraged && this.getActiveNexusCount() > 0) {
            return false;
        }
        if (this.healthPercentage <= 0.3f && !this.isEnraged) {
            this.activateRageMode();
        }
        if (pSource.is(DamageTypes.WITHER) || pSource.is(DamageTypeTags.IS_FIRE) || pSource.is(DamageTypeTags.IS_FALL) || pSource.is(DamageTypes.MAGIC)) {
            return false;
        }
        int nexusCount = this.getActiveNexusCount();
        float reducedDamage = pAmount * (1.0f - (float)nexusCount * 0.1f);
        return super.hurt(pSource, reducedDamage);
    }

    public boolean doHurtTarget(Entity pEntity) {
        boolean success = super.doHurtTarget(pEntity);
        if (success && pEntity instanceof LivingEntity) {
            this.playAttackSound();
        }
        return success;
    }

    public void die(DamageSource pDamageSource) {
        if (!this.level().isClientSide) {
            for (UUID nexusUUID : new ArrayList<UUID>(this.ignisNexusUUIDs)) {
                Entity nexus = ((ServerLevel)this.level()).getEntity(nexusUUID);
                if (!(nexus instanceof IgnisNexusEntity)) continue;
                nexus.discard();
            }
            this.ignisNexusUUIDs.clear();
        }
        super.die(pDamageSource);
    }

    public boolean isOnFire() {
        return false;
    }

    public boolean canStandOnFluid(FluidState pFluidState) {
        return pFluidState.is(FluidTags.LAVA);
    }

    public boolean isPushedByFluid(FluidType type) {
        return false;
    }

    protected boolean canRide(Entity pVehicle) {
        return false;
    }

    public void handleEntityEvent(byte id) {
        if (id == 67) {
            ParticleGeneratorHelper.generateChargeParticles(this.level(), (Entity)this);
        }
        if (id == 68) {
            ParticleGeneratorHelper.generateFallingParticles(this.level(), (LivingEntity)this);
        }
        if (id == 69) {
            ParticleGeneratorHelper.generateChargeParticles(this.level(), (Entity)this);
        }
        if (id == 70) {
            ParticleGeneratorHelper.generateStompParticles(this.level(), (LivingEntity)this);
        }
        if (id == 71) {
            ParticleGeneratorHelper.generateLandingParticles(this.level(), (LivingEntity)this);
        }
        if (id <= 0) {
            this.setLandingTick(20);
        } else {
            super.handleEntityEvent(id);
        }
    }

    public void tick() {
        super.tick();
        this.healthPercentage = this.getHealth() / this.getMaxHealth();
        if (this.isEnraged && this.rageTimer > 0) {
            --this.rageTimer;
        }
        if (stampedeCooldown > 0) {
            --stampedeCooldown;
        }
        if (meteorCooldown > 0) {
            --meteorCooldown;
        }
        if (kickCooldown > 0) {
            --kickCooldown;
        }
        if (comboCooldown > 0) {
            --comboCooldown;
        }
        if (singleAttackCooldown > 0) {
            --singleAttackCooldown;
        }
        if (infernalThornsCooldown > 0) {
            --infernalThornsCooldown;
        }
        if (this.getLandingTick() > 0 && meteorCooldown == 0) {
            this.setLandingTick((Integer)this.entityData.get(LANDING_TICK) - 1);
        }
    }

    protected void customServerAiStep() {
        this.bossEvent.setProgress(this.healthPercentage);
        this.setAttackTicks(this.getAttackTicks() - 1);
        super.customServerAiStep();
    }

    public void travel(Vec3 pTravelVector) {
        if (this.rageTimer > 0) {
            if (this.getNavigation().getPath() != null) {
                this.getNavigation().stop();
            }
            super.travel(Vec3.ZERO);
            return;
        }
        super.travel(pTravelVector);
    }

    public void startSeenByPlayer(ServerPlayer pServerPlayer) {
        super.startSeenByPlayer(pServerPlayer);
        this.bossEvent.addPlayer(pServerPlayer);
    }

    public void stopSeenByPlayer(ServerPlayer pServerPlayer) {
        super.stopSeenByPlayer(pServerPlayer);
        this.bossEvent.removePlayer(pServerPlayer);
    }

    public boolean removeWhenFarAway(double pDistanceToClosestPlayer) {
        return false;
    }

    public boolean canChangeDimensions(Level pOldLevel, Level pNewLevel) {
        return false;
    }

    protected void tickDeath() {
        ++this.deathTime;
        if (this.deathTime == 23 && !this.level().isClientSide) {
            this.level().broadcastEntityEvent((Entity)this, (byte)60);
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    public void playAmbientSound() {
        this.playSound((SoundEvent)MLSounds.WARBORN_AEGIS_AMBIENT.value());
    }

    protected void playHurtSound(DamageSource pSource) {
        this.playSound((SoundEvent)MLSounds.WARBORN_AEGIS_HURT.value());
    }

    protected void playStepSound(BlockPos pPos, BlockState pState) {
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)MLSounds.WARBORN_AEGIS_DEATH.value();
    }

    protected void playAttackSound() {
        this.playSound((SoundEvent)MLSounds.WARBORN_AEGIS_ATTACK.value());
    }

    @Override
    public void setAnimationId(int id) {
        super.setAnimationId(id);
        this.level().broadcastEntityEvent((Entity)this, (byte)(-id));
    }

    public void setLandingTick(int tick) {
        this.getEntityData().set(LANDING_TICK, (Object)tick);
    }

    public int getLandingTick() {
        return (Integer)this.getEntityData().get(LANDING_TICK);
    }

    private double getCurrentDamage() {
        return this.getAttributeValue(Attributes.ATTACK_DAMAGE);
    }

    private double getCurrentSpeed() {
        return this.getAttributeValue(Attributes.MOVEMENT_SPEED);
    }

    @Override
    PlayState movementPredicate(AnimationState<?> state) {
        if (this.isAlive()) {
            if (this.getAnimationId() == 2 && this.onGround() && this.getLandingTick() > 0) {
                state.setAndContinue(START_JUMP);
            } else if (this.getAnimationId() == 3 && !this.onGround()) {
                state.setAndContinue(METEOR_JUMP);
            } else if (this.getAnimationId() == 4) {
                state.setAndContinue(SHIELD_ATTACK);
            } else if (this.getAnimationId() == 5 && this.onGround()) {
                state.setAndContinue(KICK_ATTACK);
            } else if (this.getAnimationId() == 7) {
                state.setAndContinue(INFERNAL_THORNS);
            } else if (state.isMoving()) {
                state.setAndContinue(WALK);
            } else {
                state.setAndContinue(IDLE);
            }
        } else if (this.isDeadOrDying()) {
            state.setAndContinue(DEATH);
        }
        return PlayState.CONTINUE;
    }

    @Override
    PlayState attackPredicate(AnimationState<?> state) {
        if (this.getAnimationId() == 6) {
            state.getController().forceAnimationReset();
            return state.setAndContinue(ATTACK3);
        }
        return PlayState.STOP;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", 5, this::movementPredicate).setSoundKeyframeHandler(state -> {
            if (state.getKeyframeData().getSound().equals("step") && this.onGround()) {
                this.level().playLocalSound(this.getOnPos(), (SoundEvent)MLSounds.WARBORN_AEGIS_STEP.value(), SoundSource.HOSTILE, 0.4f, 1.0f, false);
            }
        }).triggerableAnim("rageAnim", RAGE));
        controllers.add(new AnimationController((GeoAnimatable)this, "attackController", 5, this::attackPredicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    private void activateRageMode() {
        if (this.isEnraged) {
            return;
        }
        EffectScreenShake.ScreenShake(this.level(), this.position(), 30.0f, 0.25f, 20, 10);
        this.isEnraged = true;
        this.rageTimer = 30;
        this.triggerAnim("controller", "rageAnim");
        AttributeInstance speedAttr = this.getAttribute(Attributes.MOVEMENT_SPEED);
        speedAttr.addTransientModifier(new AttributeModifier(SPEED_MODIFIER_ID, 0.4, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        AttributeInstance damageAttr = this.getAttribute(Attributes.ATTACK_DAMAGE);
        damageAttr.addTransientModifier(new AttributeModifier(DAMAGE_MODIFIER_ID, 0.5, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        this.playSound((SoundEvent)MLSounds.WARBORN_AEGIS_RAGE.value(), 2.0f, 1.0f);
    }

    @Override
    void setConfigAttributes() {
    }

    private void spawnInfernalThorns(double x, double z, double minY, double maxY, float yRot, int warmupDelay) {
        BlockPos blockpos = BlockPos.containing((double)x, (double)maxY, (double)z);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1 = blockpos.below();
            BlockState blockstate = this.level().getBlockState(blockpos1);
            if (!blockstate.isFaceSturdy((BlockGetter)this.level(), blockpos1, Direction.UP)) continue;
            if (!this.level().isEmptyBlock(blockpos) && !(voxelshape = (blockstate1 = this.level().getBlockState(blockpos)).getCollisionShape((BlockGetter)this.level(), blockpos)).isEmpty()) {
                d0 = voxelshape.max(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.below()).getY() >= Mth.floor((double)minY) - 1);
        if (flag) {
            this.level().addFreshEntity((Entity)new MoltenThornEntity(this.level(), x, (double)blockpos.getY() + d0, z, yRot, warmupDelay, 2.0f, (LivingEntity)this));
        }
    }

    private void spawnIgnisNexus() {
        if (!this.level().isClientSide && this.getActiveNexusCount() < 3) {
            BlockPos groundPos = this.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, this.blockPosition());
            IgnisNexusEntity nexus = new IgnisNexusEntity(this.level(), this.getUUID());
            nexus.setPos((double)groundPos.getX() + 0.5, (double)groundPos.getY() + 0.5, (double)groundPos.getZ() + 0.5);
            this.level().addFreshEntity((Entity)nexus);
            this.ignisNexusUUIDs.add(nexus.getUUID());
        }
    }

    public void createShockwave(Level level, BlockPos center, int radius, int duration) {
        if (!level.isClientSide) {
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockState state;
                    BlockPos targetPos = center.offset(x, 0, z);
                    if (!(center.distSqr((Vec3i)targetPos) <= (double)(radius * radius)) || (state = level.getBlockState(targetPos)).isAir() || !(state.getDestroySpeed((BlockGetter)level, targetPos) >= 0.0f) || state.getBlock() == Blocks.BEDROCK) continue;
                    FallingBlockEntity falling = new FallingBlockEntity(level, (double)targetPos.getX() + 0.5, targetPos.getY(), (double)targetPos.getZ() + 0.5, state, duration);
                    double yBoost = 0.6 + level.random.nextDouble() * 0.4;
                    double xBoost = (level.random.nextDouble() - 0.5) * 0.3;
                    double zBoost = (level.random.nextDouble() - 0.5) * 0.3;
                    falling.push(0.0, 0.2 + this.getRandom().nextGaussian() * 0.15, 0.0);
                    level.addFreshEntity((Entity)falling);
                }
            }
        }
    }

    public void onNexusDestroyed(UUID nexusUUID) {
        this.ignisNexusUUIDs.remove(nexusUUID);
    }

    private int getActiveNexusCount() {
        if (this.level().isClientSide) {
            return 0;
        }
        int count = 0;
        Iterator<UUID> iterator = this.ignisNexusUUIDs.iterator();
        while (iterator.hasNext()) {
            UUID uuid = iterator.next();
            Entity entity = ((ServerLevel)this.level()).getEntity(uuid);
            if (entity instanceof IgnisNexusEntity && entity.isAlive()) {
                ++count;
                continue;
            }
            iterator.remove();
        }
        return count;
    }

    public void performComboAttack(double fanAngle, double fanDistance) {
        Vec3 position = this.position();
        Vec3 forward = this.getLookAngle().normalize();
        Vec3 horizontalForward = new Vec3(forward.x, 0.0, forward.z);
        if (horizontalForward.lengthSqr() > 0.0) {
            horizontalForward = horizontalForward.normalize();
        }
        List nearbyEntities = this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(fanDistance), e -> e != this);
        for (LivingEntity target : nearbyEntities) {
            Player player;
            Vec3 toTarget = target.position().subtract(position);
            Vec3 horizontalToTarget = new Vec3(toTarget.x, 0.0, toTarget.z);
            if (horizontalToTarget.lengthSqr() > 0.0) {
                horizontalToTarget = horizontalToTarget.normalize();
            }
            double distanceToTarget = target.position().distanceTo(position);
            double dotProduct = horizontalForward.dot(horizontalToTarget);
            double clampedDotProduct = Mth.clamp((double)dotProduct, (double)-1.0, (double)1.0);
            double angleBetween = Math.acos(clampedDotProduct) * 57.29577951308232;
            if (!(angleBetween <= fanAngle / 2.0) || !(distanceToTarget <= fanDistance) || target instanceof WarbornAegisEntity) continue;
            boolean flag = target.hurt(this.damageSources().mobAttack((LivingEntity)this), (float)this.getAttributeValue(Attributes.ATTACK_DAMAGE));
            if (!(target instanceof Player) || (player = (Player)target).isBlocking()) continue;
            target.invulnerableTime = 0;
            if (!flag) continue;
            this.playSound((SoundEvent)MLSounds.WARBORN_AEGIS_ATTACK.value(), 1.0f, 1.0f + this.getRandom().nextFloat() * 0.1f);
        }
    }

    public static class ComboAttackGoal
    extends Goal {
        private final WarbornAegisEntity mob;
        private LivingEntity target;
        private int comboStage;
        private int attackTick;
        private static final int[] ATTACK_TIMES = new int[]{22, 32};
        private final int ATTACK_DURATION = 40;

        public ComboAttackGoal(WarbornAegisEntity mob) {
            this.mob = mob;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean canUse() {
            this.target = this.mob.getTarget();
            if (this.target == null) return false;
            if (this.mob.getAnimationId() != 0) return false;
            if (!((double)this.mob.distanceTo((Entity)this.target) <= 3.0)) return false;
            if (this.mob.rageTimer != 0) return false;
            float f = this.mob.getRandom().nextFloat();
            float f2 = this.mob.isEnraged ? 0.2f : 0.15f;
            if (!(f <= f2)) return false;
            if (!this.mob.onGround()) return false;
            if (comboCooldown > 0) return false;
            if (!this.mob.isAlive()) return false;
            return true;
        }

        public void start() {
            this.mob.setAnimationId(6);
            this.comboStage = 0;
            this.attackTick = 0;
            this.mob.getLookControl().setLookAt((Entity)this.target);
        }

        public void tick() {
            ++this.attackTick;
            if (this.target == null || !this.target.isAlive()) {
                this.stop();
                return;
            }
            this.mob.getLookControl().setLookAt((Entity)this.target);
            if (this.comboStage < ATTACK_TIMES.length && this.attackTick >= ATTACK_TIMES[this.comboStage]) {
                this.mob.performComboAttack(100.0, 3.5);
                ++this.comboStage;
            }
            if (this.attackTick >= 40) {
                this.stop();
            }
        }

        public void stop() {
            this.mob.setAnimationId(0);
            this.comboStage = 0;
            this.attackTick = 0;
            comboCooldown = DefaultMobAttributes.WARBORN_AEGIS_COMBO_COOLDOWN;
        }

        public boolean canContinueToUse() {
            return this.target != null && this.target.isAlive() && comboCooldown <= 0;
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }
    }

    public static class InfernalThornsAttackGoal
    extends Goal {
        private final WarbornAegisEntity mob;
        private LivingEntity target;
        private int timer;
        private int fangsSpawned;
        private static final int TOTAL_FANGS = 10;
        private static final int SPAWN_INTERVAL = 4;

        public InfernalThornsAttackGoal(WarbornAegisEntity pMob) {
            this.mob = pMob;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean canUse() {
            this.target = this.mob.getTarget();
            if (this.target == null) return false;
            if (this.mob.getAnimationId() != 0) return false;
            if (!(this.mob.distanceTo((Entity)this.target) < 10.0f)) return false;
            if (!(this.mob.getRandom().nextFloat() < 0.35f)) return false;
            if (infernalThornsCooldown > 0) return false;
            if (this.mob.rageTimer > 0) return false;
            if (!this.mob.onGround()) return false;
            if (!this.mob.isAlive()) return false;
            return true;
        }

        public void start() {
            this.mob.setAnimationId(7);
            this.mob.getNavigation().stop();
            this.mob.getLookControl().setLookAt((Entity)this.target);
            this.timer = 0;
            this.fangsSpawned = 0;
        }

        public void stop() {
            this.mob.setAnimationId(0);
            this.mob.getNavigation().recomputePath();
            infernalThornsCooldown = DefaultMobAttributes.WARBORN_AEGIS_KICK_COOLDOWN;
        }

        public void tick() {
            ++this.timer;
            if (this.timer % 4 == 0) {
                this.mob.level().broadcastEntityEvent((Entity)this.mob, (byte)69);
            }
            if (this.fangsSpawned < 10 && this.timer % 4 == 0) {
                this.spawnSingleFang(this.fangsSpawned);
                ++this.fangsSpawned;
            }
            if (this.fangsSpawned >= 10 && this.timer > 50) {
                this.stop();
            }
        }

        private void spawnSingleFang(int index) {
            int standingOnY = Mth.floor((double)this.mob.getY()) - 1;
            double headY = this.mob.getY() + 1.0;
            float yawRadians = (float)Math.toRadians(90.0f + this.mob.getYRot());
            double distance = 1.5 + (double)index * 1.25;
            int delay = index * 2;
            double x = this.mob.getX() + (double)Mth.cos((float)yawRadians) * distance;
            double z = this.mob.getZ() + (double)Mth.sin((float)yawRadians) * distance;
            this.spawnFang(x, headY, z, standingOnY, delay, yawRadians);
        }

        private void spawnFang(double x, double y, double z, int lowestYCheck, int warmupDelayTicks, float yRot) {
            BlockPos blockpos = BlockPos.containing((double)x, (double)y, (double)z);
            boolean foundGround = false;
            double d0 = 0.0;
            do {
                BlockState blockstate1;
                VoxelShape voxelshape;
                BlockPos blockpos1 = blockpos.below();
                BlockState blockstate = this.mob.level().getBlockState(blockpos1);
                if (!blockstate.isFaceSturdy((BlockGetter)this.mob.level(), blockpos1, Direction.UP)) continue;
                if (!this.mob.level().isEmptyBlock(blockpos) && !(voxelshape = (blockstate1 = this.mob.level().getBlockState(blockpos)).getCollisionShape((BlockGetter)this.mob.level(), blockpos)).isEmpty()) {
                    d0 = voxelshape.max(Direction.Axis.Y);
                }
                foundGround = true;
                break;
            } while ((blockpos = blockpos.below()).getY() >= lowestYCheck);
            if (foundGround) {
                MoltenThornEntity thornEntity = new MoltenThornEntity(this.mob.level(), x, (double)blockpos.getY() + d0, z, yRot, warmupDelayTicks, 2.0f, (LivingEntity)this.mob);
                this.mob.level().addFreshEntity((Entity)thornEntity);
            }
        }
    }

    public static class KickAttackGoal
    extends Goal {
        private final WarbornAegisEntity mob;
        LivingEntity target;
        private int kickTimer;

        public KickAttackGoal(WarbornAegisEntity pMob) {
            this.mob = pMob;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean canUse() {
            this.target = this.mob.getTarget();
            if (this.target == null) return false;
            if (this.mob.getAnimationId() != 0) return false;
            if (!((double)this.mob.distanceTo((Entity)this.target) <= 3.5)) return false;
            if (this.mob.rageTimer != 0) return false;
            float f = this.mob.getRandom().nextFloat();
            float f2 = this.mob.isEnraged ? 0.14f : 0.1f;
            if (!(f <= f2)) return false;
            if (kickCooldown > 0) return false;
            if (!this.mob.onGround()) return false;
            return true;
        }

        public void start() {
            this.mob.setAnimationId(5);
            this.mob.getNavigation().stop();
        }

        public void tick() {
            ++this.kickTimer;
            if (this.kickTimer == 10) {
                this.performKick();
            }
            if (this.kickTimer == 15) {
                this.stop();
            }
        }

        private void performKick() {
            float damage = (float)this.mob.getCurrentDamage();
            double deltaX = this.target.getX() - this.mob.getX();
            double deltaZ = this.target.getZ() - this.mob.getZ();
            double distance = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
            this.mob.level().broadcastEntityEvent((Entity)this.mob, (byte)70);
            this.target.knockback(3.0, -deltaX / distance, -deltaZ / distance);
            this.mob.playSound(SoundEvents.ZOMBIE_BREAK_WOODEN_DOOR, 1.0f, 1.0f);
            this.target.hurt(this.mob.damageSources().mobAttack((LivingEntity)this.mob), damage);
            this.mob.getNavigation().recomputePath();
        }

        public void stop() {
            this.mob.setAnimationId(0);
            this.kickTimer = 0;
            kickCooldown = this.mob.isEnraged ? DefaultMobAttributes.WARBORN_AEGIS_RAGE_KICK_COOLDOWN : DefaultMobAttributes.WARBORN_AEGIS_KICK_COOLDOWN;
            this.target = null;
        }

        public boolean canContinueToUse() {
            return this.target != null && this.target.isAlive() && kickCooldown <= 0;
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }
    }

    public static class ShieldStampedeGoal
    extends Goal {
        private final WarbornAegisEntity mob;
        private LivingEntity target;
        private int chargeTime;
        private Vec3 chargeDirection;
        private static final int MAX_CHARGE_TIME = 40;

        public ShieldStampedeGoal(WarbornAegisEntity pMob) {
            this.mob = pMob;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean canUse() {
            this.target = this.mob.getTarget();
            if (this.target == null) return false;
            if (this.mob.getAnimationId() != 0) return false;
            if (stampedeCooldown > 0) return false;
            if (!(this.mob.distanceTo((Entity)this.target) > 4.0f)) return false;
            if (this.mob.rageTimer != 0) return false;
            float f = this.mob.getRandom().nextFloat();
            float f2 = this.mob.isEnraged ? 0.25f : 0.15f;
            if (!(f >= f2)) return false;
            if (!(this.mob.getRandom().nextFloat() <= 0.34f)) return false;
            if (!this.mob.onGround()) return false;
            return true;
        }

        public void start() {
            this.mob.setAnimationId(4);
            this.chargeTime = 0;
            this.chargeDirection = this.target.position().subtract(this.mob.position()).normalize();
            this.mob.getNavigation().stop();
            float targetYaw = (float)(Mth.atan2((double)this.chargeDirection.z, (double)this.chargeDirection.x) * 57.29577951308232) - 90.0f;
            this.mob.getLookControl().setLookAt((Entity)this.target);
            this.mob.setYRot(targetYaw);
            this.mob.yBodyRot = targetYaw;
            this.mob.yHeadRot = targetYaw;
        }

        public void tick() {
            ++this.chargeTime;
            if (this.target != null) {
                Vec3 newMovement = new Vec3(this.chargeDirection.x * this.mob.getCurrentSpeed() * 1.5, this.mob.getDeltaMovement().y, this.chargeDirection.z * this.mob.getCurrentSpeed() * 1.5);
                this.mob.setDeltaMovement(newMovement);
                if (this.chargeTime % 2 == 0) {
                    this.mob.level().broadcastEntityEvent((Entity)this.mob, (byte)69);
                }
                if (this.mob.getBoundingBox().inflate(1.0).intersects(this.target.getBoundingBox())) {
                    this.applyChargeDamage();
                    this.stop();
                }
            }
        }

        private void applyChargeDamage() {
            Player player;
            float damage = (float)this.mob.getCurrentDamage();
            this.target.push(this.chargeDirection.x * 4.0, this.chargeDirection.y * 0.25, this.chargeDirection.z * 4.0);
            this.mob.playSound((SoundEvent)MLSounds.WARBORN_AEGIS_STAMPEDE_HIT.value(), 1.0f, 1.0f);
            LivingEntity livingEntity = this.target;
            if (livingEntity instanceof Player && (player = (Player)livingEntity).isBlocking()) {
                ItemStack shieldItem = player.getUseItem();
                shieldItem.hurtAndBreak(100, (LivingEntity)player, shieldItem.getEquipmentSlot());
                player.getCooldowns().addCooldown(Items.SHIELD, 100);
                return;
            }
            this.target.hurt(this.mob.damageSources().mobAttack((LivingEntity)this.mob), damage);
        }

        public void stop() {
            this.mob.setAnimationId(0);
            stampedeCooldown = this.mob.isEnraged ? DefaultMobAttributes.WARBORN_AEGIS_RAGE_STAMPEDE_COOLDOWN : DefaultMobAttributes.WARBORN_AEGIS_STAMPEDE_COOLDOWN;
            this.chargeTime = 0;
        }

        public boolean canContinueToUse() {
            return this.target != null && this.target.isAlive() && this.chargeTime < 40 && stampedeCooldown <= 0;
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }
    }

    public static class MeteorSlamGoal
    extends Goal {
        private final WarbornAegisEntity mob;
        private LivingEntity target;
        private int attackTick;
        private boolean hasJumped;
        private static final int PRE_JUMP_DURATION = 20;
        private static final int JUMP_DURATION = 40;

        public MeteorSlamGoal(WarbornAegisEntity mob) {
            this.mob = mob;
            this.setFlags(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean canUse() {
            this.target = this.mob.getTarget();
            if (this.target == null) return false;
            if (this.mob.getAnimationId() != 0) return false;
            if (meteorCooldown > 0) return false;
            if (!(this.mob.distanceTo((Entity)this.target) >= 1.0f)) return false;
            if (!(this.mob.distanceTo((Entity)this.target) <= 8.0f)) return false;
            if (this.mob.rageTimer != 0) return false;
            float f = this.mob.getRandom().nextFloat();
            float f2 = this.mob.isEnraged ? 0.35f : 0.26f;
            if (!(f >= f2)) return false;
            if (!(this.mob.getRandom().nextFloat() <= 0.45f)) return false;
            if (!this.canJump()) return false;
            return true;
        }

        private boolean canJump() {
            BlockPos pos = this.mob.blockPosition();
            for (int i = 1; i <= 3; ++i) {
                if (this.mob.level().getBlockState(pos.above(i)).isAir()) continue;
                return false;
            }
            return true;
        }

        public void start() {
            this.mob.setAnimationId(2);
            this.attackTick = 0;
            this.hasJumped = false;
            this.mob.getNavigation().stop();
        }

        public void tick() {
            ++this.attackTick;
            if (this.target != null) {
                this.mob.getLookControl().setLookAt((Entity)this.target);
                if (this.attackTick <= 20) {
                    this.handlePreparation();
                } else if (!this.hasJumped) {
                    this.hasJumped = true;
                    this.executeJump();
                } else if (!this.mob.onGround()) {
                    this.handleAirborne();
                } else if (this.attackTick >= 40) {
                    this.handleLanding();
                    this.stop();
                }
            }
        }

        private void handlePreparation() {
            this.mob.playSound(SoundEvents.CAMPFIRE_CRACKLE, 10.0f, 1.0f);
            if (this.attackTick % 5 == 0) {
                this.mob.level().broadcastEntityEvent((Entity)this.mob, (byte)67);
            }
        }

        private void executeJump() {
            this.mob.setAnimationId(3);
            this.mob.playSound((SoundEvent)MLSounds.WARBORN_AEGIS_JUMP.value());
            Vec3 targetPos = this.target.position();
            Vec3 direction = new Vec3(targetPos.x - this.mob.getX(), 0.0, targetPos.z - this.mob.getZ()).normalize();
            double power = this.mob.isEnraged ? 1.5 : 1.2;
            this.mob.setDeltaMovement(direction.x * power, 1.0 + this.mob.getRandom().nextDouble() * 0.5, direction.z * power);
        }

        private void handleAirborne() {
            if (this.mob.tickCount % 3 == 0) {
                this.mob.level().broadcastEntityEvent((Entity)this.mob, (byte)68);
            }
        }

        private void handleLanding() {
            Player player;
            LivingEntity livingEntity = this.target;
            if (livingEntity instanceof Player && (player = (Player)livingEntity).isBlocking()) {
                player.disableShield();
            }
            this.mob.level().explode((Entity)this.mob, this.mob.getX(), this.mob.getY(), this.mob.getZ(), this.mob.isEnraged ? 6.0f : 4.0f, Level.ExplosionInteraction.NONE);
            this.mob.createShockwave(this.mob.level(), this.mob.blockPosition(), 6, 30);
            this.mob.level().broadcastEntityEvent((Entity)this.mob, (byte)71);
            EffectScreenShake.ScreenShake(this.mob.level(), this.mob.position(), 25.0f, 0.15f, 0, 10);
            this.mob.level().broadcastEntityEvent((Entity)this.mob, (byte)-1);
            this.mob.getNavigation().recomputePath();
        }

        public void stop() {
            this.mob.setAnimationId(0);
            this.hasJumped = false;
            this.attackTick = 0;
            meteorCooldown = this.mob.isEnraged ? DefaultMobAttributes.WARBORN_AEGIS_RAGE_METEOR_COOLDOWN : DefaultMobAttributes.WARBORN_AEGIS_METEOR_COOLDOWN;
            this.target = null;
        }

        public boolean canContinueToUse() {
            return this.target != null && this.target.isAlive() && meteorCooldown <= 0 && this.canJump();
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }
    }
}

