/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity.ai.goal.alp;

import com.ovinter.mythsandlegends.api.util.SendMessageToPlayerHelper;
import com.ovinter.mythsandlegends.datagen.tags.MLItemTag;
import com.ovinter.mythsandlegends.entity.AlpEntity;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.levelgen.Heightmap;

public class StealItemAndFleeFromPlayerGoal
extends Goal {
    private final AlpEntity mob;
    private Player target;
    private int stealCooldown;
    private int fleeTicks;
    private ItemStack stolenItem;
    private BlockPos fleeTargetPos = null;
    private static final double STEAL_DISTANCE = 2.5;
    private static final double MIN_TARGET_DISTANCE = 10.0;
    private static final int STEAL_COOLDOWN = 60;
    private static final int FLEE_DURATION = 200;

    public StealItemAndFleeFromPlayerGoal(AlpEntity pMob) {
        this.mob = pMob;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (this.stealCooldown > 0) {
            --this.stealCooldown;
            return false;
        }
        this.target = this.getNearestPlayer();
        return this.target != null && this.stealCooldown == 0 && this.mob.isAlive() && !this.target.isCreative() && !this.target.isSpectator();
    }

    public boolean canContinueToUse() {
        return this.fleeTicks > 0 || this.target != null && this.target.isAlive() && this.mob.distanceToSqr((Entity)this.target) < 100.0;
    }

    public void start() {
        this.fleeTicks = 0;
        this.stealCooldown = 0;
        this.stolenItem = ItemStack.EMPTY;
        this.mob.setRunning(true);
        this.mob.getNavigation().moveTo((Entity)this.target, 1.2);
    }

    public void tick() {
        if (this.target == null || !this.target.isAlive()) {
            this.stop();
            return;
        }
        if (this.fleeTicks > 0) {
            --this.fleeTicks;
            this.fleeFromTarget();
            return;
        }
        this.mob.getLookControl().setLookAt((Entity)this.target, 30.0f, 30.0f);
        double distanceSqr = this.mob.distanceToSqr((Entity)this.target);
        if (distanceSqr > 100.0) {
            this.mob.getNavigation().moveTo((Entity)this.target, 1.5);
        } else if (distanceSqr <= 6.25) {
            this.tryToStealItemFromPlayer();
        } else {
            this.mob.getNavigation().moveTo((Entity)this.target, 1.5);
        }
    }

    public void stop() {
        this.mob.setRunning(false);
        this.target = null;
        this.fleeTicks = 0;
        this.stealCooldown = 60;
    }

    private void tryToStealItemFromPlayer() {
        if (!this.mob.getMainHandItem().isEmpty()) {
            this.stop();
            return;
        }
        Inventory inventory = this.target.getInventory();
        ArrayList<Integer> nonEmptyslots = new ArrayList<Integer>();
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            if (inventory.getItem(i).isEmpty()) continue;
            nonEmptyslots.add(i);
        }
        if (nonEmptyslots.isEmpty()) {
            return;
        }
        int slot = (Integer)nonEmptyslots.get(this.mob.getRandom().nextInt(nonEmptyslots.size()));
        ItemStack stackInSlot = inventory.getItem(slot);
        if (!stackInSlot.isEmpty() && !stackInSlot.is(MLItemTag.ItemTypes.IGNORED_BY_ALP)) {
            this.stolenItem = stackInSlot.copy();
            this.stolenItem.setCount(1);
            inventory.removeItem(slot, 1);
            this.mob.setItemInHand(InteractionHand.MAIN_HAND, this.stolenItem);
            this.mob.setHasStolen(true);
            SendMessageToPlayerHelper.displayClientMessage((Component)Component.translatable((String)"text.mythsandlegends.alp_steal_item", (Object[])new Object[]{this.stolenItem.getHoverName()}), this.target, true);
            this.fleeTicks = 200;
            this.mob.playSound(SoundEvents.ITEM_PICKUP, 1.0f, 1.0f);
            this.mob.doHurtTarget((Entity)this.target);
        }
    }

    private void fleeFromTarget() {
        double dz;
        if (this.target == null) {
            return;
        }
        if (this.fleeTargetPos != null && this.mob.getNavigation().isInProgress()) {
            return;
        }
        double dx = this.mob.getX() - this.target.getX();
        double dist = Math.sqrt(dx * dx + (dz = this.mob.getZ() - this.target.getZ()) * dz);
        if (dist == 0.0) {
            return;
        }
        double escapeX = this.mob.getX() + (dx /= dist) * 10.0;
        double escapeZ = this.mob.getZ() + (dz /= dist) * 10.0;
        BlockPos rawPos = BlockPos.containing((double)escapeX, (double)this.mob.getY(), (double)escapeZ);
        BlockPos safePos = this.mob.isInWater() || this.mob.isUnderWater() ? this.findNearbyWaterPosition(rawPos, 5) : this.mob.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, rawPos);
        this.fleeTargetPos = safePos;
        this.mob.getNavigation().moveTo((double)safePos.getX(), (double)safePos.getY(), (double)safePos.getZ(), this.mob.isUnderWater() || this.mob.isInWater() ? 2.0 : 1.5);
        if (this.mob.distanceToSqr((Entity)this.target) > 100.0) {
            this.dropStolenItem();
        }
    }

    private BlockPos findNearbyWaterPosition(BlockPos center, int radius) {
        for (int i = 0; i < 8; ++i) {
            BlockPos testPos = center.offset(this.mob.getRandom().nextIntBetweenInclusive(-radius, radius), this.mob.getRandom().nextIntBetweenInclusive(-2, 2), this.mob.getRandom().nextIntBetweenInclusive(-radius, radius));
            if (!this.mob.level().getBlockState(testPos).getFluidState().isSource()) continue;
            return testPos;
        }
        return center;
    }

    private Player getNearestPlayer() {
        List players = this.mob.level().getEntitiesOfClass(Player.class, this.mob.getBoundingBox().inflate(12.0), player -> player.isAlive() && !player.getInventory().isEmpty() && !player.isCreative() && !player.isSpectator());
        if (players.isEmpty()) {
            return null;
        }
        return (Player)players.getFirst();
    }

    private void dropStolenItem() {
        if (!this.stolenItem.isEmpty()) {
            this.mob.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
            this.mob.spawnAtLocation(this.stolenItem.copy());
            this.stolenItem = ItemStack.EMPTY;
        }
        this.mob.setHasStolen(false);
        this.mob.setRunning(false);
        this.fleeTicks = 0;
        this.fleeTargetPos = null;
    }
}

