/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity.ai.goal.amarok;

import com.ovinter.mythsandlegends.api.util.MLEntityHelper;
import com.ovinter.mythsandlegends.config.DefaultMobAttributes;
import com.ovinter.mythsandlegends.entity.AmarokEntity;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;

public class Spin360AttackGoal
extends Goal {
    private final AmarokEntity mob;
    private LivingEntity target;
    private int attackTick;
    private final int ATTACK_DURATION = 35;

    public Spin360AttackGoal(AmarokEntity pMob) {
        this.mob = pMob;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean canUse() {
        this.target = this.mob.getTarget();
        return this.target != null && (double)this.mob.distanceTo((Entity)this.target) <= 3.0 && this.mob.getAnimationId() == 0 && this.mob.onGround() && this.mob.isAlive() && this.mob.spinCooldown == 0;
    }

    public boolean canContinueToUse() {
        return this.mob.onGround() && this.mob.isAlive() && this.mob.spinCooldown == 0;
    }

    public void start() {
        this.mob.setAnimationId(this.mob.SPIN);
        this.mob.getNavigation().stop();
        this.attackTick = 0;
    }

    public void stop() {
        this.target = null;
        this.mob.setAnimationId(0);
        this.attackTick = 0;
        this.mob.spinCooldown = DefaultMobAttributes.AMAROK_SPIN_COOLDOWN;
    }

    public void tick() {
        ++this.attackTick;
        if (this.target == null) {
            return;
        }
        if (this.attackTick >= 35) {
            this.stop();
        }
        if (this.attackTick == 22) {
            MLEntityHelper.damageAndKnockbackNearbyEntities(this.mob, 6.0f, 1.5, 4.0);
        }
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }
}

