/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity.ai.goal.black_charro;

import com.ovinter.mythsandlegends.entity.BlackCharroEntityOld;
import java.util.EnumSet;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class RageGoal
extends Goal {
    private final BlackCharroEntityOld mob;
    private int goalTick;

    public RageGoal(BlackCharroEntityOld pMob) {
        this.mob = pMob;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
    }

    public boolean canUse() {
        return (double)this.mob.healthPercentage > 0.3 && (double)this.mob.healthPercentage <= 0.6 && this.mob.getRegenerationUsesLeft() > 0;
    }

    public void start() {
        this.mob.rage();
        this.mob.setDeltaMovement(Vec3.ZERO);
        this.mob.setIsRage(true);
        this.goalTick = 0;
    }

    public boolean canContinueToUse() {
        return this.goalTick < 130 && this.mob.isAlive();
    }

    public void stop() {
        this.mob.setNoGravity(false);
        this.mob.setIsRage(false);
        this.mob.setDeltaMovement(Vec3.ZERO);
        this.goalTick = 0;
    }

    public void tick() {
        ++this.goalTick;
        System.out.println("Goal Tick: " + this.goalTick);
        this.mob.setDeltaMovement(this.mob.getDeltaMovement().x, 0.0, this.mob.getDeltaMovement().z);
        this.mob.setYya(0.0f);
        this.mob.hasImpulse = true;
        if (this.goalTick == 131) {
            this.stop();
        }
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }
}

