/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity.ai.goal.candle_keeper;

import com.ovinter.mythsandlegends.entity.CandleKeeperEntity;
import com.ovinter.mythsandlegends.registry.MLSounds;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class WaxExplosionGoal
extends Goal {
    private final CandleKeeperEntity mob;
    private LivingEntity target;
    private int attackTick;
    float explosionRadius = 10.0f;

    public WaxExplosionGoal(CandleKeeperEntity pMob) {
        this.mob = pMob;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        this.target = this.mob.getTarget();
        return this.target != null && this.target.isAlive() && this.mob.getAnimationId() == 0 && this.mob.isAlive() && this.mob.explodeCooldown == 0 && this.mob.distanceTo((Entity)this.target) < 5.0f;
    }

    public boolean canContinueToUse() {
        return this.target != null && this.target.isAlive() && this.mob.explodeCooldown == 0;
    }

    public void start() {
        this.mob.setAnimationId(this.mob.AOE);
        this.attackTick = 0;
    }

    public void stop() {
        this.mob.setAnimationId(0);
        this.attackTick = 0;
        this.mob.explodeCooldown = 300;
    }

    public void tick() {
        ++this.attackTick;
        if (this.attackTick == 1) {
            this.mob.playSound((SoundEvent)MLSounds.CANDLE_KEEPER_EXPLOSION.value());
        }
        if (this.attackTick == 20) {
            this.performExplosion();
        }
        if (this.attackTick == 30) {
            this.stop();
        }
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    private void performExplosion() {
        Level level = this.mob.level();
        if (level.isClientSide) {
            return;
        }
        List nearby = level.getEntitiesOfClass(LivingEntity.class, this.mob.getBoundingBox().inflate((double)this.explosionRadius));
        for (LivingEntity e : nearby) {
            if (e == this.mob) continue;
            e.hurt(level.damageSources().mobAttack((LivingEntity)this.mob), 10.0f);
            Vec3 knockback = e.position().subtract(this.mob.position()).normalize().scale(0.8);
            e.push(knockback.x, 0.3, knockback.z);
        }
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            this.createParticleSphere(server, this.mob.position(), this.explosionRadius, 200);
        }
    }

    private void createParticleSphere(ServerLevel level, Vec3 center, double radius, int points) {
        for (int i = 0; i < points; ++i) {
            double theta = Math.random() * Math.PI * 2.0;
            double phi = Math.random() * Math.PI;
            double x = center.x + radius * Math.sin(phi) * Math.cos(theta);
            double y = center.y + radius * Math.cos(phi);
            double z = center.z + radius * Math.sin(phi) * Math.sin(theta);
            level.sendParticles((ParticleOptions)ParticleTypes.FLAME, x, y, z, 35, 0.0, 0.0, 0.0, 0.0);
        }
    }
}

