/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity.ai.goal.gargoyle;

import com.ovinter.mythsandlegends.config.DefaultMobAttributes;
import com.ovinter.mythsandlegends.entity.GargoyleEntity;
import com.ovinter.mythsandlegends.entity.projectile.MoltenRockEntity;
import com.ovinter.mythsandlegends.registry.MLEntities;
import com.ovinter.mythsandlegends.registry.MLSounds;
import java.util.EnumSet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ShootMoltenBallGoal
extends Goal {
    private final GargoyleEntity mob;
    private LivingEntity target;
    private int attackTick;
    private int ATTACK_DURATION = 25;

    public ShootMoltenBallGoal(GargoyleEntity pMob) {
        this.mob = pMob;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        this.target = this.mob.getTarget();
        return this.target != null && this.mob.getAnimationId() == 0 && this.target.isAlive() && this.mob.rangedCooldown == 0 && this.mob.getVariant() == 1 && this.mob.distanceTo((Entity)this.target) < 20.0f;
    }

    public boolean canContinueToUse() {
        return this.target != null && this.target.isAlive() && this.mob.rangedCooldown == 0;
    }

    public void start() {
        this.mob.setAnimationId(2);
        this.attackTick = 0;
    }

    public void stop() {
        this.mob.setAnimationId(0);
        this.mob.rangedCooldown = DefaultMobAttributes.GARGOYLE_ABILITY_COOLDOWN;
        this.attackTick = 0;
        this.target = null;
    }

    public void tick() {
        ++this.attackTick;
        if (this.target == null || !this.target.isAlive()) {
            return;
        }
        this.mob.getLookControl().setLookAt((Entity)this.target, 30.0f, 30.0f);
        if (this.attackTick == 15) {
            this.performRangedAttack();
        }
        if (this.attackTick == this.ATTACK_DURATION) {
            this.stop();
        }
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    private void performRangedAttack() {
        Level level = this.mob.level();
        Vec3 targetPos = this.target.position();
        int projectiles = 8;
        for (int i = 0; i < projectiles; ++i) {
            MoltenRockEntity projectile = new MoltenRockEntity(MLEntities.MOLTEN_BALL.get(), level, (LivingEntity)this.mob);
            projectile.setPos(this.mob.getX(), this.mob.getEyeY() + 0.3, this.mob.getZ());
            double targetX = targetPos.x + (i == 0 ? 0.0 : this.mob.getRandom().triangle(0.0, 4.0));
            double targetY = targetPos.y + this.mob.getRandom().triangle(0.0, 2.0);
            double targetZ = targetPos.z + (i == 0 ? 0.0 : this.mob.getRandom().triangle(0.0, 4.0));
            Vec3 dir = new Vec3(targetX - this.mob.getX(), targetY - this.mob.getEyeY() + 0.3, targetZ - this.mob.getZ()).normalize();
            float velocity = 0.8f + this.mob.getRandom().nextFloat() * 0.2f;
            projectile.shoot(dir.x, dir.y + 0.1, dir.z, velocity, 4.0f);
            level.addFreshEntity((Entity)projectile);
            this.mob.playSound((SoundEvent)MLSounds.IMP_SHOOT.value(), 1.0f, 1.0f + this.mob.getRandom().nextFloat() * 0.3f);
        }
    }
}

