/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity.projectile;

import com.ovinter.mythsandlegends.registry.MLEntities;
import com.ovinter.mythsandlegends.registry.MLSounds;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.fluids.FluidType;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ShadowHorseEntity
extends Entity
implements GeoEntity {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final RawAnimation RUN = RawAnimation.begin().thenLoop("RUN");
    private UUID ownerUUID;
    private final int LIFESPAN_TICKS = 150;
    private int lifeTicks;

    public ShadowHorseEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public ShadowHorseEntity(Level world, LivingEntity shooter) {
        this(MLEntities.SHADOW_HORSE.get(), world);
        this.setPos(shooter.getX(), shooter.getEyeY(), shooter.getZ());
        this.setOwner(shooter);
        this.noPhysics = true;
        this.lifeTicks = 150;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        if (compound.hasUUID("Owner")) {
            this.ownerUUID = compound.getUUID("Owner");
        }
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        if (this.ownerUUID != null) {
            compound.putUUID("Owner", this.ownerUUID);
        }
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            this.setDeltaMovement(this.getDeltaMovement());
            this.move(MoverType.SELF, this.getDeltaMovement());
            AABB hitbox = this.getBoundingBox().inflate(0.3);
            for (Player player : this.level().getEntitiesOfClass(Player.class, hitbox)) {
                if (player.equals((Object)this.ownerUUID)) continue;
                player.hurt(this.damageSources().magic(), 4.0f);
                this.spawnExplosionEffect();
                this.discard();
                return;
            }
            if (--this.lifeTicks <= 0) {
                this.spawnExplosionEffect();
                this.discard();
            }
        }
    }

    public boolean isOnFire() {
        return false;
    }

    public boolean isPushable() {
        return false;
    }

    public boolean isPushedByFluid(FluidType type) {
        return false;
    }

    public void setOwner(LivingEntity pOwner) {
        this.ownerUUID = pOwner.getUUID();
    }

    public LivingEntity getOwner() {
        if (this.ownerUUID == null) {
            return null;
        }
        Entity entity = ((ServerLevel)this.level()).getEntity(this.ownerUUID);
        return entity instanceof LivingEntity ? (LivingEntity)entity : null;
    }

    PlayState predicate(AnimationState<?> state) {
        return state.setAndContinue(this.RUN);
    }

    private void spawnExplosionEffect() {
        ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.SMOKE, this.getX(), this.getY() + 1.0, this.getZ(), 15, 0.4, 0.4, 0.4, 0.01);
        this.playSound((SoundEvent)MLSounds.UMBRAL_DOOM_ORB_EXPLOSION.value(), 5.0f, 1.0f);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, this::predicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }
}

