/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.event;

import com.ovinter.mythsandlegends.api.util.SendMessageToPlayerHelper;
import com.ovinter.mythsandlegends.datagen.tags.MLEntityTypeTag;
import com.ovinter.mythsandlegends.entity.BlackCharroEntityOld;
import com.ovinter.mythsandlegends.entity.CandleKeeperEntity;
import com.ovinter.mythsandlegends.entity.GargoyleEntity;
import com.ovinter.mythsandlegends.entity.ai.goal.gargoyle.GargoyleFollowOwnerGoal;
import com.ovinter.mythsandlegends.entity.ai.goal.gargoyle.GargoyleOwnerHurtByTargetGoal;
import com.ovinter.mythsandlegends.entity.ai.goal.gargoyle.GargoyleOwnerHurtTargetGoal;
import com.ovinter.mythsandlegends.entity.ai.goal.gargoyle.ShootMoltenBallGoal;
import com.ovinter.mythsandlegends.registry.MLEffects;
import com.ovinter.mythsandlegends.registry.MLItems;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingChangeTargetEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingShieldBlockEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import top.theillusivec4.curios.api.CuriosApi;

@EventBusSubscriber(modid="mythsandlegends", bus=EventBusSubscriber.Bus.GAME)
public class EventBusServerEvents {
    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            DamageSource damageSource = event.getSource();
            if (damageSource.getEntity() instanceof BlackCharroEntityOld) {
                SendMessageToPlayerHelper.sendRandomMessage("kills_player", player, 5);
            }
        }
    }

    @SubscribeEvent
    public static void onAttackEntity(AttackEntityEvent event) {
        Player attacker = event.getEntity();
        if (attacker.hasEffect(MLEffects.PETRIFIED)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onBlockDamage(LivingShieldBlockEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Entity attacker;
            Player player = (Player)livingEntity;
            if (!player.isBlocking()) {
                return;
            }
            ItemStack shieldItem = player.getUseItem();
            if (shieldItem.getItem() != MLItems.MALEDICTUM_SHIELD.get()) {
                return;
            }
            if (player.getRandom().nextFloat() < 0.25f && (attacker = event.getDamageSource().getEntity()) instanceof LivingEntity) {
                LivingEntity livingAttacker = (LivingEntity)attacker;
                livingAttacker.setRemainingFireTicks(60);
            }
        }
    }

    @SubscribeEvent
    public static void onSetTarget(LivingChangeTargetEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.hasEffect(MLEffects.PETRIFIED)) {
            event.setNewAboutToBeSetTarget(null);
        }
    }

    @SubscribeEvent
    public static void onEntitySpawn(EntityJoinLevelEvent event) {
        GargoyleEntity gargoyle;
        Entity entity = event.getEntity();
        Level level = entity.level();
        if (EventBusServerEvents.isFullMoon(level) && entity instanceof CandleKeeperEntity) {
            CandleKeeperEntity candleKeeper = (CandleKeeperEntity)entity;
            return;
        }
        if (entity instanceof GargoyleEntity && (gargoyle = (GargoyleEntity)entity).getOwnerUUID() != null) {
            gargoyle.goalSelector.addGoal(3, (Goal)new GargoyleFollowOwnerGoal(gargoyle, 1.2, 10.0f, 3.0f));
            gargoyle.goalSelector.addGoal(4, (Goal)new ShootMoltenBallGoal(gargoyle));
            gargoyle.targetSelector.addGoal(0, (Goal)new GargoyleOwnerHurtByTargetGoal(gargoyle));
            gargoyle.targetSelector.addGoal(1, (Goal)new GargoyleOwnerHurtTargetGoal(gargoyle));
        }
    }

    @SubscribeEvent
    public static void onPlayerHurt(LivingIncomingDamageEvent event) {
        boolean isNetherVariant;
        DamageSource source = event.getSource();
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        Entity entity = source.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)entity;
        boolean isNetherMob = attacker.getType().is(MLEntityTypeTag.EntityTypes.NETHER_MOBS);
        boolean isPossessedArmorMob = attacker.getType().is(MLEntityTypeTag.EntityTypes.POSSESSED_ARMORS);
        boolean bl = isNetherVariant = attacker.getPersistentData().getInt("Variant") == 1;
        if (!(isNetherMob || isNetherVariant || isPossessedArmorMob)) {
            return;
        }
        boolean hasRelic = false;
        float reducedDamage = 0.0f;
        if (CuriosApi.getCuriosInventory((LivingEntity)player).flatMap(curiosInventory -> curiosInventory.findFirstCurio((Item)MLItems.ANTIQUE_EMBLEM.get())).isPresent()) {
            hasRelic = true;
            reducedDamage = event.getAmount() * 0.75f;
        } else if (CuriosApi.getCuriosInventory((LivingEntity)player).flatMap(curiosInventory -> curiosInventory.findFirstCurio((Item)MLItems.SVAROGS_RING.get())).isPresent()) {
            hasRelic = true;
            reducedDamage = event.getAmount() * 0.8f;
        } else {
            for (ItemStack stack : player.getInventory().items) {
                if (!EventBusServerEvents.getRelicItem(stack.getItem())) continue;
                hasRelic = true;
                break;
            }
        }
        if (hasRelic) {
            event.setAmount(reducedDamage);
        }
    }

    @SubscribeEvent
    public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (CuriosApi.getCuriosInventory((LivingEntity)player).flatMap(curiosInventory -> curiosInventory.findFirstCurio((Item)MLItems.SVAROGS_RING.get())).isPresent() && player.level().dimension() == Level.NETHER) {
            SendMessageToPlayerHelper.displayClientMessage((Component)Component.literal((String)"The Abyss answers your call...").withStyle(ChatFormatting.DARK_PURPLE), player, true);
        }
    }

    private static boolean getRelicItem(Item pItem) {
        return pItem == MLItems.ANTIQUE_EMBLEM.get() || pItem == MLItems.SVAROGS_RING.get() || pItem == MLItems.FIRE_HEART.get();
    }

    private static boolean isFullMoon(Level pLevel) {
        return pLevel.getMoonPhase() == 0;
    }
}

