/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.item.custom;

import com.ovinter.mythsandlegends.api.util.ParticleGeneratorHelper;
import com.ovinter.mythsandlegends.client.render.item.GargoyleAxeRenderer;
import com.ovinter.mythsandlegends.registry.MLSounds;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class GargoyleAxeItem
extends AxeItem
implements GeoItem,
GeoAnimatable {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    RawAnimation IDLE = RawAnimation.begin().thenLoop("IDLE");

    public GargoyleAxeItem(Tier tier, Item.Properties properties) {
        super(tier, properties);
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(this){
            private GargoyleAxeRenderer renderer;

            public BlockEntityWithoutLevelRenderer getGeoItemRenderer() {
                if (this.renderer == null) {
                    this.renderer = new GargoyleAxeRenderer();
                }
                return this.renderer;
            }
        });
    }

    public boolean hurtEnemy(ItemStack pStack, LivingEntity pTarget, LivingEntity pAttacker) {
        if (!pTarget.level().isClientSide()) {
            pTarget.knockback(1.0, pAttacker.getX() - pTarget.getX(), pAttacker.getZ() - pTarget.getZ());
        }
        return true;
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        if (pPlayer.onGround()) {
            pPlayer.getCooldowns().addCooldown((Item)this, 100);
            this.performShockwaveAttack(pLevel, pPlayer);
        }
        return super.use(pLevel, pPlayer, pUsedHand);
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
        if (Screen.hasShiftDown()) {
            pTooltipComponents.add((Component)Component.translatable((String)"tooltip.mythsandlegends.gargoyle_axe_tooltip_shift_down"));
            pTooltipComponents.add((Component)Component.translatable((String)"tooltip.mythsandlegends.gargoyle_axe_tooltip_shift_down2"));
            pTooltipComponents.add((Component)Component.translatable((String)"tooltip.mythsandlegends.gargoyle_axe_tooltip_shift_down3"));
        } else {
            pTooltipComponents.add((Component)Component.translatable((String)"tooltip.mythsandlegends.gargoyle_axe"));
            pTooltipComponents.add((Component)Component.translatable((String)"tooltip.mythsandlegends.more_info"));
        }
        super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
    }

    private void performShockwaveAttack(Level level, Player player) {
        level.playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)MLSounds.SHOCKWAVE.value(), SoundSource.PLAYERS, 1.5f, 1.0f);
        List entities = level.getEntities((Entity)player, player.getBoundingBox().inflate(3.0));
        for (Entity entity : entities) {
            if (!(entity instanceof LivingEntity)) continue;
            double deltaX = entity.getX() - player.getX();
            double deltaZ = entity.getZ() - player.getZ();
            double distance = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
            entity.hurt(level.damageSources().mobAttack((LivingEntity)player), 5.0f);
            ((LivingEntity)entity).knockback(3.0, -deltaX / distance, -deltaZ / distance);
        }
        if (level.isClientSide) {
            ParticleGeneratorHelper.generateShockwaveParticles(level, (LivingEntity)player, 3.0);
        }
    }

    PlayState predicate(AnimationState<?> state) {
        return state.setAndContinue(this.IDLE);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "predicateController", 0, this::predicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    public double getTick(Object object) {
        return 0.0;
    }
}

