/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.item.custom.curio;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class NecklaceOfTorkngarsukItem
extends Item
implements ICurioItem {
    private static final double DAMAGE_BONUS = 0.3;
    private static final ResourceLocation BOOST_ID = ResourceLocation.fromNamespaceAndPath((String)"mythsandlegends", (String)"damage_boost");

    public NecklaceOfTorkngarsukItem(Item.Properties properties) {
        super(properties);
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        LivingEntity wearer = slotContext.entity();
        if (!wearer.level().isClientSide) {
            this.applyDamageBoost(wearer, true);
        }
    }

    public void onEquipFromUse(SlotContext slotContext, ItemStack stack) {
        LivingEntity wearer = slotContext.entity();
        if (!wearer.level().isClientSide) {
            this.applyDamageBoost(wearer, true);
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        LivingEntity wearer = slotContext.entity();
        if (!wearer.level().isClientSide) {
            this.applyDamageBoost(wearer, false);
        }
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
        pTooltipComponents.add((Component)Component.translatable((String)"tooltip.mythsandlegends.necklace_of_torngarsuk"));
        pTooltipComponents.add((Component)Component.translatable((String)"tooltip.mythsandlegends.necklace_of_torngarsuk2"));
        super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
    }

    private void applyDamageBoost(LivingEntity pLivingEntity, boolean pApply) {
        AttributeInstance attribute = pLivingEntity.getAttribute(Attributes.ATTACK_DAMAGE);
        if (attribute == null) {
            return;
        }
        AttributeModifier modifier = new AttributeModifier(BOOST_ID, 0.3, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        attribute.removeModifier(BOOST_ID);
        if (pApply) {
            attribute.addTransientModifier(modifier);
        }
    }
}

