/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.item.custom.curio;

import com.ovinter.mythsandlegends.api.util.SendMessageToPlayerHelper;
import com.ovinter.mythsandlegends.registry.MLSounds;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class SvarogsRingItem
extends Item
implements ICurioItem {
    public SvarogsRingItem(Item.Properties properties) {
        super(properties.fireResistant().rarity(Rarity.EPIC).stacksTo(1));
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.mythsandlegends.svarogs_ring"));
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.mythsandlegends.svarogs_ring2"));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (!stack.isEmpty() && player.level().dimension() == Level.NETHER) {
            SendMessageToPlayerHelper.displayClientMessage((Component)Component.literal((String)"The Abyss answers your call...").withStyle(ChatFormatting.DARK_PURPLE), player, true);
        }
        super.onEquip(slotContext, prevStack, stack);
    }

    public boolean isFoil(ItemStack stack) {
        return true;
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    @NotNull
    public ICurio.SoundInfo getEquipSound(SlotContext slotContext, ItemStack stack) {
        return new ICurio.SoundInfo((SoundEvent)MLSounds.SVAROGS_RING.value(), 1.0f, 1.0f);
    }
}

