/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.block;

import com.mojang.serialization.MapCodec;
import com.ovinter.mythsandlegends.api.util.SendMessageToPlayer;
import com.ovinter.mythsandlegends.block.entity.AltarOfTheDeadBlockEntity;
import com.ovinter.mythsandlegends.entity.BlackCharroEntityOld;
import com.ovinter.mythsandlegends.registry.MLEntities;
import com.ovinter.mythsandlegends.registry.MLItems;
import com.ovinter.mythsandlegends.registry.MLSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class AltarOfTheDeadBlock
extends BaseEntityBlock
implements EntityBlock {
    private static final VoxelShape BASE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)15.0);
    private static final VoxelShape MIDDLE = Block.box((double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0);
    private static final VoxelShape TOP = Block.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0);
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{MIDDLE, TOP});
    public static final EnumProperty<Direction> FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public AltarOfTheDeadBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        FluidState fluidState = pContext.getLevel().getFluidState(pContext.getClickedPos());
        boolean isWater = fluidState.getType() == Fluids.WATER;
        return (BlockState)((BlockState)this.defaultBlockState().setValue(FACING, (Comparable)pContext.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isWater));
    }

    protected FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHitResult) {
        boolean isServer;
        ItemStack stack = pPlayer.getItemInHand(pHand);
        boolean isNight = pLevel.isNight();
        boolean hasAmulet = stack.is((Item)MLItems.SOULBINDER_AMULET.get()) || pPlayer.getOffhandItem().is((Item)MLItems.SOULBINDER_AMULET.get());
        boolean bl = isServer = !pLevel.isClientSide;
        if (!isNight && isServer) {
            SendMessageToPlayer.sendMessage((Component)Component.translatable((String)"text.mythsandlegends.black_charro_day_fail"), pPlayer);
            return ItemInteractionResult.FAIL;
        }
        if (!hasAmulet && isServer) {
            SendMessageToPlayer.sendMessage((Component)Component.translatable((String)"text.mythsandlegends.black_charro_fail"), pPlayer);
            return ItemInteractionResult.FAIL;
        }
        if (isNight && hasAmulet && isServer) {
            pPlayer.swing(pHand.equals((Object)InteractionHand.MAIN_HAND) ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND, true);
            if (stack.is((Item)MLItems.SOULBINDER_AMULET.get())) {
                stack.shrink(1);
            } else if (pPlayer.getOffhandItem().is((Item)MLItems.SOULBINDER_AMULET.get())) {
                pPlayer.getOffhandItem().shrink(1);
            }
            pLevel.playSound(null, pPos, (SoundEvent)MLSounds.BLACK_CHARRO_RITUAL.value(), SoundSource.BLOCKS, 1.0f, 1.0f);
            LightningBolt entityToSpawn = new LightningBolt(EntityType.LIGHTNING_BOLT, pLevel);
            entityToSpawn.moveTo(Vec3.atBottomCenterOf((Vec3i)pPos));
            entityToSpawn.setVisualOnly(true);
            SendMessageToPlayer.sendMessage((Component)Component.translatable((String)"text.mythsandlegends.black_charro_awakening"), pPlayer);
            pLevel.destroyBlock(pPos, false);
            BlackCharroEntityOld blackCharro = new BlackCharroEntityOld(MLEntities.BLACK_CHARRO.get(), pLevel);
            blackCharro.setPos((double)pPos.getX() + 0.5, pPos.getY(), (double)pPos.getZ() + 0.5);
            pLevel.addFreshEntity((Entity)blackCharro);
        }
        return ItemInteractionResult.SUCCESS;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return null;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new AltarOfTheDeadBlockEntity(pPos, pState);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{WATERLOGGED});
        pBuilder.add(new Property[]{FACING});
    }

    protected BlockState rotate(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.setValue(FACING, (Comparable)pRotation.rotate((Direction)pState.getValue(FACING)));
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    protected VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public void animateTick(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        pLevel.addParticle((ParticleOptions)ParticleTypes.ENCHANT, (double)pPos.getX() + pRandom.nextDouble(), (double)pPos.getY() + 0.5, (double)pPos.getZ() + pRandom.nextDouble(), 0.0, 0.0, 0.0);
    }
}

