/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity;

import com.ovinter.mythsandlegends.Config;
import com.ovinter.mythsandlegends.api.util.ParticleGeneratorHelper;
import com.ovinter.mythsandlegends.config.DefaultMobAttributes;
import com.ovinter.mythsandlegends.entity.ImpCloneEntity;
import com.ovinter.mythsandlegends.entity.MLEntity;
import com.ovinter.mythsandlegends.entity.ai.navigation.FlyingNavigation;
import com.ovinter.mythsandlegends.registry.MLEntities;
import com.ovinter.mythsandlegends.registry.MLSounds;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ImpEntity
extends MLEntity {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("IDLE");
    private static final RawAnimation FLY = RawAnimation.begin().thenLoop("FLY");
    private static final RawAnimation ATTACK = RawAnimation.begin().thenPlay("ATTACK");
    private static final RawAnimation SHOOTING_ATTACK = RawAnimation.begin().thenPlay("RANGE_ATTACK");
    private static final EntityDataAccessor<Boolean> DATA_CLONE = SynchedEntityData.defineId(ImpEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    @Nullable
    private BlockPos boundOrigin;
    public int shootCooldown = DefaultMobAttributes.IMP_SHOOT_ATTACK_COOLDOWN;
    public static int SHOOT = 2;

    public ImpEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.moveControl = new ImpMoveControl(this);
        this.navigation = new FlyingNavigation((Mob)this, this.level());
        this.xpReward = 4;
        this.setNoGravity(true);
    }

    public ResourceLocation getModelResource() {
        return ResourceLocation.fromNamespaceAndPath((String)"mythsandlegends", (String)"geo/entity/imp.geo.json");
    }

    public ResourceLocation getTextureResource() {
        return ResourceLocation.fromNamespaceAndPath((String)"mythsandlegends", (String)"textures/entity/imp.png");
    }

    public ResourceLocation getAnimationResource() {
        return ResourceLocation.fromNamespaceAndPath((String)"mythsandlegends", (String)"animations/entity/imp.animation.json");
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, DefaultMobAttributes.IMP_HEALTH).add(Attributes.FOLLOW_RANGE, DefaultMobAttributes.IMP_FOLLOW_RANGE).add(Attributes.FLYING_SPEED, DefaultMobAttributes.IMP_FLYING_SPEED).add(Attributes.ATTACK_DAMAGE, DefaultMobAttributes.IMP_DAMAGE);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(3, (Goal)new FireballAttackGoal(this));
        this.goalSelector.addGoal(4, (Goal)new ImpAttackGoal(this));
        this.goalSelector.addGoal(4, (Goal)new ImpRandomMoveGoal(this));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(DATA_CLONE, (Object)false);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putBoolean("IsClone", this.isClone());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.setClone(pCompound.getBoolean("IsClone"));
    }

    public void tick() {
        super.tick();
        if (this.shootCooldown > 0) {
            --this.shootCooldown;
        }
        this.performCollisionAvoidance();
        if (this.level().isClientSide() && this.tickCount % 5 == 0) {
            ParticleGeneratorHelper.generateCircleParticles((LivingEntity)this, 5, ParticleTypes.SMALL_FLAME, false, false, 0.0, 0.0, 0.0, 0.2, 1.0);
        }
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pSpawnType, @javax.annotation.Nullable SpawnGroupData pSpawnGroupData) {
        RandomSource randomsource = pLevel.getRandom();
        this.populateDefaultEquipmentSlots(randomsource, pDifficulty);
        this.populateDefaultEquipmentEnchantments(pLevel, randomsource, pDifficulty);
        this.setConfigAttributes();
        return super.finalizeSpawn(pLevel, pDifficulty, pSpawnType, pSpawnGroupData);
    }

    public boolean isInvulnerableTo(DamageSource source) {
        return source.is(DamageTypeTags.IS_FIRE) || source.is(DamageTypes.WITHER) || source.is(DamageTypeTags.IS_FALL);
    }

    public void die(DamageSource pDamageSource) {
        if (!this.isClone()) {
            for (int i = 0; i < 2; ++i) {
                ImpCloneEntity clone = (ImpCloneEntity)MLEntities.IMP_CLONE.get().create(this.level());
                if (clone == null) continue;
                clone.setPos(this.getX() + 2.0, this.getY(), this.getZ());
                for (int j = 0; j < 20; ++j) {
                    this.level().addParticle((ParticleOptions)ParticleTypes.POOF, clone.getX(), clone.getY(), clone.getZ(), 0.0, 0.0, 0.0);
                }
                clone.setClone(true);
                this.level().addFreshEntity((Entity)clone);
            }
        }
        super.die(pDamageSource);
    }

    public boolean isOnFire() {
        return false;
    }

    public boolean causeFallDamage(float fallDistance, float multiplier, DamageSource source) {
        return false;
    }

    public boolean isClone() {
        return (Boolean)this.entityData.get(DATA_CLONE);
    }

    public void setClone(boolean pClone) {
        this.entityData.set(DATA_CLONE, (Object)pClone);
    }

    protected void populateDefaultEquipmentSlots(RandomSource pRandom, DifficultyInstance pDifficulty) {
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.TRIDENT));
        this.setDropChance(EquipmentSlot.MAINHAND, 0.0f);
    }

    protected SoundEvent getAmbientSound() {
        this.playSound(SoundEvents.PARROT_IMITATE_VEX, 1.0f, 0.5f);
        return null;
    }

    protected SoundEvent getDeathSound() {
        this.playSound(SoundEvents.VEX_DEATH, 1.0f, 0.5f);
        return null;
    }

    protected SoundEvent getHurtSound(DamageSource pDamageSource) {
        this.playSound(SoundEvents.VEX_HURT, 1.0f, 0.5f);
        return null;
    }

    @Nullable
    public BlockPos getBoundOrigin() {
        return this.boundOrigin;
    }

    void castFireball(LivingEntity pTarget) {
        if (this.level().isClientSide) {
            return;
        }
        double dirX = pTarget.getX() - this.getX();
        double dirY = pTarget.getY(0.5) - this.getY(0.5);
        double dirZ = pTarget.getZ() - this.getZ();
        Vec3 pos = new Vec3(dirX, dirY, dirZ);
        SmallFireball fireball = new SmallFireball(this.level(), (LivingEntity)this, pos);
        fireball.setPos(this.getX(), this.getY(0.5), this.getZ());
        this.level().addFreshEntity((Entity)fireball);
        this.playSound((SoundEvent)MLSounds.IMP_SHOOT.value(), 2.0f, 1.0f);
    }

    @Override
    PlayState movementPredicate(AnimationState<?> state) {
        return state.isMoving() ? state.setAndContinue(FLY) : state.setAndContinue(IDLE);
    }

    @Override
    PlayState attackPredicate(AnimationState<?> state) {
        if (this.getAnimationId() == SHOOT) {
            return state.setAndContinue(SHOOTING_ATTACK);
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "movementController", 5, this::movementPredicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "attackController", 5, this::attackPredicate).triggerableAnim("attack", ATTACK).triggerableAnim("ranged", SHOOTING_ATTACK));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    @Override
    void setConfigAttributes() {
        if (this.isClone()) {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(((Double)Config.IMP_CLONE_HEALTH.get()).doubleValue());
            this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(((Double)Config.IMP_CLONE_DAMAGE.get()).doubleValue());
            this.getAttribute(Attributes.FLYING_SPEED).setBaseValue(((Double)Config.IMP_CLONE_FLYING_SPEED.get()).doubleValue());
            this.setHealth((float)Config.IMP_CLONE_HEALTH.getAsDouble());
        } else {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(((Double)Config.IMP_HEALTH.get()).doubleValue());
            this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(((Double)Config.IMP_DAMAGE.get()).doubleValue());
            this.getAttribute(Attributes.FLYING_SPEED).setBaseValue(((Double)Config.IMP_FLYING_SPEED.get()).doubleValue());
            this.setHealth((float)Config.IMP_HEALTH.getAsDouble());
        }
    }

    private void performCollisionAvoidance() {
        this.avoidWalls();
        this.preventVerticalStuck();
        this.applyAntiStuckForce();
        this.smoothMovement();
    }

    private void avoidWalls() {
        Vec3 lookAhead = this.position().add(this.getLookAngle().scale(1.5));
        if (this.level().getBlockState(new BlockPos((int)lookAhead.x, (int)lookAhead.y, (int)lookAhead.z)).isSolid()) {
            this.setYRot(this.getYRot() + (float)(this.random.nextBoolean() ? 45 : -45));
        }
    }

    private void applyAntiStuckForce() {
        AABB bb = this.getBoundingBox();
        int checkRadius = 2;
        for (int x = -checkRadius; x <= checkRadius; ++x) {
            for (int y = -checkRadius; y <= checkRadius; ++y) {
                for (int z = -checkRadius; z <= checkRadius; ++z) {
                    BlockPos pos = this.blockPosition().offset(x, y, z);
                    if (!this.level().getBlockState(pos).isSolid() || !bb.intersects((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)(pos.getX() + 1), (double)(pos.getY() + 1), (double)(pos.getZ() + 1))) continue;
                    Vec3 escapeDir = this.position().subtract(Vec3.atCenterOf((Vec3i)pos)).normalize();
                    this.setDeltaMovement(this.getDeltaMovement().add(escapeDir.scale(0.1)));
                }
            }
        }
    }

    private void preventVerticalStuck() {
        BlockPos below = this.blockPosition().below();
        if (this.level().getBlockState(below).isSolid() && this.getY() - (double)below.getY() < 1.5) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.05, 0.0));
        }
    }

    private void smoothMovement() {
        Vec3 motion = this.getDeltaMovement();
        double speed = motion.length();
        if (speed > 0.1) {
            this.setDeltaMovement(motion.scale(0.97));
        }
        if (!this.isControlledByLocalInstance()) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.9, 0.9, 0.9));
        }
    }

    public static class ImpMoveControl
    extends MoveControl {
        private final ImpEntity mob;

        public ImpMoveControl(ImpEntity pMob) {
            super((Mob)pMob);
            this.mob = pMob;
        }

        public void tick() {
            if (this.operation == MoveControl.Operation.MOVE_TO) {
                Vec3 vec3 = new Vec3(this.wantedX - this.mob.getX(), this.wantedY - this.mob.getY(), this.wantedZ - this.mob.getZ());
                double d0 = vec3.length();
                if (d0 < this.mob.getBoundingBox().getSize()) {
                    this.operation = MoveControl.Operation.WAIT;
                    this.mob.setDeltaMovement(this.mob.getDeltaMovement().scale(0.5));
                } else {
                    this.mob.setDeltaMovement(this.mob.getDeltaMovement().add(vec3.scale(this.speedModifier * 0.05 / d0)));
                    if (this.mob.getTarget() == null) {
                        Vec3 vec31 = this.mob.getDeltaMovement();
                        this.mob.setYRot(-((float)Mth.atan2((double)vec31.x, (double)vec31.z)) * 57.295776f);
                        this.mob.yBodyRot = this.mob.getYRot();
                    } else {
                        double d2 = this.mob.getTarget().getX() - this.mob.getX();
                        double d1 = this.mob.getTarget().getZ() - this.mob.getZ();
                        this.mob.setYRot(-((float)Mth.atan2((double)d2, (double)d1)) * 57.295776f);
                        this.mob.yBodyRot = this.mob.getYRot();
                    }
                }
            }
        }
    }

    public static class FireballAttackGoal
    extends Goal {
        private final ImpEntity mob;
        private LivingEntity target;
        private boolean hasShoot;
        private int attackTick;
        private int ATTACK_DURATION = 25;

        public FireballAttackGoal(ImpEntity pMob) {
            this.mob = pMob;
        }

        public void start() {
            this.mob.setAnimationId(SHOOT);
            this.mob.triggerAnim("attackController", "ranged");
            this.mob.getNavigation().stop();
            this.attackTick = 0;
            this.hasShoot = false;
        }

        public boolean canUse() {
            this.target = this.mob.getTarget();
            return this.target != null && this.mob.canAttack(this.target) && this.mob.shootCooldown <= 0 && (double)this.mob.getRandom().nextFloat() <= 0.14 && !this.mob.isDeadOrDying();
        }

        public void tick() {
            ++this.attackTick;
            if (this.target != null) {
                this.mob.getLookControl().setLookAt((Entity)this.target, 10.0f, 10.0f);
                if (!this.hasShoot) {
                    this.mob.castFireball(this.target);
                    this.hasShoot = true;
                    this.stop();
                }
            }
            if (this.attackTick >= this.ATTACK_DURATION) {
                this.stop();
            }
        }

        public void stop() {
            this.target = null;
            this.mob.setAnimationId(0);
            this.mob.getNavigation().recomputePath();
            this.mob.shootCooldown = DefaultMobAttributes.IMP_SHOOT_ATTACK_COOLDOWN;
            this.hasShoot = false;
            this.attackTick = 0;
            this.mob.stopTriggeredAnim("attackController", "ranged");
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }
    }

    public static class ImpAttackGoal
    extends Goal {
        private final ImpEntity imp;
        LivingEntity target;

        public ImpAttackGoal(ImpEntity imp) {
            this.imp = imp;
        }

        public boolean canUse() {
            this.target = this.imp.getTarget();
            return this.target != null && this.target.isAlive() && !this.imp.getMoveControl().hasWanted() && this.imp.getRandom().nextInt(ImpAttackGoal.reducedTickDelay((int)7)) == 0 && this.imp.distanceToSqr((Entity)this.target) > 3.0;
        }

        public boolean canContinueToUse() {
            return this.imp.getMoveControl().hasWanted() && this.target != null && this.target.isAlive();
        }

        public void start() {
            Vec3 vec3 = this.target.getEyePosition();
            this.imp.getMoveControl().setWantedPosition(vec3.x, vec3.y, vec3.z, 1.0);
            this.imp.playSound(SoundEvents.VEX_CHARGE, 1.0f, 0.6f);
        }

        public void stop() {
            this.target = null;
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public void tick() {
            if (this.imp.getBoundingBox().intersects(this.target.getBoundingBox())) {
                this.imp.doHurtTarget((Entity)this.target);
                this.imp.triggerAnim("attackController", "attack");
            } else {
                double distance = this.imp.distanceToSqr((Entity)this.target);
                if (distance < 9.0) {
                    Vec3 vec3 = this.target.getEyePosition();
                    this.imp.getMoveControl().setWantedPosition(vec3.x, vec3.y, vec3.z, 1.1);
                }
            }
        }
    }

    public static class ImpRandomMoveGoal
    extends Goal {
        private final ImpEntity mob;

        public ImpRandomMoveGoal(ImpEntity pMob) {
            this.mob = pMob;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            return !this.mob.getMoveControl().hasWanted() && this.mob.random.nextInt(ImpRandomMoveGoal.reducedTickDelay((int)7)) == 0;
        }

        public void tick() {
            BlockPos blockPos = this.mob.getBoundOrigin();
            if (blockPos == null) {
                blockPos = this.mob.blockPosition();
            }
            for (int i = 0; i < 3; ++i) {
                BlockPos blockPos1 = blockPos.offset(this.mob.random.nextInt(15) - 7, this.mob.random.nextInt(11) - 5, this.mob.random.nextInt(15) - 7);
                if (!this.mob.level().isEmptyBlock(blockPos1)) continue;
                this.mob.moveControl.setWantedPosition((double)blockPos1.getX() + 0.5, (double)blockPos1.getY() + 0.5, (double)blockPos1.getZ() + 0.5, 0.25);
                if (this.mob.getTarget() != null) break;
                this.mob.getLookControl().setLookAt((double)blockPos1.getX() + 0.5, (double)blockPos1.getY() + 0.5, (double)blockPos1.getZ() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }
}

