/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity;

import com.ovinter.mythsandlegends.entity.ai.navigation.GroundNavigator;
import com.ovinter.mythsandlegends.entity.enemy.IAnimatedMob;
import com.ovinter.mythsandlegends.entity.enemy.IEnemy;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.PathType;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;

public abstract class MLEntity
extends Monster
implements GeoEntity,
IAnimatedMob,
IEnemy {
    private static final EntityDataAccessor<Integer> DATA_ATTACK_TICKS = SynchedEntityData.defineId(MLEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_ANIMATION_ID = SynchedEntityData.defineId(MLEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> DATA_IS_RUNNING = SynchedEntityData.defineId(MLEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public MLEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.setPathfindingMalus(PathType.UNPASSABLE_RAIL, 0.0f);
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(DATA_ATTACK_TICKS, (Object)0);
        pBuilder.define(DATA_ANIMATION_ID, (Object)0);
        pBuilder.define(DATA_IS_RUNNING, (Object)false);
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.setAnimationId(pCompound.getInt("AnimationId"));
        if (pCompound.contains("IsRunning")) {
            this.setRunning(pCompound.getBoolean("IsRunning"));
        }
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putInt("AnimationId", 0);
        pCompound.putBoolean("IsRunning", this.isRunning());
    }

    protected PathNavigation createNavigation(Level pLevel) {
        return new GroundNavigator((Mob)this, pLevel);
    }

    @Override
    public void setAnimationId(int pId) {
        this.entityData.set(DATA_ANIMATION_ID, (Object)pId);
    }

    @Override
    public int getAnimationId() {
        return (Integer)this.entityData.get(DATA_ANIMATION_ID);
    }

    public void setAttackTicks(int pAttackTimer) {
        this.entityData.set(DATA_ATTACK_TICKS, (Object)pAttackTimer);
    }

    public int getAttackTicks() {
        return (Integer)this.entityData.get(DATA_ATTACK_TICKS);
    }

    public void setRunning(boolean pRunning) {
        this.entityData.set(DATA_IS_RUNNING, (Object)pRunning);
    }

    public boolean isRunning() {
        return (Boolean)this.entityData.get(DATA_IS_RUNNING);
    }

    abstract PlayState movementPredicate(AnimationState<?> var1);

    abstract PlayState attackPredicate(AnimationState<?> var1);

    abstract void setConfigAttributes();
}

