/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity;

import com.ovinter.mythsandlegends.Config;
import com.ovinter.mythsandlegends.config.DefaultMobAttributes;
import com.ovinter.mythsandlegends.entity.AbstractPossessedArmor;
import com.ovinter.mythsandlegends.entity.ai.goal.generic.AnimatedRangedAttackGoal;
import com.ovinter.mythsandlegends.registry.MLSounds;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class PossessedArmorArcherEntity
extends AbstractPossessedArmor
implements RangedAttackMob {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final RawAnimation IDLE = RawAnimation.begin().thenLoop("IDLE");
    private final RawAnimation WALK = RawAnimation.begin().thenLoop("WALK");
    private final RawAnimation RANGED_ATTACK = RawAnimation.begin().thenLoop("RANGED_ATTACK");
    private final RawAnimation DEATH = RawAnimation.begin().thenPlay("DEATH");

    public PossessedArmorArcherEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Override
    public ResourceLocation getModelResource() {
        return ResourceLocation.fromNamespaceAndPath((String)"mythsandlegends", (String)"geo/entity/possessed_armor_archer.geo.json");
    }

    @Override
    public ResourceLocation getTextureResource() {
        return this.getHasHalfHealth() ? ResourceLocation.fromNamespaceAndPath((String)"mythsandlegends", (String)"textures/entity/possessed_armor/possessed_armor_archer_damaged.png") : ResourceLocation.fromNamespaceAndPath((String)"mythsandlegends", (String)"textures/entity/possessed_armor/possessed_armor_archer.png");
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, DefaultMobAttributes.POSSESSED_ARMOR_ARCHER_HEALTH).add(Attributes.ARMOR, DefaultMobAttributes.POSSESSED_ARMOR_ARCHER_ARMOR).add(Attributes.ARMOR_TOUGHNESS, DefaultMobAttributes.POSSESSED_ARMOR_ARCHER_ARMOR_TOUGHNESS).add(Attributes.MOVEMENT_SPEED, DefaultMobAttributes.POSSESSED_ARMOR_ARCHER_MOVEMENT).add(Attributes.ATTACK_DAMAGE, DefaultMobAttributes.POSSESSED_ARMOR_ARCHER_DAMAGE).add(Attributes.ATTACK_KNOCKBACK, DefaultMobAttributes.POSSESSED_ARMOR_ARCHER_ATTACK_KNOCKBACK).add(Attributes.KNOCKBACK_RESISTANCE, DefaultMobAttributes.POSSESSED_ARMOR_ARCHER_KNOCKBACK_RESISTANCE).add(Attributes.WATER_MOVEMENT_EFFICIENCY, DefaultMobAttributes.POSSESSED_ARMOR_ARCHER_WATER_MOVEMENT).add(Attributes.FOLLOW_RANGE, DefaultMobAttributes.POSSESSED_ARMOR_ARCHER_FOLLOW_RANGE);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(4, new AnimatedRangedAttackGoal<PossessedArmorArcherEntity>(this, 1.0, 7, 15.0f));
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pSpawnType, @Nullable SpawnGroupData pSpawnGroupData) {
        RandomSource randomsource = pLevel.getRandom();
        this.populateDefaultEquipmentSlots(randomsource, pDifficulty);
        this.populateDefaultEquipmentEnchantments(pLevel, randomsource, pDifficulty);
        this.setConfigAttributes();
        return super.finalizeSpawn(pLevel, pDifficulty, pSpawnType, pSpawnGroupData);
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance difficulty) {
        this.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.BOW));
        this.setDropChance(EquipmentSlot.MAINHAND, 0.0f);
        super.populateDefaultEquipmentSlots(random, difficulty);
    }

    public void performRangedAttack(LivingEntity target, float velocity) {
        ItemStack weapon = this.getItemInHand(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof BowItem));
        ItemStack itemstack = this.getProjectile(weapon);
        AbstractArrow abstractarrow = this.getArrow(itemstack, velocity, weapon);
        Item item2 = weapon.getItem();
        if (item2 instanceof ProjectileWeaponItem) {
            ProjectileWeaponItem weaponItem = (ProjectileWeaponItem)item2;
            abstractarrow = weaponItem.customArrow(abstractarrow, itemstack, weapon);
        }
        double d0 = target.getX() - this.getX();
        double d1 = target.getY(0.3333333333333333) - abstractarrow.getY();
        double d2 = target.getZ() - this.getZ();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        abstractarrow.shoot(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.level().getDifficulty().getId() * 4));
        this.playSound(SoundEvents.ARROW_SHOOT, 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
        this.level().addFreshEntity((Entity)abstractarrow);
    }

    private AbstractArrow getArrow(ItemStack arrow, float velocity, @javax.annotation.Nullable ItemStack weapon) {
        return ProjectileUtil.getMobArrow((LivingEntity)this, (ItemStack)arrow, (float)velocity, (ItemStack)weapon);
    }

    @Override
    protected PlayState movementPredicate(AnimationState<?> state) {
        if (this.isDeadOrDying()) {
            return state.setAndContinue(this.DEATH);
        }
        if (state.isMoving()) {
            return state.setAndContinue(this.WALK);
        }
        return state.setAndContinue(this.IDLE);
    }

    @Override
    PlayState attackPredicate(AnimationState<?> state) {
        if (this.isDeadOrDying()) {
            this.stopTriggeredAnim("attackController", "ranged");
            return PlayState.STOP;
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "movementController", 5, this::movementPredicate).setSoundKeyframeHandler(state -> {
            if (state.getKeyframeData().getSound().equals("step") && this.onGround()) {
                this.level().playLocalSound(this.getOnPos(), (SoundEvent)MLSounds.POSSESSED_ARMOR_STEP.value(), SoundSource.HOSTILE, 1.0f, 1.0f, false);
            }
        }));
        controllers.add(new AnimationController((GeoAnimatable)this, "attackController", 3, this::attackPredicate).triggerableAnim("ranged", this.RANGED_ATTACK));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    @Override
    void setConfigAttributes() {
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(((Double)Config.POSSESSED_ARMOR_ARCHER_HEALTH.get()).doubleValue());
        this.getAttribute(Attributes.ARMOR).setBaseValue(((Double)Config.POSSESSED_ARMOR_ARCHER_ARMOR.get()).doubleValue());
        this.getAttribute(Attributes.ARMOR).setBaseValue(((Double)Config.POSSESSED_ARMOR_ARCHER_ARMOR.get()).doubleValue());
        this.getAttribute(Attributes.ARMOR_TOUGHNESS).setBaseValue(((Double)Config.POSSESSED_ARMOR_ARCHER_ARMOR_TOUGHNESS.get()).doubleValue());
        this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(((Double)Config.POSSESSED_ARMOR_ARCHER_DAMAGE.get()).doubleValue());
        this.getAttribute(Attributes.ATTACK_KNOCKBACK).setBaseValue(((Double)Config.POSSESSED_ARMOR_ARCHER_ATTACK_KNOCKBACK.get()).doubleValue());
        this.getAttribute(Attributes.KNOCKBACK_RESISTANCE).setBaseValue(((Double)Config.POSSESSED_ARMOR_ARCHER_KNOCKBACK_RESISTANCE.get()).doubleValue());
        this.setHealth((float)Config.POSSESSED_ARMOR_ARCHER_HEALTH.getAsDouble());
    }
}

