/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity;

import com.ovinter.mythsandlegends.Config;
import com.ovinter.mythsandlegends.api.util.ParticleGeneratorHelper;
import com.ovinter.mythsandlegends.config.DefaultMobAttributes;
import com.ovinter.mythsandlegends.entity.AbstractPossessedArmor;
import com.ovinter.mythsandlegends.entity.PossessedArmorEntity;
import com.ovinter.mythsandlegends.entity.ai.goal.generic.AnimatedMeleeAttackGoal;
import com.ovinter.mythsandlegends.entity.ai.goal.generic.ChaseTargetGoal;
import com.ovinter.mythsandlegends.entity.ai.goal.inquisitor.ImpaleAttackGoal;
import com.ovinter.mythsandlegends.entity.ai.goal.inquisitor.StunLockGoal;
import com.ovinter.mythsandlegends.entity.ai.goal.inquisitor.SummonMinionsGoal;
import com.ovinter.mythsandlegends.registry.MLSounds;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class PossessedArmorInquisitorEntity
extends AbstractPossessedArmor {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("IDLE_INQUISITOR");
    private static final RawAnimation WALK = RawAnimation.begin().thenLoop("WALK_INQUISITOR");
    private static final RawAnimation ATTACK = RawAnimation.begin().thenPlay("ATTACK_INQUISITOR");
    private static final RawAnimation ATTACK_ALT = RawAnimation.begin().thenPlay("ATTACK_ALT_INQUISITOR");
    private static final RawAnimation IMPALE_ATTACK = RawAnimation.begin().thenPlay("IMPALE_ATTACK_INQUISITOR");
    private static final RawAnimation SLAM_ATTACK = RawAnimation.begin().thenPlay("SLAM_ATTACK_INQUISITOR");
    private static final RawAnimation SUMMON_ANIM = RawAnimation.begin().thenPlay("SUMMON_INQUISITOR");
    private static final RawAnimation STUN_ANIM = RawAnimation.begin().thenLoop("STUN_INQUISITOR");
    private static final RawAnimation DEATH = RawAnimation.begin().thenPlay("DEATH");
    private static final EntityDataAccessor<Integer> DATA_STUN_TICKS = SynchedEntityData.defineId(PossessedArmorInquisitorEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_SUMMON_TICKS = SynchedEntityData.defineId(PossessedArmorInquisitorEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> DATA_STUNNED = SynchedEntityData.defineId(PossessedArmorInquisitorEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public int SLAM_COOLDOWN = 220;
    public int IMPALE_COOLDOWN = 200;
    public int SUMMON_COOLDOWN = 220;
    public int slamCooldown;
    public int impaleCooldown;
    public int summonCooldown;
    private final double STUN_CHANCE = 0.1;
    private final int BASE_STUN_DURATION = 80;
    public int STUN = 3;
    public int IMPALE = 4;
    public int SUMMON = 5;

    public PossessedArmorInquisitorEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.xpReward = 75;
    }

    @Override
    public ResourceLocation getModelResource() {
        return ResourceLocation.fromNamespaceAndPath((String)"mythsandlegends", (String)"geo/entity/possessed_armor_inquisitor.geo.json");
    }

    @Override
    public ResourceLocation getTextureResource() {
        return this.getHasHalfHealth() ? ResourceLocation.fromNamespaceAndPath((String)"mythsandlegends", (String)"textures/entity/possessed_armor/possessed_armor_inquisitor_damaged.png") : ResourceLocation.fromNamespaceAndPath((String)"mythsandlegends", (String)"textures/entity/possessed_armor/possessed_armor_inquisitor.png");
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(DATA_STUN_TICKS, (Object)80);
        pBuilder.define(DATA_SUMMON_TICKS, (Object)0);
        pBuilder.define(DATA_STUNNED, (Object)false);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        if (pCompound.contains("IsStunned")) {
            this.setStunned(pCompound.getBoolean("IsStunned"));
        }
        this.setStunTicks(pCompound.getInt("StunTicks"));
        this.setSummonTicks(pCompound.getInt("SummonTicks"));
    }

    @Override
    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putBoolean("IsStunned", this.isStunned());
        pCompound.putInt("StunTicks", this.getStunTicks());
        pCompound.putInt("SummonTicks", this.getSummonTicks());
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, DefaultMobAttributes.POSSESSED_ARMOR_INQUISITOR_HEALTH).add(Attributes.ARMOR, DefaultMobAttributes.POSSESSED_ARMOR_INQUISITOR_ARMOR).add(Attributes.ARMOR_TOUGHNESS, DefaultMobAttributes.POSSESSED_ARMOR_INQUISITOR_ARMOR_TOUGHNESS).add(Attributes.ATTACK_DAMAGE, DefaultMobAttributes.POSSESSED_ARMOR_INQUISITOR_DAMAGE).add(Attributes.ATTACK_KNOCKBACK, DefaultMobAttributes.POSSESSED_ARMOR_ATTACK_INQUISITOR_KNOCKBACK).add(Attributes.KNOCKBACK_RESISTANCE, DefaultMobAttributes.POSSESSED_ARMOR_INQUISITOR_KNOCKBACK_RESISTANCE).add(Attributes.MOVEMENT_SPEED, DefaultMobAttributes.POSSESSED_ARMOR_INQUISITOR_MOVEMENT).add(Attributes.WATER_MOVEMENT_EFFICIENCY, DefaultMobAttributes.POSSESSED_ARMOR_INQUISITOR_WATER_MOVEMENT).add(Attributes.FOLLOW_RANGE, DefaultMobAttributes.POSSESSED_ARMOR_FOLLOW_RANGE_INQUISITOR);
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new StunLockGoal(this));
        super.registerGoals();
        this.goalSelector.addGoal(3, (Goal)new ImpaleAttackGoal(this));
        this.goalSelector.addGoal(3, new SummonMinionsGoal<PossessedArmorEntity>(this, 2, 2, 250, PossessedArmorEntity.class));
        this.goalSelector.addGoal(4, (Goal)new AnimatedMeleeAttackGoal(this, 40, 15, 3.0f));
        this.goalSelector.addGoal(4, (Goal)new ChaseTargetGoal(this, false, 1.2));
    }

    @Override
    public void tick() {
        if (this.slamCooldown > 0) {
            --this.slamCooldown;
        }
        if (this.impaleCooldown > 0) {
            --this.impaleCooldown;
        }
        if (this.summonCooldown > 0) {
            --this.summonCooldown;
        }
        super.tick();
    }

    @Override
    protected void customServerAiStep() {
        if (this.getStunTicks() > 0) {
            this.setStunTicks(this.getStunTicks() - 1);
        }
        if (this.getSummonTicks() > 0) {
            this.setSummonTicks(this.getStunTicks() - 1);
        }
        super.customServerAiStep();
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        this.setConfigAttributes();
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    @Override
    public boolean hurt(DamageSource pSource, float pAmount) {
        double chance = this.getRandom().nextDouble();
        if (!this.level().isClientSide && chance <= 0.1 && !this.isStunned() && this.getStunTicks() == 0 && this.getAnimationId() == this.SUMMON) {
            this.shouldApplyStun();
            pAmount *= 0.5f;
        }
        return super.hurt(pSource, pAmount);
    }

    public void handleEntityEvent(byte id) {
        if (id == 69) {
            ParticleGeneratorHelper.generateShockwaveParticles(this.level(), (LivingEntity)this, 6.0);
        }
        if (id == 70) {
            ParticleGeneratorHelper.generateStunParticles(this.level(), (LivingEntity)this);
        }
        super.handleEntityEvent(id);
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public boolean isPushable() {
        return false;
    }

    public void playSummonSound() {
        this.playSound((SoundEvent)MLSounds.INQUISITOR_SUMMONING.value());
    }

    public int getStunTicks() {
        return (Integer)this.entityData.get(DATA_STUN_TICKS);
    }

    public void setStunTicks(int pTicks) {
        this.entityData.set(DATA_STUN_TICKS, (Object)pTicks);
    }

    public boolean isStunned() {
        return (Boolean)this.entityData.get(DATA_STUNNED);
    }

    public void setStunned(boolean pIsStunned) {
        this.entityData.set(DATA_STUNNED, (Object)pIsStunned);
    }

    public void setSummonTicks(int pTicks) {
        this.entityData.set(DATA_SUMMON_TICKS, (Object)pTicks);
    }

    public int getSummonTicks() {
        return (Integer)this.entityData.get(DATA_SUMMON_TICKS);
    }

    @Override
    PlayState movementPredicate(AnimationState<?> state) {
        if (this.isDeadOrDying()) {
            return state.setAndContinue(DEATH);
        }
        if (this.isStunned() && this.getAnimationId() == this.STUN) {
            return state.setAndContinue(STUN_ANIM);
        }
        if (this.getAnimationId() == this.IMPALE) {
            return state.setAndContinue(IMPALE_ATTACK);
        }
        if (this.getAnimationId() == this.SUMMON) {
            return state.setAndContinue(SUMMON_ANIM);
        }
        return state.isMoving() ? state.setAndContinue(WALK) : state.setAndContinue(IDLE);
    }

    @Override
    PlayState attackPredicate(AnimationState<?> state) {
        if (this.isDeadOrDying() || this.isStunned() || this.getAnimationId() == this.SUMMON) {
            return PlayState.STOP;
        }
        if (this.getAnimationId() == 1 && this.isAlive() && this.getAttackTicks() == 39) {
            state.getController().forceAnimationReset();
            return state.setAndContinue(ATTACK);
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "movementController", 5, this::movementPredicate).setSoundKeyframeHandler(state -> {
            if (state.getKeyframeData().getSound().equals("step") && this.onGround()) {
                this.level().playLocalSound(this.getOnPos(), (SoundEvent)MLSounds.POSSESSED_ARMOR_STEP.value(), SoundSource.HOSTILE, 1.0f, 1.0f, false);
            }
        }));
        controllers.add(new AnimationController((GeoAnimatable)this, "attackController", 3, this::attackPredicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    @Override
    void setConfigAttributes() {
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(((Double)Config.POSSESSED_ARMOR_INQUISITOR_HEALTH.get()).doubleValue());
        this.getAttribute(Attributes.ARMOR).setBaseValue(((Double)Config.POSSESSED_ARMOR_INQUISITOR_ARMOR.get()).doubleValue());
        this.getAttribute(Attributes.ARMOR).setBaseValue(((Double)Config.POSSESSED_ARMOR_INQUISITOR_ARMOR.get()).doubleValue());
        this.getAttribute(Attributes.ARMOR_TOUGHNESS).setBaseValue(((Double)Config.POSSESSED_ARMOR_INQUISITOR_ARMOR_TOUGHNESS.get()).doubleValue());
        this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(((Double)Config.POSSESSED_ARMOR_INQUISITOR_DAMAGE.get()).doubleValue());
        this.getAttribute(Attributes.ATTACK_KNOCKBACK).setBaseValue(((Double)Config.POSSESSED_ARMOR_INQUISITOR_ATTACK_KNOCKBACK.get()).doubleValue());
        this.getAttribute(Attributes.KNOCKBACK_RESISTANCE).setBaseValue(((Double)Config.POSSESSED_ARMOR_INQUISITOR_KNOCKBACK_RESISTANCE.get()).doubleValue());
        this.setHealth((float)Config.POSSESSED_ARMOR_INQUISITOR_HEALTH.getAsDouble());
    }

    public void shouldApplyStun() {
        this.setStunned(true);
        this.setStunTicks(80);
    }
}

