/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity.ai.goal.abaddon;

import com.ovinter.mythsandlegends.entity.AbaddonEntity;
import com.ovinter.mythsandlegends.entity.effects.MotlenThornEntity;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MoltenSpikesGoal
extends Goal {
    private final AbaddonEntity mob;
    private LivingEntity target;
    private int attackTick;
    private final int ATTACK_DURATION = 30;
    private final int TOTAL_SPIKES = 6;
    private final double[] rowAngles = new double[]{-27.0, 0.0, 27.0};

    public MoltenSpikesGoal(AbaddonEntity mob) {
        this.mob = mob;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        this.target = this.mob.getTarget();
        return this.target != null && this.mob.getAnimationId() == 0 && this.mob.distanceTo((Entity)this.target) <= 6.0f && this.mob.onGround() && !this.mob.isInLava() && !this.mob.isInWaterOrBubble() && this.mob.isAlive() && this.mob.moltenSpikeCooldown == 0;
    }

    public boolean canContinueToUse() {
        return this.target != null && this.target.isAlive() && this.mob.moltenSpikeCooldown == 0;
    }

    public void start() {
        this.mob.setAnimationId(2);
        this.mob.getNavigation().stop();
        this.mob.getLookControl().setLookAt((Entity)this.target);
        this.attackTick = 0;
    }

    public void stop() {
        this.mob.setAnimationId(0);
        this.mob.getNavigation().recomputePath();
        this.attackTick = 0;
        this.mob.moltenSpikeCooldown = this.mob.MOLTEN_SPIKE_COOLDOWN;
    }

    public void tick() {
        ++this.attackTick;
        this.mob.getLookControl().setLookAt((Entity)this.target);
        this.mob.getLookControl().tick();
        if (this.target != null && this.attackTick == 15) {
            Vec3 mobPos = this.mob.position();
            Vec3 targetPos = this.target.position();
            double distanceX = targetPos.x - mobPos.x;
            double distanceZ = targetPos.z - mobPos.z;
            float yaw = (float)(Math.atan2(distanceZ, distanceX) * 57.29577951308232) - 90.0f;
            this.mob.setYRot(yaw);
            this.mob.setYBodyRot(yaw);
            this.mob.setYHeadRot(yaw);
            for (double rowAngle : this.rowAngles) {
                for (int i = 0; i < 6; ++i) {
                    this.spawnMoltenSpikes(i, this.mob, rowAngle);
                }
            }
        }
        if (this.attackTick >= 30) {
            this.stop();
        }
    }

    private void spawnMoltenSpikes(int pIndex, AbaddonEntity abaddon, double pAngleOffset) {
        int lowestYCheck = Mth.floor((double)abaddon.getY()) - 1;
        double y = abaddon.getY() + 1.0;
        float yawRadians = (float)Math.toRadians((double)(90.0f + abaddon.getYRot()) + pAngleOffset);
        double distance = 2.0 + (double)pIndex * 1.25;
        int warmUpDelayTicks = pIndex * 2;
        double x = abaddon.getX() + (double)Mth.cos((float)yawRadians) * distance;
        double z = abaddon.getZ() + (double)Mth.sin((float)yawRadians) * distance;
        BlockPos blockPos = BlockPos.containing((double)x, (double)y, (double)z);
        boolean foundGround = false;
        double d0 = 0.0;
        do {
            BlockState blockState1;
            VoxelShape voxelShape;
            BlockPos blockPos1 = blockPos.below();
            BlockState blockState = abaddon.level().getBlockState(blockPos1);
            if (!blockState.isFaceSturdy((BlockGetter)abaddon.level(), blockPos1, Direction.UP)) continue;
            if (!abaddon.level().isEmptyBlock(blockPos) && !(voxelShape = (blockState1 = abaddon.level().getBlockState(blockPos)).getCollisionShape((BlockGetter)abaddon.level(), blockPos)).isEmpty()) {
                d0 = voxelShape.max(Direction.Axis.Y);
            }
            foundGround = true;
            break;
        } while ((blockPos = blockPos.below()).getY() >= lowestYCheck);
        if (foundGround) {
            MotlenThornEntity thornEntity = new MotlenThornEntity(abaddon.level(), x, (double)blockPos.getY() + d0, z, yawRadians, warmUpDelayTicks, 4.0f, (LivingEntity)abaddon);
            abaddon.level().addFreshEntity((Entity)thornEntity);
        }
    }
}

