/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity.ai.goal.black_charro;

import com.ovinter.mythsandlegends.entity.BlackCharroEntityNew;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;

public class ChainOfLungesGoal
extends Goal {
    private final BlackCharroEntityNew mob;
    private int cooldown = 0;
    private int dashesLeft = 0;
    private int attackTick;

    public ChainOfLungesGoal(BlackCharroEntityNew mob) {
        this.mob = mob;
    }

    public boolean canUse() {
        return this.mob.getBossPhase() == 2 && this.cooldown <= 0 && this.mob.getTarget() != null;
    }

    public void start() {
        this.dashesLeft = 3 + this.mob.getRandom().nextInt(2);
        this.attackTick = 0;
    }

    public void tick() {
        ++this.attackTick;
        if (this.dashesLeft > 0 && this.attackTick % 15 == 0) {
            this.mob.setAnimationId(this.mob.QUICK_LUNG);
            if (this.mob.getTarget() != null) {
                this.mob.doHurtTarget((Entity)this.mob.getTarget());
            }
            --this.dashesLeft;
        } else {
            this.cooldown = 160;
        }
    }

    public boolean canContinueToUse() {
        return this.dashesLeft > 0;
    }

    public void stop() {
        this.mob.setAnimationId(0);
        this.attackTick = 0;
    }
}

