/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity.ai.goal.black_charro;

import com.ovinter.mythsandlegends.api.util.SendMessageToPlayer;
import com.ovinter.mythsandlegends.entity.BlackCharroEntityNew;
import com.ovinter.mythsandlegends.entity.CondemnedEntity;
import com.ovinter.mythsandlegends.registry.MLEntities;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;

public class DancingShadowsGoal
extends Goal {
    private final BlackCharroEntityNew mob;
    private int cooldown = 0;
    private int summonTick;
    private final int MINION_TO_SPAWN = 3;

    public DancingShadowsGoal(BlackCharroEntityNew pMob) {
        this.mob = pMob;
    }

    public boolean canUse() {
        return this.mob.getBossPhase() == 1 && this.cooldown <= 0 && this.mob.getTarget() != null;
    }

    public void start() {
        this.mob.setAnimationId(this.mob.SUMMON);
        this.summonTick = 0;
        for (int i = 0; i < 3; ++i) {
            CondemnedEntity minion = new CondemnedEntity(MLEntities.CONDEMNED.get(), this.mob.level());
            minion.moveTo(this.mob.getX(), this.mob.getY(), this.mob.getZ());
            this.mob.level().addFreshEntity((Entity)minion);
        }
        this.cooldown = 400;
    }

    public void tick() {
        LivingEntity livingEntity;
        ++this.summonTick;
        if (this.mob.getTarget() != null && this.cooldown <= 0 && this.summonTick == 18 && (livingEntity = this.mob.getTarget()) instanceof Player) {
            Player target = (Player)livingEntity;
            SendMessageToPlayer.sendRandomMessage("summon_condemned", target, 6);
        }
    }

    public void stop() {
        this.mob.setAnimationId(0);
        this.summonTick = 0;
    }
}

