/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity.ai.goal.black_charro;

import com.ovinter.mythsandlegends.entity.BlackCharroEntityNew;
import com.ovinter.mythsandlegends.entity.projectile.UmbralOrbEntity;
import com.ovinter.mythsandlegends.registry.MLEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;

public class FuneralBalladGoal
extends Goal {
    private final BlackCharroEntityNew mob;
    BlockPos groundPos;
    private int cooldown = 0;
    private final int ORB_COUNT = 10;
    private boolean isInAir = false;
    private int attackTick;

    public FuneralBalladGoal(BlackCharroEntityNew pMob) {
        this.mob = pMob;
    }

    public boolean canUse() {
        return this.mob.getBossPhase() == 3 && this.cooldown <= 0 && this.mob.getTarget() != null;
    }

    public void start() {
        this.attackTick = 0;
        this.groundPos = this.mob.blockPosition();
        BlockPos abovePos = this.groundPos.above(7);
        if (this.mob.isValidTeleportLocation(this.mob.getX(), this.mob.getY(), this.mob.getZ())) {
            this.mob.playTeleportSound();
            this.mob.triggerAnim("movementController", "teleport");
            this.mob.teleportTo((double)abovePos.getX() + 0.5, abovePos.getY(), (double)abovePos.getZ() + 0.5);
            this.isInAir = true;
        }
        for (int i = 0; i < 10; ++i) {
            double offsetX = this.mob.getRandom().nextGaussian() * 4.0;
            double offsetZ = this.mob.getRandom().nextGaussian() * 4.0;
            UmbralOrbEntity orb = new UmbralOrbEntity(MLEntities.UMBRAL_ORB.get(), this.mob.level(), (LivingEntity)this.mob);
            orb.moveTo(this.mob.getX() + offsetX, this.mob.getY() + 5.0, this.mob.getZ() + offsetZ);
            this.mob.level().addFreshEntity((Entity)orb);
        }
        this.cooldown = 300;
    }

    public void tick() {
        System.out.println("COOLDOWN: " + this.cooldown);
        --this.cooldown;
        if (this.cooldown <= 0 && this.isInAir) {
            System.out.println("!!!ENTRO!!!");
            this.mob.playTeleportSound();
            this.mob.triggerAnim("movementController", "teleport");
            this.mob.teleportTo((double)this.groundPos.getX() + 0.5, this.groundPos.getY(), (double)this.groundPos.getZ() + 0.5);
            this.isInAir = false;
            this.stop();
        }
    }

    public boolean canContinueToUse() {
        return this.cooldown > 0;
    }

    public void stop() {
        if (this.isInAir) {
            this.mob.playTeleportSound();
            this.mob.triggerAnim("movementController", "teleport");
            this.mob.teleportTo((double)this.groundPos.getX() + 0.5, this.groundPos.getY(), (double)this.groundPos.getZ() + 0.5);
            this.isInAir = false;
        }
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }
}

