/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity.ai.goal.black_charro;

import com.ovinter.mythsandlegends.entity.BlackCharroEntityNew;
import com.ovinter.mythsandlegends.entity.projectile.UmbralOrbEntity;
import com.ovinter.mythsandlegends.registry.MLEntities;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;

public class ShadowStepGoal
extends Goal {
    private final BlackCharroEntityNew mob;
    private int cooldown = 0;

    public ShadowStepGoal(BlackCharroEntityNew pMob) {
        this.mob = pMob;
    }

    public boolean canUse() {
        return this.mob.getBossPhase() == 2 && this.cooldown <= 0 && this.mob.getTarget() != null;
    }

    public void start() {
        this.mob.level().playSound(null, this.mob.blockPosition(), SoundEvents.WITHER_SPAWN, SoundSource.HOSTILE, 1.0f, 0.8f);
        this.mob.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, this.mob.getX(), this.mob.getY(), this.mob.getZ(), 30.0, 1.0, 0.1);
        for (int i = -2; i <= 2; ++i) {
            UmbralOrbEntity wave = new UmbralOrbEntity(MLEntities.UMBRAL_ORB.get(), this.mob.level());
            wave.shoot(Math.cos((double)i * 0.5), 0.0, Math.sin((double)i * 0.5), 0.8f, 0.0f);
            this.mob.level().addFreshEntity((Entity)wave);
        }
        this.cooldown = 200;
    }

    public void tick() {
        --this.cooldown;
    }

    public boolean canContinueToUse() {
        return false;
    }
}

