/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity.ai.goal.generic;

import com.ovinter.mythsandlegends.entity.MLEntity;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;

public class AnimatedMeleeAttackGoal
extends Goal {
    protected final MLEntity mob;
    private LivingEntity target;
    private int attackTick;
    private float attackRange;
    private int animationDuration;
    private int dealDamageOnTick;

    public AnimatedMeleeAttackGoal(MLEntity pMob, int pAnimationDuration, int pDealDamageOnTick, float pAttackRange) {
        this.mob = pMob;
        this.animationDuration = pAnimationDuration;
        this.dealDamageOnTick = pDealDamageOnTick;
        this.attackRange = pAttackRange;
        this.setFlags(EnumSet.of(Goal.Flag.LOOK));
    }

    public boolean canUse() {
        LivingEntity target = this.mob.getTarget();
        return target != null && target.isAlive() && this.mob.getAnimationId() == 0 && this.mob.distanceTo((Entity)target) <= 3.0f;
    }

    public void start() {
        this.target = this.mob.getTarget();
        this.attackTick = 0;
        this.mob.setAnimationId(1);
        this.mob.setAttackTicks(this.animationDuration);
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        if (this.target == null) {
            return;
        }
        ++this.attackTick;
        this.mob.getLookControl().setLookAt((Entity)this.target);
        this.mob.lookAt((Entity)this.target, 30.0f, 30.0f);
        if (this.mob.getAttackTicks() == this.dealDamageOnTick && this.mob.distanceTo((Entity)this.target) <= this.attackRange && this.mob.getSensing().hasLineOfSight((Entity)this.target)) {
            this.mob.swinging = true;
            this.mob.doHurtTarget((Entity)this.target);
        }
        if (this.attackTick >= this.animationDuration) {
            this.stop();
        }
    }

    public void stop() {
        this.mob.setAnimationId(0);
        this.mob.setAttackTicks(0);
        this.mob.swinging = false;
        this.target = null;
    }

    public boolean canContinueToUse() {
        return this.target != null && this.target.isAlive() && this.mob.getAnimationId() == 1;
    }
}

