/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity.ai.goal.generic;

import com.ovinter.mythsandlegends.entity.MLEntity;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Path;

public class ChaseTargetGoal
extends Goal {
    private final MLEntity mob;
    private final boolean followingTargetEvenIfNotSeen;
    private Path path;
    private int delayCounter;
    protected final double moveSpeed;

    public ChaseTargetGoal(MLEntity mob, boolean pFollowingTargetEvenIfNotSeen, double pMoveSpeed) {
        this.mob = mob;
        this.followingTargetEvenIfNotSeen = pFollowingTargetEvenIfNotSeen;
        this.moveSpeed = pMoveSpeed;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        LivingEntity target = this.mob.getTarget();
        return target != null && target.isAlive();
    }

    public void start() {
        this.mob.getNavigation().moveTo(this.path, this.moveSpeed);
        this.mob.setAggressive(true);
        this.mob.setRunning(true);
    }

    public void stop() {
        this.mob.getNavigation().stop();
        LivingEntity livingentity = this.mob.getTarget();
        if (!EntitySelector.NO_CREATIVE_OR_SPECTATOR.test(livingentity)) {
            this.mob.setTarget(null);
        }
        this.mob.setAggressive(false);
        this.mob.setRunning(false);
        this.mob.getNavigation().stop();
    }

    public boolean canContinueToUse() {
        LivingEntity target = this.mob.getTarget();
        if (target == null) {
            return false;
        }
        if (!target.isAlive()) {
            return false;
        }
        if (!this.followingTargetEvenIfNotSeen) {
            return !this.mob.getNavigation().isDone();
        }
        if (!this.mob.isWithinRestriction(target.blockPosition())) {
            return false;
        }
        return !(target instanceof Player) || !target.isSpectator() && !((Player)target).isCreative();
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        LivingEntity target = this.mob.getTarget();
        if (target != null) {
            this.mob.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
            double distSq = this.mob.distanceToSqr(target.getX(), target.getBoundingBox().minY, target.getZ());
            if (--this.delayCounter <= 0) {
                this.delayCounter = 4 + this.mob.getRandom().nextInt(7);
                if (distSq > Math.pow(this.mob.getAttribute(Attributes.FOLLOW_RANGE).getValue(), 2.0)) {
                    if (!this.mob.isPathFinding() && !this.mob.getNavigation().moveTo((Entity)target, 1.0)) {
                        this.delayCounter += 5;
                    }
                } else {
                    this.mob.getNavigation().moveTo((Entity)target, this.moveSpeed);
                }
            }
        }
    }
}

